<?php
require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';

/**
 *
 * Invocation tag plugin.
 *
 */
 
class Plugins_InvocationTags_OxInvocationTags_NativeImageAsyn extends Plugins_InvocationTags
{


    var $defaultZone = OX_ZoneNativeImage;

    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("Native Asyn Image");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'Native Asyn Image';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
     function isAllowed($extra = null)
    {
		return true;
        $isAllowed = parent::isAllowed($extra);
        if(is_array($extra) || (is_array($extra) && ( $extra['delivery'] == 8 ||  $extra['delivery'] == 9)  )) {
            return false;
        } else {
            return $isAllowed;
        }
    }

    function getOrder()
    {
        parent::getOrder();
        return 15;
    } 

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options = array (
            'row'     => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'column'     => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
           // 'refresh'     => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
        );
        return $options;
    }

      /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Backup Comment' => "",
            'SSL Delivery Comment' => "",
            'Comment'              => "",
        );
        parent::prepareCommonInvocationData($aComments);

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;

        $buffer = $mi->buffer;

        if (isset($mi->block) && $mi->block == '1') {
            $mi->parameters['block'] = "block=1";
        }
        if (isset($mi->blockcampaign) && $mi->blockcampaign == '1') {
            $mi->parameters['blockcampaign'] = "blockcampaign=1";
        }

        $row=$mi->row;
        $column=$mi->column;
        $refresh=$mi->refresh;

        if (isset($mi->row)) {
            $mi->parameters['row'] = "row=".$row;
        }
        if (isset($mi->column)) {
            $mi->parameters['column'] = "column=".$column;
        }
        //~ if (isset($mi->refresh)) {
            //~ $mi->parameters['refreshbanners'] = "refresh=".$refresh;
        //~ }
        
        
                $admin_path='//'.$conf['webpath']['admin'].'/plugins/NativeRecommended/delivery/nativeads_asyncjs.php';

        // The cachebuster for async tags isn't needed
        unset($mi->parameters['cb']);

        // Add ID
        $mi->parameters['id'] = 'id='.md5("{$conf['webpath']['delivery']}*{$conf['webpath']['deliverySSL']}");

        // Remap as tag attributes with data-revive prefix
        $mi->parameters = array_map(function ($v) use ($conf) {
            return preg_replace('#^(.*)=(.*)$#', 'data-'.$conf['var']['product'].'-$1="$2"', $v);
        }, $mi->parameters);

        $buffer .= "<ins ".join(" ", $mi->parameters)."></ins>".PHP_EOL;
        if ($conf['webpath']['delivery'] == $conf['webpath']['deliverySSL']) {
            // Yes, we can use the short version!
            $buffer .= '<script async src="'.$admin_path.'"></script>';
        } else {
            // Bummer, we need the longer variant
            $url = array(
                $admin_path,
                $admin_path,
            );
            $buffer.= <<<EOF
<script>
(function () {
  var d = document, s = d.createElement('script'), p = d.location.protocol,
      i = d.getElementsByTagName('ins'), j = i[i.length-1];
  try {
    s.src = p === 'http:' ? '{$url[0]}' :
      '{$url[1]}';
    s.async = true; j.appendChild(s);
  } catch (e) {}
})();
</script>
EOF;
        }

        return $buffer;
    }

 
    function setInvocation(&$invocation) {

        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;

    }


}

?>
