<?php   
   
   header("Access-Control-Allow-Origin: *");
   header("Content-Type: application/json; charset=UTF-8");
   header("Access-Control-Allow-Methods: POST");
   header("Access-Control-Max-Age: 3600");
   header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

   require_once '../../../../init.php';
      
   ## Required files
   require_once MAX_PATH . '/lib/OA/Dal.php';      
   require_once MAX_PATH . '/lib/OA/Admin/Option.php';
   require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
   require_once MAX_PATH . '/www/admin/config.php';
   require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
     
   if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
   }

   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];


   $data = array(); 

   ## INITIALISATIN
   $getQuery = '';
   $limit = "";
   $id = "";
   $data_type = "";
   $condition = '';
   $key_join = "";
	
	$ele1 = '';
	$ele2 = '';
	$ele3 = 'sv.interval_start, ';
	$ele4 = 'sv.interval_start, ';
	$ele5 = '';

   $labels = array();
   $request =array();
   $impressions = array();
   $clicks = array();
   $conversions = array();
   $views = array();
   $ecpm = array();
   $vecpm = array();
   $ctr = array();
   $total_revenue = array();

   ## ACCOUNT TYPE
   if(isset($_POST['id']) && !empty($_POST['id'])) {
      $id = explode('=', $_POST['id']);
   }

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND rf.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }
   

   ## REQUIRED POST VALIES
   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $line_dimension = $_POST['line_dimension'];
   $total_record = $_POST['count'];
   $rowperpage = $_POST['length']; // Rows display per page
   $columnIndex = $_POST['order'][0]['column']; // Column index
   $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
   $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
   $searchValue = $_POST['search']['value']; // Search value


 
    ## RECORD COUNT
    if ($rowperpage == -1) {
        $limit = "";    ## ALL RECORDS
    }else{
        $limit = "limit ".$_POST['start'].",".$_POST['length']; ## LIMITTED RECORDS
    }

	## LINE DIMENSION	
	$data_type = "";
	$length  = sizeof($line_dimension);
	$i = 0;

	if(!$line_dimension[0]) {

		$data_type = " c.description AS data_type";
		$ele1 = 'b.bannerid, b.description';
		$ele2 = 'c.bannerid, c.description';
		$ele3 = 'rb.bannerid, rb.description';
		$ele4 = 'rb.bannerid, rb.description';
		$ele5 = 'b.bannerid';

	}else{
			
		foreach ($line_dimension as $key) {

			if($key == 11) {

				$data_type .= " c.description AS data_type";
				$ele1 .= 'b.bannerid, b.description';
				$ele2 .= 'c.bannerid, c.description';
				$ele3 .= 'rb.bannerid, rb.description';
				$ele4 .= 'rb.bannerid, rb.description';
				$ele5 .= 'b.bannerid';

			}else if($key == 1){

				$data_type .= " c.clientname AS data_type";
				$ele1 .= 'b.clientid, b.clientname';
				$ele2 .= 'c.clientid, c.clientname';
				$ele3 .= 'cl.clientid, cl.clientname';
				$ele4 .= 'cl.clientid, cl.clientname';
				$ele5 .= 'b.clientid';

			}else if($key == 2){

				$data_type .= " c.campaignname AS data_type";
				$ele1 .= 'b.campaignid, b.campaignname';
				$ele2 .= 'c.campaignid, c.campaignname';
				$ele3 .= 'rc.campaignid, rc.campaignname';
				$ele4 .= 'rc.campaignid, rc.campaignname';
				$ele5 .= 'b.campaignid';

			}else if($key == 3){

				$data_type .= " c.names AS data_type";
				$ele1 .= 'b.affiliateid, b.names';
				$ele2 .= 'c.affiliateid, c.names';
				$ele3 .= 'rf.affiliateid, rf.name';
				$ele4 .= 'rf.affiliateid, rf.name as names';
				$ele5 .= 'b.affiliateid';

			}else if($key == 4){

				$data_type .= " c.name AS data_type";
				$ele1 .= 'b.id, b.name';
				$ele2 .= 'c.id, c.name';
				$ele3 .= 'p.id, p.name';
				$ele4 .= 'p.id, p.name';
				$ele5 .= 'b.id';

			}else if($key == 5){

				$data_type .= " c.zonename AS data_type";
				$ele1 .= 'b.zoneid, b.zonename';
				$ele2 .= 'c.zoneid, c.zonename';
				$ele3 .= 'rz.zoneid, rz.zonename';
				$ele4 .= 'rz.zoneid, rz.zonename';
				$ele5 .= 'b.zoneid';

			}else if($key == 6){

				$data_type .= " DATE(c.interval_start) AS data_type";
				$ele1 .= 'b.interval_start';
				$ele2 .= 'c.interval_start';
				$ele3 .= 'sv.creative_id';
				$ele4 .= 'sv.creative_id';
				$ele5 .= 'b.interval_start';

			}else if($key == 7){

				$data_type .= " c.keyword AS data_type";
				$ele1 .= 'b.keyword';
				$ele2 .= 'c.keyword';
				$ele3 .= 'sk.keyword';
				$ele4 .= 'sk.keyword';
				$ele5 .= 'b.keyword';
				$key_join = " INNER JOIN {$table_prefix}stats_vast_keyword sk
	                       			ON sk.zone_id = rz.zoneid ";
			}else if($key == 8){

				$data_type .= " c.category AS data_type";
				$ele1 .= 'b.category';
				$ele2 .= 'c.category';
				$ele3 .= 'sv.category';
				$ele4 .= 'sv.category';
				$ele5 .= 'b.category';
			}
			if($i < ($length-1)){
				$ele1 .= ',';
				$ele2 .= ',';
				$ele3 .= ',';
				$ele4 .= ',';
				$ele5 .= ',';
				$data_type .= ',';
			}$i++;
		}
	}

	// die($data_type);
	## Fetch records
	$getQuery = OA_Dal_Delivery_Query("SELECT {$data_type},
					MAX(IF(c.vast_event_id = 1, c.count, 0)) AS start,
					MAX(IF(c.vast_event_id = 2, c.count, 0)) AS midpoint,
					MAX(IF(c.vast_event_id = 6, c.count, 0)) AS mute,
					MAX(IF(c.vast_event_id = 7, c.count, 0)) AS fullscreen,
					MAX(IF(c.vast_event_id = 8, c.count, 0)) AS stop,
					MAX(IF(c.vast_event_id = 22, c.count, 0)) AS close FROM (SELECT Sum(b.count) AS count,b.vast_event_id,{$ele1}
			FROM   (SELECT SUM(sv.count) AS count, 
			               sv.vast_event_id, 
                		   {$ele4}
			        FROM   {$table_prefix}stats_vast sv 
			               INNER JOIN {$table_prefix}zones rz 
			                       ON sv.zone_id = rz.zoneid
	                       INNER JOIN {$table_prefix}affiliates rf 
			                       ON rf.affiliateid = rz.affiliateid 
			               INNER JOIN {$table_prefix}banners rb 
			                       ON sv.creative_id = rb.bannerid 
	                       INNER JOIN {$table_prefix}campaigns rc
	                       			ON rc.campaignid = rb.campaignid 
	                       INNER JOIN {$table_prefix}clients cl
	                       			ON cl.clientid = rc.clientid 
	                       INNER JOIN {$table_prefix}publishers p
	                       			ON p.id = rf.publisher_id 
	                       			".$key_join."
			        WHERE  Date(sv.interval_start) >= '".$start_date."' 
			               AND Date(sv.interval_start) <= '".$end_date."' ".$condition."
			        GROUP  BY sv.vast_event_id,{$ele3} ) b 
			GROUP  BY b.vast_event_id,{$ele5}
			ORDER  BY b.interval_start)  c GROUP BY {$ele2} ");

    $data = array();

	if (OA_Dal_Delivery_numRows($getQuery) > 0) {

		while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) {

			$labels[] = (strlen($aRow['data_type']) > 15 ? substr($aRow['data_type'],0,15)."..." : $aRow['data_type']);
			$start[] = $aRow['start'];
			$midpoint[] = $aRow['midpoint'];
			$mute[] = $aRow['mute'];
			$fullscreen[] = $aRow['fullscreen'];
			$stop[] = $aRow['stop'];
		}
    }

	$data = array('labels' => $labels,'start' => $start, 'midpoint' => $midpoint, 'mute'=>$mute, 'fullscreen'=>$fullscreen, 'stop'=>$stop);
   		
   	echo json_encode($data);
	exit();
