<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
	

	// Required files
	require_once '../../../../init.php';
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	
    ##DB
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   	$clientid = ($_POST['clientid'] ? : '');
   	$campaignid = ($_POST['campaignid'] ? : '');
   	$zoneid = ($_POST['zoneid'] ? : '');
   	$cur_date = $_POST['cur_date'];
   	$type = $_POST['type'];


   	## Read value
	$draw = $_POST['draw'];
	$row = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value
	$condition = "";


   	//~ACCOUNT TYPE
   	if ($_POST['id']) {
   		$id = explode('=', $_POST['id']);
   	}

	if(isset($id[0]) && $id[0] == 'manager'){
		$condition = 'AND cl.agencyid = '.$id[1];
	}

	$id = explode("=", $_POST['id']);
	$getQuery = '';
	$data = array();


	## Keyword BASED
	if ($cur_date && $type == 7) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT adh.keyword AS name, cl.clientname as data_type1, c.campaignname AS data_type2, b.description AS data_type3, p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date as data_type7, SUM(adh.impression) AS impressions, SUM(adh.view) AS views, SUM(adh.convertion) AS conversions, SUM(adh.click) AS clicks FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_keyword_report adh ON adh.creative_id = b.bannerid LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id WHERE adh.date = '{$format}' ".$condition." GROUP BY adh.date");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 

	## OS BASED
	else if ($cur_date && $type == 8) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT sc.os AS name, sc.os_version AS name1, cl.clientname as data_type1, c.campaignname as data_type2,b.description as data_type3, p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date_time as data_type7, sco.country as data_type8, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id LEFT JOIN {$table_prefix}stats_client sc ON sc.zone_id = adh.zone_id LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	}  

	## Device BASED
	else if ($cur_date && $type == 9) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT sc.device AS name, sc.device_version AS name1, cl.clientname as data_type1, c.campaignname as data_type2,b.description as data_type3, p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date_time as data_type7, sco.country as data_type8, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id LEFT JOIN {$table_prefix}stats_client sc ON sc.zone_id = adh.zone_id LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	}  

	## Geo BASED
	else if ($cur_date && $type == 10) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT sco.country AS name, sco.region as name1, sco.city as data_type3, sco.latitude as data_type4, sco.longitude as data_type5, cl.clientname as data_type6, c.campaignname as data_type7, b.description as data_type8, p.name as data_type9, a.name as data_type10, z.zonename as data_type11, adh.date_time as data_type12, sco.ISP as data_type13, sco.DMA as data_type14, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	}  


	## Video BASED
	else if ($cur_date && $type == 11) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT sco.country AS name, sco.region as data_type2, c.campaignname as data_type2,b.description as data_type3,p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date_time as data_type7, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	}  

	$output_data = array();

	if (isset($data) && !empty($data)) {

		foreach ($data as $key => $row) {

			$passback = $row['requests'] - $row['impressions'];

			$output_data[] = array(
		      	"name"=>($row['name']) ? $row['name'] : "-",
		      	"name1"=>($row['name1']) ? $row['name1'] : "-",
                "data_type1"=>($row['data_type1']) ? $row['data_type1'] : '-',
                "data_type2"=>($row['data_type2']) ? $row['data_type2'] : '-',
                "data_type3"=>($row['data_type3']) ? $row['data_type3'] : '-',
                "data_type4"=>($row['data_type4']) ? $row['data_type4'] : '-',
                "data_type5"=>($row['data_type5']) ? $row['data_type5'] : '-',
                "data_type6"=>($row['data_type6']) ? $row['data_type6'] : '-',
                "data_type7"=>($row['data_type7']) ? $row['data_type7'] : '-',
                "data_type8"=>($row['data_type8']) ? $row['data_type8'] : '-',
                "data_type9"=>($row['data_type9']) ? $row['data_type9'] : '-',
                "data_type10"=>($row['data_type10']) ? $row['data_type10'] : '-',
                "data_type11"=>($row['data_type11']) ? $row['data_type11'] : '-',
                "data_type12"=>($row['data_type12']) ? $row['data_type12'] : '-',
                "data_type13"=>($row['data_type13']) ? $row['data_type13'] : '-',
                "data_type14"=>($row['data_type14']) ? $row['data_type14'] : '-',
		      	"impressions"=>($row['impressions'] ? : 0),
		      	"passback"=>($passback ? : 0),
		      	"views"=>($row['views'] ? : 0),
		      	"request"=>($row['requests'] ? : 0),
		      	"clicks"=>($row['clicks'] ? : 0),
		      	"conversions"=>($row['conversions'] ? : 0),

                "ctr" => ($row['impressions'] > 0)? round($row['clicks']/$row['impressions']*100, 2) : 0.00,
                "vctr" => ($row['views'] > 0) ? round($row['clicks']/$row['views'] *100, 2) : 0.00,
                "ecpm" => ($row['impressions'] > 0) ? round(($row['total_revenue'] / $row['impressions']) * 1000, 2) : 0.00,
                "vecpm" => ($row['views'] > 0) ? round(($row['total_revenue'] / $row['views']) * 1000, 2) : 0.00,
                "pub_income" => ( $row['pub_income'] >0) ? $row['pub_income'] : 0.00,
                "total_revenue" => ($row['total_revenue'] > 0)? $row['total_revenue'] : 0.00,
                "ad_fill" => ($row['requests'] > 0) ? round(($row['impressions'] / $row['requests'] ) * 100, 2):0,
		   );
		}	   
	}
	

	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => 24,
	  "iTotalDisplayRecords" => 24,
	  "aaData" => $output_data
	);

	echo json_encode($response);
	exit();
?>
    
		