<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
	

	// Required files
	require_once '../../../../init.php';
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	
    ##DB
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   	$clientid = ($_POST['clientid'] ? : '');
   	$campaignid = ($_POST['campaignid'] ? : '');
   	$zoneid = ($_POST['zoneid'] ? : '');
   	$cur_date = $_POST['cur_date'];
   	$type = $_POST['type'];


   	## Read value
	$draw = $_POST['draw'];
	$row = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value
	$condition = "";


   	//~ACCOUNT TYPE
   	if ($_POST['id']) {
   		$id = explode('=', $_POST['id']);
   	}

	if(isset($id[0]) && $id[0] == 'manager'){
		$condition = 'AND cl.agencyid = '.$id[1];
	}

	$id = explode("=", $_POST['id']);
	$getQuery = '';
	$data = array();


	## ADVERTISER BASED
	if ($cur_date && $type == 1) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT cl.clientname AS name,c.campaignname as data_type2,b.description as data_type3,p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date_time as data_type7,  sco.country AS data_type8, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 


	## CAMPAIGN BASED
	else if ($cur_date && $type == 2) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT c.campaignname AS name ,cl.clientname as data_type1, b.description as data_type2, p.name as data_type3, a.name as data_type4, z.zonename as data_type5, adh.date_time as data_type6, sco.country AS data_type7, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 


	## WEBSITE BASED
	else if ($cur_date && $type == 3) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT a.name,cl.clientname AS data_type1, c.campaignname as data_type2,b.description as data_type3,p.name as data_type4, z.zonename as data_type5, adh.date_time as data_type6, sco.country AS data_type7, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 


	## CATEGORY BASED
	else if ($cur_date && $type == 4) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT ss.category AS name, cl.clientname AS data_type1, c.campaignname as data_type2,b.description as data_type3,p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date_time as data_type7, sco.country AS data_type8, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  LEFT JOIN {$table_prefix}stats_site ss ON ss.zone_id = adh.zone_id WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 

	## Adsize BASED
	else if ($cur_date && $type == 5) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT CONCAT(z.width,'X', z.height) AS name, z.width, z.height, cl.clientname as data_type1, c.campaignname as data_type2,b.description as data_type3,p.name as data_type4, a.name as data_type5, z.zonename as data_type6, adh.date_time as data_type7, sco.country AS data_type8, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 

	## Zone BASED
	else if ($cur_date && $type == 6) {

		for ($i=0; $i <24 ; $i++){

			$changeDate = date("Y-m-d", strtotime($cur_date));
			$format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';

			$getQuery = OA_Dal_Delivery_Query("SELECT z.zonename AS name, cl.clientname AS data_type1, c.campaignname as data_type2,b.description as data_type3,p.name as data_type4, a.name as data_type5, adh.date_time as data_type6, sco.country AS data_type7, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  WHERE adh.ad_id > 0 AND adh.date_time = '{$format}' ".$condition." GROUP BY adh.date_time");

			$data[] = OA_Dal_Delivery_fetchAssoc($getQuery);
			$data[$i]['data_type'] = $format;
		}


	} 

	$output_data = array();

	if (isset($data) && !empty($data)) {

		foreach ($data as $key => $row) {

			$passback = $row['requests'] - $row['impressions'];
	     
		    $name = '';

		    if($type == 5){
			    if( $row['width'] == '-1' && $row['height'] == '-1'){
			        $name = 'Image';
			    }else if( $row['width'] == '-2' && $row['height'] == '-2'){
			        $name = 'Overlay';
			    }else if( $row['width'] == '-3' && $row['height'] == '-3'){
			        $name = 'Inline';
			    }else if( $row['width'] == '-6' && $row['height'] == '-6'){
			        $name = 'Inline';
			    }else if( $row['width'] == '-7' && $row['height'] == '-7'){
			        $name = 'Audio';
			    }else if( $row['width'] == '-9' && $row['height'] == '-9'){
			        $name = 'Audio';
			    }else if( $row['width'] == '-10' && $row['height'] == '-10'){
			        $name = 'Outstream';
			    }else if( $row['width'] == '-8' && $row['height'] == '-8'){
			        $name = 'Inline';
			    }else{
			        $name = $row['name'];
			    }
		    }else{
			        $name = $row['name'];
			    }


			$output_data[] = array(
		      	"name"=>($name) ? $name : "-",
		      	"data_type1"=>($type == 5 || $type==2 || $type==4 || $type==3|| $type==6) ? $row['data_type1'] : (($row['name']) ? $row['name'] : "-"),
                "data_type2"=>($row['data_type2']) ? $row['data_type2'] : '-',
                "data_type3"=>($row['data_type3']) ? $row['data_type3'] : '-',
                "data_type4"=>($row['data_type4']) ? $row['data_type4'] : '-',
                "data_type5"=>($row['data_type5']) ? $row['data_type5'] : '-',
                "data_type6"=>($row['data_type6']) ? $row['data_type6'] : '-',
                "data_type7"=>($row['data_type7']) ? $row['data_type7'] : '-',
                "data_type8"=>($row['data_type8']) ? $row['data_type8'] : '-',
		      	"impressions"=>($row['impressions'] ? : 0),
		      	"passback"=>($passback ? : 0),
		      	"views"=>($row['views'] ? : 0),
		      	"request"=>($row['requests'] ? : 0),
		      	"clicks"=>($row['clicks'] ? : 0),
		      	"conversions"=>($row['conversions'] ? : 0),

                "ctr" => ($row['impressions'] > 0)? round($row['clicks']/$row['impressions']*100, 2) : 0.00,
                "vctr" => ($row['views'] > 0) ? round($row['clicks']/$row['views'] *100, 2) : 0.00,
                "ecpm" => ($row['impressions'] > 0) ? round(($row['total_revenue'] / $row['impressions']) * 1000, 2) : 0.00,
                "vecpm" => ($row['views'] > 0) ? round(($row['total_revenue'] / $row['views']) * 1000, 2) : 0.00,
                "pub_income" => ( $row['pub_income'] >0) ? $row['pub_income'] : 0.00,
                "total_revenue" => ($row['total_revenue'] > 0)? $row['total_revenue'] : 0.00,
                "ad_fill" => ($row['requests'] > 0) ? round(($row['impressions'] / $row['requests'] ) * 100, 2):0,
		   );
		}	   
	}
	

	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => 24,
	  "iTotalDisplayRecords" => 24,
	  "aaData" => $output_data
	);

	echo json_encode($response);
	exit();
?>
    
		