<?php
	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

      
	## Required files
	require_once '../../../../init.php';
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';


	## DB
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

     
	## INITIALISATIN
   	$condition = '';
   	$getQuery = '';
   	$limit = "";
   	$id = "";
   	$groupby = "";
   	$data_type = " adh.os AS data_type1 ";


   	## REQUIRED POST VALIES
   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   	$start_date = $_POST['start_date'];
   	$end_date = $_POST['end_date'];
   	$line_dimension = $_POST['line_dimension'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value


   ## ACCOUNT TYPE
   if(isset($_POST['id']) && !empty($_POST['id'])) {
      $id = explode('=', $_POST['id']);
   }

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND a.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }

   
	## RECORD COUNT
	if ($rowperpage == -1) {
		$limit = "";	## ALL RECORDS
	}else{
		$limit = "limit ".$_POST['start'].",".$_POST['length'];	## LIMITTED RECORDS
	}

	## LINE DIMENSION

	if(!$line_dimension[0]) {

		$groupby = " GROUP BY adh.os ";

	}else{
		
		$groupby = " GROUP BY ";
		$data_type = "";
		$length  = sizeof($line_dimension);
		$i = 0;

		foreach ($line_dimension as $key) {

			if($key == 1){

				$groupby .= "cl.clientid ";
				$data_type .= " cl.clientname AS data_type1";

			}else if($key == 2){

				$groupby .= "c.campaignid ";
				$data_type .= " c.campaignname AS data_type2";

			}else if($key == 3){

				$groupby .= "b.bannerid ";
				$data_type .= " b.description AS data_type3";

			}else if($key == 4){

				$groupby .= "p.id ";
				$data_type .= " p.name AS data_type4";

			}else if($key == 5){

				$groupby .= "a.affiliateid ";
				$data_type .= " a.name AS data_type5";

			}else if($key == 6){

				$groupby .= "z.zonename ";
				$data_type .= " z.zonename AS data_type6";

			}else if($key == 7){

				$groupby .= "DATE(adh.datetime) ";
				$data_type .= " DATE(adh.datetime) AS data_type7";

			}else if($key == 8){

				$groupby .= "adh.country ";
				$data_type .= " adh.country AS data_type8";

			}$i++;
			if($i < $length){
				$groupby .= ',';
				$data_type .= ',';
			}
		}
	}

	//TOTAL RECORD COUNT

	$total_record = OA_Dal_Delivery_Query(" SELECT count(cl.clientname) AS count FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_Dev_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id WHERE adh.ad_id > 0 AND b.exchange_id IS NULL AND DATE(adh.datetime) >= '".$start_date."' AND DATE(adh.datetime) <= '". $end_date."' ".$condition." ".$groupby);

	$total_record = OA_Dal_Delivery_numRows($total_record);

	$getQuery = " SELECT {$data_type}, adh.os AS name, SUM(adh.requests) AS requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) AS views, SUM(adh.conversions) AS conversions, SUM(adh.pub_price) AS pub_income, SUM(adh.price) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_Dev_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id  WHERE adh.ad_id > 0 AND b.exchange_id IS NULL AND DATE(adh.datetime) >= '".$start_date."' AND DATE(adh.datetime) <= '". $end_date."' ".$condition." ".$groupby.$limit;
	
	$data = array();
	$getQuery = OA_Dal_Delivery_Query($getQuery);

	if (isset($getQuery) && !empty($getQuery)) {

		while ($row = OA_Dal_Delivery_fetchAssoc($getQuery)) {

		   	$passback = $row['requests'] - $row['impressions'];

		   	if($passback < 0){
		   		$row['impressions'] = $row['impressions'] + $passback;
		   		$passback = 0;
		   	}

		   	$data[] = array(

		   		"name"=>($row['name']) ? $row['name']: '-',
		   		"os_version"=>($row['os_version']) ? $row['os_version']: '-',
                "data_type1"=>($row['data_type1'] ? $row['data_type1'] : '-'),
                "data_type2"=>($row['data_type2']) ? $row['data_type2'] : '-',
                "data_type3"=>($row['data_type3']) ? $row['data_type3'] : '-',
                "data_type4"=>($row['data_type4']) ? $row['data_type4'] : '-',
                "data_type5"=>($row['data_type5']) ? $row['data_type5'] : '-',
                "data_type6"=>($row['data_type6']) ? $row['data_type6'] : '-',
                "data_type7"=>($row['data_type7']) ? $row['data_type7'] : '-',
                // "data_type7"=>(in_array(7, $line_dimension) ? '<a href="javascript:void(0)" class="time-data" cur_date="'.$row['data_type7'].'">'.$row['data_type7'].'</a>' : $row['data_type7']),
                "data_type8"=>($row['data_type8']) ? $row['data_type8'] : '-',

		      	"request"=>$row['requests'],
		      	"impressions"=>$row['impressions'],
		      	"passback"=>$passback,
		      	"views"=>$row['views'],
		      	"clicks"=>$row['clicks'],
		      	"conversions"=>$row['conversions'],

                "ctr" => ($row['impressions'] > 0)? round($row['clicks']/$row['impressions']*100, 2) : 0.00,
                "vctr" => ($row['views'] > 0) ? round($row['clicks']/$row['views'] *100, 2) : 0.00,
                "ecpm" => ($row['impressions'] > 0) ? round(($row['total_revenue'] / $row['impressions']) * 1000, 2) : 0.00,
                "vecpm" => ($row['views'] > 0) ? round(($row['total_revenue'] / $row['views']) * 1000, 2) : 0.00,
                "pub_income" => ( $row['pub_income'] >0) ? $row['pub_income'] : 0.00,
                "total_revenue" => ($row['total_revenue'] > 0)? $row['total_revenue'] : 0.00,
                "ad_fill" => ($row['requests'] > 0) ? round(($row['impressions'] / $row['requests'] ) * 100, 2):0,
		   );
		}
	}
	

	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => $total_record,
	  "iTotalDisplayRecords" => $total_record,
	  "aaData" => $data
	);

	echo json_encode($response);
	exit();
?>
    
		
