<?php  
   
   header("Access-Control-Allow-Origin: *");
   header("Content-Type: application/json; charset=UTF-8");
   header("Access-Control-Allow-Methods: POST");
   header("Access-Control-Max-Age: 3600");
   header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

   require_once '../../../../init.php';
      
   ## Required files
   require_once MAX_PATH . '/lib/OA/Dal.php';      
   require_once MAX_PATH . '/lib/OA/Admin/Option.php';
   require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
   require_once MAX_PATH . '/www/admin/config.php';
   require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
     
   if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
   }

   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];


   $data = array(); 

   $labels = array();
   $request =array();
   $impressions = array();
   $clicks = array();
   $convertions = array();
   $views = array();
   $ecpm = array();
   $vecpm = array();
   $ctr = array();
   $vctr = array();

   ## ACCOUNT TYPE
   if(isset($_POST['ids']) && !empty($_POST['ids'])) {
      $id = explode('=', $_POST['ids']);
   }

   $condition = '';

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND a.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }

   
   ## INITIALISATIN
   $getQuery = '';
   $limit = "";
   $id = "";
   $groupby = "";
   $data_type = " adh.keyword AS data_type ";

   ## REQUIRED POST VALIES
   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];
   $total_record = $_POST['count'];
   $rowperpage = $_POST['length']; // Rows display per page
   $columnIndex = $_POST['order'][0]['column']; // Column index
   $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
   $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
   $searchValue = $_POST['search']['value']; // Search value



   ## LINE DIMENSION
   if(!$line_dimension[0]) {

      $groupby = " GROUP BY adh.keyword ";

   }else{
      
      $groupby = " GROUP BY adh.keyword ,  ";
      $data_type = "";
      $length  = sizeof($line_dimension);
      $i = 0;

      foreach ($line_dimension as $key) {

     	if($key == 1){

			$groupby .= "cl.clientid ";
			$data_type .= " cl.clientname AS data_type";

		}else if($key == 2){

			$groupby .= "c.campaignid ";
			$data_type .= " c.campaignname AS data_type";

		}else if($key == 3){

			$groupby .= "b.bannerid ";
			$data_type .= " b.description AS data_type";

		}else if($key == 4){

			$groupby .= "p.id ";
			$data_type .= " p.name AS data_type";

		}else if($key == 5){

			$groupby .= "a.affiliateid ";
			$data_type .= " a.name AS data_type";

		}else if($key == 6){

			$groupby .= "z.zonename ";
			$data_type .= " z.zonename AS data_type";

		}else if($key == 7){

			$groupby .= "DATE(adh.date) ";
			$data_type .= " adh.date AS data_type";

		}
		else
		{
			$groupby .= "adh.keyword  ";
			$data_type .= " adh.keyword  AS data_type"; 
		}	

		$i++;
		if($i < $length){
			$groupby .= ',';
			$data_type .= ',';
		}

      }
   }

   $getQuery = " SELECT {$data_type}, adh.keyword AS name, SUM(adh.request) as request, SUM(adh.impression) AS impressions, SUM(adh.view) AS views, SUM(adh.convertion) AS convertions, SUM(adh.click) AS clicks FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_keyword_report adh ON adh.creative_id = b.bannerid LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id WHERE adh.creative_id > 0 AND DATE(adh.date) >= '".$start_date."' AND DATE(adh.date) <= '". $end_date."' ".$condition." ".$groupby. " ORDER BY adh.keyword ASC " . $_POST['limit'];
    
   $data = array();
   $getQuery = OA_Dal_Delivery_Query($getQuery);

   
   while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) 
   {
      $labels[] = $aRow['data_type'];
      $impressions[] = $aRow['impressions'];
      $clicks[] = $aRow['clicks'];
      $views[] = $aRow['views'];
      $convertions[] = $aRow['convertions'];  
      $request[] = $aRow['request'];
      $ctr[] = ($aRow['impressions'] > 0)? round($aRow['clicks']/$aRow['impressions']*100, 2) : 0.00;
   }

   $data = array('labels' => $labels , 'request' => $request, 'impressions' => $impressions, 'clicks' => $clicks, 'views' => $views, 'ctr' => $ctr);

   echo json_encode($data);
   exit();
