<?php 
  
   header("Access-Control-Allow-Origin: *");
   header("Content-Type: application/json; charset=UTF-8");
   header("Access-Control-Allow-Methods: POST");
   header("Access-Control-Max-Age: 3600");
   header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

   require_once '../../../../init.php';
      
   ## Required files
   require_once MAX_PATH . '/lib/OA/Dal.php';      
   require_once MAX_PATH . '/lib/OA/Admin/Option.php';
   require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
   require_once MAX_PATH . '/www/admin/config.php';
   require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
     
   if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
   }

   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];


   $data = array(); 

   $labels = array();
   $request =array();
   $impressions = array();
   $clicks = array();
   $conversions = array();
   $views = array();
   $ecpm = array();
   $vecpm = array();
   $ctr = array();
   $total_revenue = array();

   ## ACCOUNT TYPE
   if(isset($_POST['id']) && !empty($_POST['id'])) {
      $id = explode('=', $_POST['id']);
   }

   $condition = '';

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND a.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }

   
   ## INITIALISATIN
   $getQuery = '';
   $limit = "";
   $id = "";
   $groupby = "";
   $data_type = " sco.country AS data_type1 ";

   ## REQUIRED POST VALIES
   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];
   $total_record = $_POST['count'];
   $rowperpage = $_POST['length']; // Rows display per page
   $columnIndex = $_POST['order'][0]['column']; // Column index
   $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
   $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
   $searchValue = $_POST['search']['value']; // Search value



   ## LINE DIMENSION
   if(!$line_dimension[0]) {

      $groupby = " GROUP BY sco.country ";

   }else{
      
      $groupby = " GROUP BY ";
      $data_type = "";
      $length  = sizeof($line_dimension);
      $i = 0;

        foreach ($line_dimension as $key) {
            
            if($key == 1){

                $groupby .= "sco.country ";
                $data_type .= " sco.country AS data_type1";

            }else if($key == 2){

                $groupby .= "sco.region ";
                $data_type .= " sco.region AS data_type2";

            }else if($key == 3){

                $groupby .= "sco.city ";
                $data_type .= " sco.city AS data_type3";

            }else if($key == 4){

                $groupby .= "sco.latitude ";
                $data_type .= " sco.latitude AS data_type4";

            }else if($key == 5){

                $groupby .= "sco.longitude ";
                $data_type .= " sco.longitude AS data_type5";

            }else if($key == 6){

                $groupby .= "cl.clientid ";
                $data_type .= " cl.clientname AS data_type6";

            }else if($key == 7){

                $groupby .= "c.campaignid ";
                $data_type .= " c.campaignname AS data_type7";

            }else if($key == 8){

                $groupby .= "b.bannerid ";
                $data_type .= " b.description AS data_type8";

            }else if($key == 9){

                $groupby .= "p.id ";
                $data_type .= " p.name AS data_type9";

            }else if($key == 10){

                $groupby .= "a.affiliateid ";
                $data_type .= " a.name AS data_type10";

            }else if($key == 11){

                $groupby .= "z.zonename ";
                $data_type .= " z.zonename AS data_type11";

            }else if($key == 12){

                $groupby .= "DATE(sco.date_time) ";
                $data_type .= " DATE(sco.date_time) AS data_type12";

            }
            $i++;
            if($i < $length){
                $groupby .= ',';
                $data_type .= ',';
            }
        }
    }

   $getQuery = "SELECT sco.country  as data_type, SUM(sco.requests) AS requests, SUM(sco.impressions) AS impressions, SUM(sco.clicks) AS clicks, SUM(sco.views) AS views, SUM(sco.conversions) AS conversions, SUM(sco.pub_income) AS pub_income, SUM(sco.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}stats_country sco ON sco.creative_id = b.bannerid  LEFT JOIN {$table_prefix}zones z ON z.zoneid = sco.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id WHERE sco.impressions!=0 AND sco.creative_id > 0 AND b.exchange_id IS NULL AND DATE(sco.date_time) >= '".$start_date."' AND DATE(sco.date_time) <= '". $end_date."' ".$condition." ".$groupby.$limit;
   
   $data = array();
   $getQuery = OA_Dal_Delivery_Query($getQuery);

   $values =array();

   while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) 
   {
      $labels[] = (strlen($aRow['data_type']) > 5 ? substr($aRow['data_type'],0,10)."..." : $aRow['data_type']);
      $requests[] = $aRow['requests'];
      $impressions[] = $aRow['impressions'];
      $clicks[] = $aRow['clicks'];
      $views[] = $aRow['views'];
      $conversions[] = $aRow['conversions'];
      $total_revenue[] = $aRow['total_revenue'];
      $country_code[] = $aRow['country_code'];

      
      $ctr[] = ($aRow['impressions'] > 0)? round($aRow['clicks']/$aRow['impressions']*100, 2) : 0.00;
      $ecpm[] = ($aRow['impressions'] > 0)? round($aRow['total_revenue']/$aRow['impressions']*1000, 2) : 0.00;
      $vecpm[] = ($aRow['views'] > 0)? round($aRow['total_revenue']/$aRow['views']*1000, 2) : 0.00;
      
      $values[] = array('code' => $aRow['country_code'], 'name' => $aRow['data_type'], 'requests' => $aRow['requests'],'impressions' => $aRow['impressions'], 'clicks' => $aRow['clicks'], 'views' => $aRow['views']);
   } 

//~ print_r($values);
// $values [] = array('code'=>"IND" , 
//       'name' => 'dddddddddddddd',
 
//       'views' => 'd'
// 		);
// $values [] = array('code'=>"US" , 
//       'name' => 'ddddd',
 
//       'views' => 'd'
// 		);
		

   $data = array('maps'=>$values, 'country'=> $labels, 'impressions' => $impressions, 'clicks' => $clicks, 'views'=>$views);

   echo json_encode($data);
   
   exit();
