<?php

    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    require_once '../../../../init.php';
      
    // Required files
    require_once MAX_PATH . '/lib/OA/Dal.php';      
    require_once MAX_PATH . '/lib/OA/Admin/Option.php';
    require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
    require_once MAX_PATH . '/www/admin/config.php';
    require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
    if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
    {
        require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
    }
    else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
    {
        require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
    }
    else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
    {
        require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
    }


    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];


    $clientid = $_POST['clientid'];
    $cur_date = $_POST['cur_date'];
    $type = $_POST['type'];
    $totalRecords = 24;
    $totalRecordwithFilter = 24;
    ## Read value
    $draw = $_POST['draw'];
    $row = $_POST['start'];
    $rowperpage = $_POST['length']; // Rows display per page
    $columnIndex = $_POST['order'][0]['column']; // Column index
    $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
    $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
    $searchValue = $_POST['search']['value']; // Search value
    $id = explode("=", $_POST['id']);

    $data = array();

    if ($clientid && $cur_date && $type == 1) {
        $advertiserQuery = OA_Dal_Delivery_Query("SELECT rc.country,IFNULL(rc.country, 'unknown') AS advertiser FROM  ".$table_prefix."stats_country rc WHERE rc.country = '".$clientid."'");

        $advertiserData = OA_Dal_Delivery_fetchAssoc($advertiserQuery);

        for ($i=0; $i <=24 ; $i++) { 
            $changeDate = date("Y-m-d", strtotime($cur_date));
            $format = $changeDate.($i <= 9 ? ' 0'.$i : ' '.$i).':00:00';            

            $getTimeReportQuery = OA_Dal_Delivery_Query("SELECT rc.country,rc.region,IFNULL(rc.country, 'unknown') AS advertiser,DATE_FORMAT(adh.date_time, '%H:%i:%s') AS data_type,SUM(adh.impressions) AS impressions,SUM(adh.clicks) AS clicks,SUM(adh.conversions) AS conversions,SUM(adh.views) AS views,sum(adh.requests) as requests, SUM((adh.clicks/adh.impressions)*100) as ctr,IF(SUM(adh.total_revenue) IS NULL, 0.00, FORMAT(SUM(adh.total_revenue),2)) AS total_revenue, IF(SUM(adh.impressions) > 0 AND SUM(adh.total_revenue) IS NOT NULL, FORMAT(((SUM(adh.total_revenue) * SUM(adh.impressions)) / 1000),2) , 0.00) AS ecpm, IF(SUM(adh.views) > 0 AND SUM(adh.total_revenue) IS NOT NULL, FORMAT(((SUM(adh.total_revenue) * SUM(adh.views)) / 1000),2) , 0.00) AS vecpm FROM ".$table_prefix."data_summary_ad_hourly adh LEFT JOIN ".$table_prefix."banners b ON adh.ad_id = b.bannerid LEFT JOIN ".$table_prefix."campaigns c ON c.campaignid = b.campaignid INNER JOIN ".$table_prefix."stats_country rc ON b.bannerid = rc.creative_id WHERE date_time = '".$format."' AND rc.country = '".$clientid."' GROUP BY rc.country,date_time");

                if($id[0] == 'clientid')
            {

                $getTimeReportQuery = OA_Dal_Delivery_Query("SELECT rc.country,rc.region,IFNULL(rc.country, 'unknown') AS advertiser,DATE_FORMAT(adh.date_time, '%H:%i:%s') AS data_type,SUM(adh.impressions) AS impressions,SUM(adh.clicks) AS clicks,SUM(adh.conversions) AS conversions,SUM(adh.views) AS views,sum(adh.requests) as requests, SUM((adh.clicks/adh.impressions)*100) as ctr,IF(SUM(adh.total_revenue) IS NULL, 0.00, FORMAT(SUM(adh.total_revenue),2)) AS total_revenue, IF(SUM(adh.impressions) > 0 AND SUM(adh.total_revenue) IS NOT NULL, FORMAT(((SUM(adh.total_revenue) * SUM(adh.impressions)) / 1000),2) , 0.00) AS ecpm, IF(SUM(adh.views) > 0 AND SUM(adh.total_revenue) IS NOT NULL, FORMAT(((SUM(adh.total_revenue) * SUM(adh.views)) / 1000),2) , 0.00) AS vecpm FROM ".$table_prefix."data_summary_ad_hourly adh LEFT JOIN ".$table_prefix."banners b ON adh.ad_id = b.bannerid LEFT JOIN ".$table_prefix."campaigns c ON c.campaignid = b.campaignid INNER JOIN ".$table_prefix."stats_country rc ON b.bannerid = rc.creative_id WHERE date_time = '".$format."' AND rc.country = '".$clientid."' and c.clientid = ".$id[1]."  GROUP BY rc.country,date_time");
            }

            else if($id[0] == 'pubid')
            {

                $getTimeReportQuery = OA_Dal_Delivery_Query("SELECT rc.country,rc.region,IFNULL(rc.country, 'unknown') AS advertiser,DATE_FORMAT(adh.date_time, '%H:%i:%s') AS data_type,SUM(adh.impressions) AS impressions,SUM(adh.clicks) AS clicks,SUM(adh.conversions) AS conversions,SUM(adh.views) AS views,IF(SUM(adh.total_revenue) IS NULL, 0.00, FORMAT(SUM(adh.total_revenue),2)) AS total_revenue,sum(adh.requests) as requests, SUM((adh.clicks/adh.impressions)*100) as ctr, IF(SUM(adh.impressions) > 0 AND SUM(adh.total_revenue) IS NOT NULL, FORMAT(((SUM(adh.total_revenue) * SUM(adh.impressions)) / 1000),2) , 0.00) AS ecpm, IF(SUM(adh.views) > 0 AND SUM(adh.total_revenue) IS NOT NULL, FORMAT(((SUM(adh.total_revenue) * SUM(adh.views)) / 1000),2) , 0.00) AS vecpm FROM ".$table_prefix."data_summary_ad_hourly adh LEFT JOIN ".$table_prefix."banners b ON adh.ad_id = b.bannerid LEFT JOIN ".$table_prefix."campaigns c ON c.campaignid = b.campaignid INNER JOIN ".$table_prefix."stats_country rc ON b.bannerid = rc.creative_id  INNER JOIN {$table_prefix}zones z on adh.zone_id = z.zoneid WHERE date_time = '".$format."' AND rc.country = '".$clientid."'  and z.affiliateid=".$id[1]."  GROUP BY rc.country,date_time");
            }



            $data[] = OA_Dal_Delivery_fetchAssoc($getTimeReportQuery);
            $data[$i]['advertiser'] = $advertiserData['advertiser'];
            $data[$i]['data_type'] = ($i <= 9 ? ' 0'.$i : ' '.$i).':00';
        }

    }

    $output_data = array();
        $passback= $row['requests'] -$row['impressions'];
                $vctr = ($row['views']/$row['impressions'])*100;
                if(is_nan($vctr)){
                    $vctr='0.00';
                }
        $CTR = ($row['clicks']/$row['impressions'])  * 100;
if(is_nan($CTR)){
    $CTR='0.00';
}
    if (isset($data) && !empty($data)) {
        foreach ($data as $key => $row) {
            $output_data[] = array( 
                "advertiser"=>$row['advertiser'],
                "data_type"=>$row['data_type'],
              "request"=>$row['requests'],
              "impressions"=>$row['impressions'],
              "passback"=>$passback,
              "views"=>($row['views']?:'0'),
              "clicks"=>($row['clicks']?:'0'),
              "conversions"=>($row['conversions']?:'0'),
              "ctr"=>($row['ctr']?:'0.00'),
              "vctr"=>$vctr,
              "ecpm"=>($row['ecpm']?:'0.00'),
              "vecpm"=>($row['vecpm']?:'0.00'),
              "total_revenue"=>($row['total_revenue']?:'0.00'),
              "pub_income"=>($row['pub_income']?:'0.00'),
              "ad_fill" => ($row['requests']) ? round(($row['impressions'] / $row['requests'] ) * 100, 2) : 0,
           );
           
        }      
    }
    

    ## Response
    $response = array(
      "draw" => intval($draw),
      "iTotalRecords" => $totalRecords,
      "iTotalDisplayRecords" => $totalRecordwithFilter,
      "aaData" => $output_data
    );

    echo json_encode($response);
    exit();
?>