<?php
	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../../../init.php';
      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}


   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];


   	$start_date = $_POST['start_date'];
   	$end_date = $_POST['end_date'];
   	$line_dimension = $_POST['line_dimension'];
   	// $x_axis = $_POST['x_axis'];

   	$data = array(); 

 //   	$labels = array();
	// $impressions = array();
	// $clicks = array();
	// $conversions = array();
	// $views = array();
	// $ecpm = array();
	// $vecpm = array();
	// $total_revenue = array();

   	## Read value
	$draw = $_POST['draw'];
	$row = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value

   	if(!$line_dimension[0]) {

		$groupby = " GROUP BY ad.exchange_id ";
		
		

	}else{
		
		$groupby = " GROUP BY ad.exchange_id , ";
		$data_type = "";
		$length  = sizeof($line_dimension);
		$i = 0;

		foreach ($line_dimension as $key) {

			if($key == 1){

				$groupby .= "ds.devicetype ";
				$data_type .= " ds.devicetype AS data_type";

			}else if($key == 2){

				$groupby .= "ds.country";
				$data_type .= " ds.country AS data_type";

			}else if($key == 3){

				$groupby .= "ds.dealid ";
				$data_type .= " ds.dealid AS data_type";

			}else if($key == 4){

				$groupby .= "ds.dealname ";
				$data_type .= " ds.dealname AS data_type";

			}else if($key == 5){

				$groupby .= "ds.seat ";
				$data_type .= " ds.seat AS data_type";

			}else if($key == 6){

				$groupby .= "af.affiliateid ";
				$data_type .= " af.website AS data_type";

			}else if($key == 7){

				$groupby .= "af.name ";
				$data_type .= " af.name AS data_type";

			}else if($key == 8){

				$groupby .= "z.zoneid  ";
				$data_type .= " z.zonename  AS data_type";

			}else if($key == 9){

				$groupby .= "date(ds.date)  ";
				$data_type .= " date(ds.date)  AS data_type";

			}else if($key == 10){

				$groupby .= "ds.os  ";
				$data_type .= " ds.os  AS data_type";

			}else if($key == 11){

				$groupby .= "ds.revenue_source  ";
				$data_type .= " ds.revenue_source  AS data_type";

			}else if($key == 12){

				$groupby .= "WEEK(ds.date)  ";
				$data_type .= " WEEK(ds.date)  AS data_type";

			}else if($key == 13){

				$groupby .= "MONTH(ds.date)  ";
				$data_type .= " MONTHNAME(ds.date)  AS data_type";

			}else if($key == 14){

				$groupby .= "YEAR(ds.date)  ";
				$data_type .= " YEAR(ds.date)  AS data_type";

			}else if($key == 15){

				$join = " INNER JOIN {$table_prefix}stats_vast_keyword sk
	                       			ON sk.zone_id = rz.zoneid ";
	            $groupby .= " sk.keyword ";
	            $data_type .= " sk.keyword AS data_type ";
	            $types = ",sk.keyword";
			}
			
			$i++;
			if($i < $length){
				$groupby .= ',';
				$data_type .= ',';
			}
		}
	}
	if ($rowperpage == -1) {
		$rowperpage = $records['allcount'];
	}

	## Fetch records
	$getDateReportQuery = OA_Dal_Delivery_Query("SELECT c.exchange_name AS exchange_name,c.exchange_name AS data_type,MAX(IF(c.vast_event_id = 1, c.count, 0)) AS start, 
			MAX(IF(c.vast_event_id = 2, c.count, 0)) AS midpoint,
			MAX(IF(c.vast_event_id = 3, c.count, 0)) AS firstquartile,
			MAX(IF(c.vast_event_id = 4, c.count, 0)) AS thirdquartile,
			MAX(IF(c.vast_event_id = 5, c.count, 0)) AS complete,
			MAX(IF(c.vast_event_id = 6, c.count, 0)) AS mute,
			MAX(IF(c.vast_event_id = 7, c.count, 0)) AS fullscreen,
			MAX(IF(c.vast_event_id = 8, c.count, 0)) AS stop,
			MAX(IF(c.vast_event_id = 9, c.count, 0)) AS unmute,
			MAX(IF(c.vast_event_id = 10, c.count, 0)) AS resume,
			MAX(IF(c.vast_event_id = 11, c.count, 0)) AS pause,
			IFNULL(c.auctions, 0) AS auctions,IFNULL(c.ad_responses, 0) AS ad_responses,IFNULL(c.won_bid, 0) AS won_bid,c.buyer,c.revenue_source,IFNULL(c.ad_response_revenue, 0) AS ad_response_revenue,IFNULL(c.impressions, 0) AS impressions,IFNULL(c.paid_impressions, 0) AS paid_impressions,IFNULL(c.ecpm, 0) AS ecpm
		 	FROM (SELECT b.dsp_id,b.exchange_name,Sum(b.count) AS count,b.vast_event_id,SUM(ds.request) AS auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS won_bid,ds.seat AS buyer,ds.revenue_source,(SUM(ds.won_bid) * SUM(ds.won_request)) AS ad_response_revenue,SUM(ds.impressions) AS impressions,SUM(ds.won_request) AS paid_impressions,(((SUM(ds.won_bid) * SUM(ds.won_request)) / ds.impressions) * 1000) AS ecpm
			FROM   (SELECT SUM(sv.count) AS count, 
	               sv.vast_event_id, 
	               sv.interval_start, 
	               rz.zonename,
	               da.dsp_id,
	               ae.exchange_name
	        FROM   ".$table_prefix."stats_vast sv 
	               INNER JOIN ".$table_prefix."zones rz 
	                       ON sv.zone_id = rz.zoneid
                   INNER JOIN ".$table_prefix."dj_aff_dsp_assoc da 
	                       ON da.aff_id = rz.affiliateid
                   INNER JOIN ".$table_prefix."dj_ad_exchange ae 
	                       ON ae.exchange_id = da.dsp_id
	        WHERE  Date(interval_start) >= '".$start_date."' 
	               AND Date(interval_start) <= '".$end_date."' 
	        GROUP  BY sv.vast_event_id,da.dsp_id 
	        UNION ALL 
	        SELECT SUM(sc.count) AS count, 
	               sc.vast_event_id, 
	               sc.interval_start, 
	               rz.zonename,
	               da.dsp_id,
	               ae.exchange_name 
	        FROM   ".$table_prefix."stats_djaxvast sc 
	               INNER JOIN rv_zones rz 
	                       ON sc.zone_id = rz.zoneid
                   	INNER JOIN ".$table_prefix."dj_aff_dsp_assoc da 
	                       ON da.aff_id = rz.affiliateid
                   INNER JOIN ".$table_prefix."dj_ad_exchange ae 
	                       ON ae.exchange_id = da.dsp_id 
	        WHERE  Date(interval_start) >= '".$start_date."'
	               AND Date(interval_start) <= '".$end_date."' 
	        GROUP  BY sc.vast_event_id,da.dsp_id) b 
	        LEFT JOIN ".$table_prefix."dj_bid_dspstatistics ds
	        	ON  ds.dsp_id = b.dsp_id
	GROUP  BY b.vast_event_id,b.dsp_id 
	ORDER  BY b.interval_start) c GROUP  BY c.dsp_id ".$_POST['limit']);

	if(OA_Dal_Delivery_numRows($getDateReportQuery) > 0){


		while ($aRow = OA_Dal_Delivery_fetchAssoc($getDateReportQuery)) {
			$labels[] = (strlen($aRow['data_type']) > 15 ? substr($aRow['data_type'],0,15)."..." : $aRow['data_type']);

			$adrequest[] = $aRow['auctions'];
			$ad_responses[] = $aRow['ad_responses'];
			$impressions[] = $aRow['impressions'];
			$start[] = $aRow['start'];
			$firstquartile[] = $aRow['firstquartile'];
			$midpoint[] = $aRow['midpoint'];
			$thirdquartile[] = $aRow['thirdquartile'];
			$complete[] = $aRow['complete'];
			$mute[] = $aRow['mute'];
			$unmute[] = $aRow['unmute'];
			$fullscreen[] = $aRow['fullscreen'];
			$stop[] = $aRow['stop'];
			$resume[] = $aRow['resume'];
			$pause[] = $aRow['pause'];
	    }


        $data = array('labels' => $labels, 'adrequest'=> $adrequest, 'ad_responses' => $ad_responses, 'impressions' => $impressions, 'start' => $start, 'firstquartile' => $firstquartile, 'midpoint' => $midpoint,  'thirdquartile' => $thirdquartile, 'complete' => $complete, 'mute' => $mute,  'unmute' => $unmute, 'fullscreen' => $fullscreen, 'stop' => $stop, 'resume' => $resume, 'pause' => $pause);
	}

   	echo json_encode($data);
	exit();
    
		