<?php
    /*
    +---------------------------------------------------------------------------+
    | Revive Adserver                                                           |
    | http://www.revive-adserver.com                                            |
    |                                                                           |
    | Copyright: See the COPYRIGHT.txt file.                                    |
    | License: GPLv2 or later, see the LICENSE.txt file.                        |
    +---------------------------------------------------------------------------+
    */
    
    // Require the initialisation file
    
    require_once '../../../../init.php';
    // Required files
    require_once MAX_PATH . '/www/admin/config.php';
    require_once LIB_PATH . '/Plugin/PluginManager.php';
    require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
    require_once MAX_PATH . '/lib/pear/Date.php';
    require_once MAX_PATH . '/lib/OA/Dal.php';
    
    $oPluginManager = new OX_PluginManager();
    $oComponentGroupManager = new OX_Plugin_ComponentGroupManager();
    phpAds_PageHeader('bidhealthreport', $oHeaderModel);
    
    /*-------------------------------------------------------*/
    /* Store preferences                                     */
    /*-------------------------------------------------------*/
    $session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
    $session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
    phpAds_SessionDataStore();
    
    // Initialise some parameters
    $pageName = basename($_SERVER['SCRIPT_NAME']);
    $tabindex = 1;
    $issl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' : 'http://';
    $impath = $GLOBALS['_MAX']['CONF']['webpath']['admin'];
    $fc_path = $issl.$impath;

    ##
    $id = '';

    if($_GET['clientid'] != ''){
      $id = 'clientid='.$_GET['clientid'];
    }else if($_GET['affiliateid'] != ''){
      $id = 'pubid='.$_GET['affiliateid'];
    }else if($GLOBALS['GLOBALS']['session']['user']->aAccount['account_type'] == 'MANAGER'){
      $id = 'manager='.$GLOBALS['GLOBALS']['session']['user']->aAccount['agency_id'];
    }

?>

<style type="text/css">
    
    div.breadcrumb
    {
      z-index: 0 !important;
    }

</style>

<script src="assets/js/jquery-3.4.1.min.js"></script>
<script src="assets/js/jquery_datatable.js"></script>

<link rel="stylesheet" type="text/css" href="assets/data_table/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="assets/data_table/buttons.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="assets/data_table/custom.css">
<link rel="stylesheet" type="text/css" href="assets/css/multi-select.css">
<link rel="stylesheet" type="text/css" href="assets/css/jquery_datatable.css">
<link rel="stylesheet" type="text/css" href="assets/chart/Chart.min.css">

<script src="assets/chart/Chart.min.js"></script>
<script src="assets/js/jquery.multi-select.js"></script>
<script src="assets/data_table/pdfmake.min.js"></script>
<script src="assets/data_table/vfs_fonts.js"></script>
<script src="assets/data_table/jszip.min.js"></script>
<script src="assets/data_table/buttons.print.min.js"></script>
<script src="assets/data_table/dataTables.buttons.min.js"></script>
<script src="assets/data_table/buttons.flash.min.js"></script>
<script src="assets/data_table/buttons.html5.min.js"></script>
<script src="assets/js/jspdf.min.js"></script>
<script src="assets/js/html2canvas.min.js"></script>


<form method='post' class="form-horizontal" style="margin-top: -25px;" >

    <table class="table table-borderless">
    <thead>
        <tr>
            <td>
                <input type="hidden" id="ids" value="<?=$id;?>">
                <select name='chart_type' id='chart_type' class="form-control" tabindex='1'>
                    <option value='bar' selected='selected'>Bar chart</option>
                    <option value='pie'>Pie chart</option>
                    <option value='line'>Line chart</option>
                </select>
            </td>

            <td>
                <select name='line_dimension[]' style="background: #bdb7b738; width: 150px!important; font-size: 11px!important;" multiple class='form-control line_dimension clmwidth' tabindex='1'>
                    <!--<option value="" selected>None</option>-->
                    <!-- <option value="4">Group By Ad type</option> -->
                    <!-- <option value="9">Group By Adformat</option> -->
                    <!-- <option value="11">Group By Device type</option> -->
                    <option value="1">Group By Device</option>
                    <option value="2">Group By Country</option>
                    <option value="3">Group By Deal ID</option>
                    <option value="4">Group By Deal Name</option>
                    <option value="5">Group By Buyers</option>
                    <option value="6">Group By Sites</option>
                    <option value="7">Group By Site Name</option>
                    <option value="8">Group By Zones</option>
                    <option value="9">Group By Date</option>
                    <option value="10">Group By Device OS</option>
                    <option value="11">Group By Revenue source</option>
                    <option value="12">Group By Week</option>
                    <option value="13">Group By Month</option>
                    <option value="14">Group By Year</option>
                    <option value="15">Group By Keyword</option>
                    <option value="16">Group By Category</option>
                </select>
            </td>

            <td>
                <select name='period_preset' class="form-control" id='period_preset' tabindex='1'>
                    <option value='1' selected='selected'>Today</option>
                    <option value='2'>Yesterday</option>
                    <option value='3'>This week</option>
                    <option value='4'>Last week</option>
                    <option value='5'>Last 7 days</option>
                    <option value='6'>This month</option>
                    <option value='7'>Last month</option>
                    <option value='8'>All statistics</option>
                </select>
            </td>

            <td>

                <input name="period_start" style="height: calc(1.5em + .75rem + 2px); padding: .375rem .75rem; border-radius: .25rem; border-width: 1px; padding-left: 10px; width: 9rem;" id="period_start" type="text" readonly="true" />
                <input type='image' src='assets/images/icon-calendar-d.gif' id='period_start_button'/>
            </td>

            <td>
                <input name="period_end" style="height: calc(1.5em + .75rem + 2px); padding: .375rem .75rem; border-radius: .25rem; border-width: 1px; padding-left: 10px; width: 9rem;" id="period_end" type="text" readonly="true"/> 
                <input type='image' src='assets/images/icon-calendar-d.gif' id='period_end_button'/>

            </td>

            <td>
                <select name='page_type' class="form-control" id='page_type' tabindex='1'>
                    <option value='web'  selected='selected'>Web</option>
                    <option value='video'>Video</option>
                </select>
            </td>

            <td>
                <div id="download_btn" class="dropdown"> 
                    <div class="bar"></div>
                    <div class="bar"></div>
                    <div class="bar"></div>

                    <div class="dropdown-content" style="left:0;">
                        <a id="download_btnjpeg" style="margin-left: 1%;" href="#"><img src="assets/images/download.png"> JPEG</a> 
                        <a id="download_btnpng" style="margin-left: 1%;" href="#"><img src="assets/images/download.png"> PNG</a> 
                        <a id="download_btnpdf" style="margin-left: 1%;" href="#"><img src="assets/images/download.png"> PDF</a> 
                    </div>
                </div>

            </td>
        </tr>
    </thead>
    </table>

</form>

<center>
    <table>
        <tr>
            <td>
                <div class="chart-container">
                    <!-- <center><h5 style="color: #283250; text-decoration: underline;">Graph</h5></center> -->
                    <canvas id="myChart" width="750" height="450"></canvas>
                </div>
            </td>
        </tr>
    </table>
</center>

</br>

<div class="border-key">

    <div class="title" style="display: block;">
      <h1 class="h4 text-center keywordaback">Bid Health Performance Report</h1>
    </div>

    <table id="table_report" class="display" width="100%" cellspacing="0">
        <thead>
            <tr>
                <th class="aleft" style="font-size:13px;" >DSP</th>
                <th class="aleft" style="font-size:13px;" id="data_type1">Device</th>
                <th class="aleft" style="font-size:13px;" id="data_type2">Country</th>
                <th class="aleft" style="font-size:13px;" id="data_type3">Deal ID</th>
                <th class="aleft" style="font-size:13px;" id="data_type4">Deal Name</th>
                <th class="aleft" style="font-size:13px;" id="data_type5">Buyers</th>
                <th class="aleft" style="font-size:13px;" id="data_type6">Sites</th>
                <th class="aleft" style="font-size:13px;" id="data_type7">Site Name</th>
                <th class="aleft" style="font-size:13px;" id="data_type8">Zones</th>
                <th class="aleft" style="font-size:13px;" id="data_type9">Date</th>
                <th class="aleft" style="font-size:13px;" id="data_type10">Device OS</th>
                <th class="aleft" style="font-size:13px;" id="data_type11">Revenue Source</th>
                <th class="aleft" style="font-size:13px;" id="data_type12">Week</th>
                <th class="aleft" style="font-size:13px;" id="data_type13">Month</th>
                <th class="aleft" style="font-size:13px;" id="data_type14">Year</th>
                <th class="aleft" style="font-size:13px;" id="data_type15">Keyword</th>
                <th class="aleft" style="font-size:13px;" id="data_type16">Category</th>

                <th class="aleft" style="font-size:13px;">Ad Request</th>
                <th class="aleft" style="font-size:13px;">Ad Responses</th>
                <th class="aleft" style="font-size:13px;">Ad Response CPM Revenue</th>
                <th class="aleft" style="font-size:13px;">Impressions</th>
                <th class="aleft" style="font-size:13px;">Gross Revenue</th>
                <!-- <th class="aleft" style="font-size:13px;">Publisher Revenue</th> -->
                <th class="aleft" style="font-size:13px;">eCPM</th>
                <th class="aleft" style="font-size:13px;">Ad Request CPM</th>
                <th class="aleft" style="font-size:13px;">Avg Bid CPM</th>
            </tr>
        </thead>
        <tbody id="append_data"></tbody>
    </table>

</div>

<?php
    phpAds_PageFooter();   
?>
<script src="assets/js/browser.js"></script>
<script src="assets/js/bid-health-report.js"></script>
<script type="text/javascript">
    jQuery(document).on('change', '#page_type', function() { 
        var url = "<?php echo $fc_path; ?>/plugins/AnalyticalReports/bid_health_video_report.php";
        window.location = url;
    });
</script>
