<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

      
	## Required files
	require_once '../../../../init.php';
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';


	## DB
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

     
	## INITIALISATIN
   	$condition = '';
   	$getQuery = '';
   	$limit = "";
   	$id = "";
   	$join = "";

	// $labels[] = "";
	// $ad_requests[] = "";
	// $ad_responses[] = "";
	// $impressions[] = "";
	// $ad_response_revenue[] = "";
	// $gross_revenue[] = "";
	// $pub_revenue[] = "";
	// $ecpm[] = "";
	// $ad_request_cpm[] = "";
	// $avg_bid_cpm[] = "";

   	## REQUIRED POST VALIES
   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   	$start_date = $_POST['start_date'];
   	$end_date = $_POST['end_date'];
   	$line_dimension = $_POST['line_dimension'];
   	$total_record = $_POST['count'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value


    ## ACCOUNT TYPE
    if(isset($_POST['id']) && !empty($_POST['id'])) {
      	$id = explode('=', $_POST['id']);
    }

    if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
    }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND af.affiliateid='.$id[1];
    }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND af.agencyid='.$id[1];
    }

	## RECORD COUNT

	$data_type = "ad.exchange_name AS data_type";
    
    if(!$line_dimension[0]) {

		$groupby = " GROUP BY ad.exchange_id ";
		
	}else{
		
		$groupby = " GROUP BY ad.exchange_id , ";
		$data_type = "";
		$length  = sizeof($line_dimension);
		$i = 0;

		foreach ($line_dimension as $key) {

			if($key == 1){

				$groupby .= "ds.devicetype ";
				$data_type .= " ds.devicetype AS data_type";

			}else if($key == 2){

				$groupby .= "ds.country ";
				$data_type .= " ds.country AS data_type";

			}else if($key == 3){

				$groupby .= "ds.dealid ";
				$data_type .= " ds.dealid AS data_type";

			}else if($key == 4){

				$groupby .= "ds.dealname ";
				$data_type .= " ds.dealname AS data_type";

			}else if($key == 5){

				$groupby .= "ds.seat ";
				$data_type .= " ds.seat AS data_type";

			}else if($key == 6){

				$groupby .= "af.affiliateid ";
				$data_type .= " af.website AS data_type";

			}else if($key == 7){

				$groupby .= "af.name ";
				$data_type .= " af.name AS data_type";

			}else if($key == 8){

				$groupby .= "z.zoneid  ";
				$data_type .= " z.zonename  AS data_type";

			}else if($key == 9){

				$groupby .= "date(ds.date)  ";
				$data_type .= " date(ds.date)  AS data_type";

			}else if($key == 10){

				$groupby .= "ds.os  ";
				$data_type .= " ds.os  AS data_type";

			}else if($key == 11){

				$groupby .= "ds.revenue_source  ";
				$data_type .= " ds.revenue_source  AS data_type";

			}else if($key == 12){

				$groupby .= "WEEK(ds.date)  ";
				$data_type .= " WEEK(ds.date)  AS data_type";

			}else if($key == 13){

				$groupby .= "MONTH(ds.date)  ";
				$data_type .= " MONTHNAME(ds.date)  AS data_type";

			}else if($key == 14){

				$groupby .= "YEAR(ds.date)  ";
				$data_type .= " YEAR(ds.date)  AS data_type";

			}else if($key == 15){

				$groupby .= "ds.keyword  ";
				$data_type .= " ds.keyword  AS data_type";
				//$join = " INNER JOIN {$table_prefix}stats_vast_keyword sk ON sk.zone_id = ds.zoneid " ;

			}
			
			$i++;
			if($i < $length){
				$groupby .= ',';
				$data_type .= ',';
			}
		}
	}
    if($key==15)
    {
		$getQuery = "SELECT 
	{$data_type},ad.exchange_id,ad.exchange_name AS name,SUM(ds.request) AS 
	auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS 
	won_bid,SUM(ds.won_bid) AS 
	ad_response_revenue,SUM(ds.won_request) AS 
	impressions,SUM(ds.won_request) AS paid_impressions,0 AS 
	publisher_gross_revenue,0 AS 
	ad_request_cpm,0 AS avg_bid_cpm,0 AS gross_revenue,ds.affiliateid as affiliateid,ds.zoneid 
	 FROM ".$table_prefix."dj_bid_dspstatistics_keyword ds INNER JOIN ".$table_prefix."dj_ad_exchange ad ON ds.dsp_id = ad.exchange_id {$join} INNER JOIN {$table_prefix}affiliates af ON af.affiliateid = ds.affiliateid INNER JOIN {$table_prefix}zones z ON z.zoneid = ds.zoneid		
	 WHERE z.delivery NOT IN(6,7,8) AND DATE(ds.date) >= '".$start_date."' AND DATE(ds.date) <= '". $end_date."' ".$condition." ".$groupby.$_POST['limit'];
	}
	else
	{
	$getQuery = "SELECT 
	{$data_type},ad.exchange_id,ad.exchange_name AS name,SUM(ds.request) AS 
	auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS 
	won_bid,ds.seat AS buyer,ds.revenue_source,SUM(ds.won_bid) AS 
	ad_response_revenue,SUM(ds.impressions) AS 
	impressions,SUM(ds.won_request) AS paid_impressions,0 AS 
	publisher_gross_revenue,(((SUM(ds.won_bid) * 
	SUM(ds.won_request)) / ds.impressions) * 1000) AS ecpm,0 AS 
	ad_request_cpm,0 AS avg_bid_cpm,0 AS gross_revenue,ds.affiliateid as affiliateid,ds.zoneid FROM ".$table_prefix."dj_bid_dspstatistics ds INNER JOIN ".$table_prefix."dj_ad_exchange ad ON ds.dsp_id = ad.exchange_id ".$join." INNER JOIN {$table_prefix}affiliates af ON af.affiliateid = ds.affiliateid INNER JOIN {$table_prefix}zones z ON z.zoneid = ds.zoneid		
	 WHERE DATE(ds.date) >= '".$start_date."' AND DATE(ds.date) <= '". $end_date."'  ".$condition." ".$groupby. $_POST['limit'];
 }
	
    $data = array();
    $getQuery = OA_Dal_Delivery_Query($getQuery);

	if (OA_Dal_Delivery_numRows($getQuery) > 0) {

	    while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) 
	    {
			$publishercpm = OA_Dal_Delivery_Query("SELECT cpm  FROM 
			".$table_prefix."affiliates where affiliateid=".$aRow['affiliateid']." ");
			$pubrow = OA_Dal_Delivery_fetchAssoc($publishercpm);
			//print_r($aRow);exit;
			//$cpm = ($aRow['impressions'] > 0) ? ($aRow['clicks']/$aRow['impressions'])*100 : 0;

			$ad_res_revenue = ($aRow['won_bid'] > 0)? $aRow['won_bid']/1000:0;
			$gross_revenue = ($aRow['won_bid'] > 0)? $aRow['won_bid']:0;
			$publisher_revenue=($aRow['ad_responses'] > 0)? $aRow['ad_responses']*$pubrow['cpm']:0;
			//$gross_revenue = ($cpm/1000)*$aRow['paid_impressions'];
			$cal_ecpm = ($aRow['ad_response_revenue'] > 0)?( ($ad_res_revenue/$aRow['ad_responses'])* 1000 )  : 0;
			//Total Earnings/Impressions x 1000 
			//$ad_req_cpm = ($aRow['requests'] > 0) ? ($aRow['gross_revenue']/$aRow['requests'])*1000 : 0;
			$ad_req_cpm = ($aRow['auctions'] > 0) ? ($ad_res_revenue/$aRow['auctions'])*1000 : 0;
			
			$bid_cpm = ($aRow['impressions'] > 0) ? ($ad_res_revenue / $aRow['impressions'])/1000: 0;
			if($key!=15)
			{
			if($aRow['revenue_source']=='PMP')
			{
				$source=$aRow['revenue_source'];
				
			}
			else if($aRow['revenue_source']=='open')
			{
				$source=$aRow['revenue_source'];
				
			}
			else
			{
				$source="-";
			}
          }
        
			$labels[] = (strlen($aRow['data_type']) > 15 ? substr($aRow['data_type'],0,15)."..." : $aRow['data_type']);
			$ad_requests[] = $aRow['auctions'];
			$ad_responses[] = $aRow['ad_responses'];
			$impressions[] = $aRow['impressions'];
			$ad_response_rev[] = round($ad_res_revenue, 2);
			$gross_rev[] = round($gross_revenue, 2);
			$ecpm[] = round($cal_ecpm,2);
			$pub_revenue[] = round($publisher_revenue, 2);
			$ad_request_cpm[] = round($ad_req_cpm, 2);
			$avg_bid_cpm[] = round($bid_cpm, 2);
	    }
		
		// $data = array('labels' => $labels, 'ad_requests' => $ad_requests, 'ad_responses' => $ad_responses, 'impressions' => $impressions, 'ad_response_rev' => $ad_response_rev, 'gross_rev' => $gross_rev, 'ecpm' => $ecpm, 'pub_revenue' => $pub_revenue, 'ad_request_cpm' => $ad_request_cpm, 'avg_bid_cpm' => $avg_bid_cpm );

		$data = array('labels' => $labels, 'ad_requests' => $ad_requests, 'ad_responses' => $ad_responses, 'impressions' => $impressions, 'ad_response_rev' => $ad_response_rev, 'gross_rev' => $gross_rev, 'ecpm' => $ecpm, 'ad_request_cpm' => $ad_request_cpm, 'avg_bid_cpm' => $avg_bid_cpm );
	}


    echo json_encode($data);
    exit();
