<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../../../init.php';
      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}


   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];


   ## ACCOUNT TYPE
   if(isset($_POST['id']) && !empty($_POST['id'])) {
      $id = explode('=', $_POST['id']);
   }

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND rf.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }

 
   	$start_date = $_POST['start_date'];
   	$end_date = $_POST['end_date'];
   	$line_dimension = $_POST['line_dimension'];

   	$totalRecords = 0;
   	$totalRecordwithFilter = 0;
   	$join = "";
   	$types = '';
      

   	## Read value
	$draw = $_POST['draw'];
	$row = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value
	$data_type = "c.exchange_name AS data_type";

   if(!$line_dimension[0]) {

		$groupby = " GROUP BY ds.exchange_id ";

	}else{
		
		$groupby = " GROUP BY ad.exchange_id , ";
		//$data_type = "";
		$length  = sizeof($line_dimension);
		$i = 0;

		foreach ($line_dimension as $key) {

			if($key == 1){
                
				$groupby .= "c.devicetype ";
				$data_type .= " c.devicetype AS data_type1";

			}else if($key == 2){

				$groupby .= "c.country";
				$data_type .= " c.country AS data_type2";

			}else if($key == 3){

				$groupby .= "c.dealid ";
				$data_type .= " c.dealid AS data_type3";

			}else if($key == 4){

				$groupby .= "c.dealname ";
				$data_type .= " c.dealname AS data_type4";

			}else if($key == 5){

				$groupby .= "c.seat ";
				$data_type .= " c.seat AS data_type5";

			}else if($key == 6){

				$groupby .= "af.affiliateid ";
				$data_type .= " af.website AS data_type6";

			}else if($key == 7){

				$groupby .= "af.name ";
				$data_type .= " af.name AS data_type7";

			}else if($key == 8){

				$groupby .= "z.zoneid  ";
				$data_type .= " z.zonename  AS data_type8";

			}else if($key == 9){

				$groupby .= "date(ds.date)  ";
				$data_type .= " date(ds.date)  AS data_type9";

			}else if($key == 10){

				$groupby .= "c.os  ";
				$data_type .= " c.os  AS data_type10";

			}else if($key == 11){

				$groupby .= "c.revenue_source  ";
				$data_type .= " c.revenue_source  AS data_type11";

			}else if($key == 12){

				$groupby .= "WEEK(c.date)  ";
				$data_type .= " WEEK(c.date)  AS data_type12";

			}else if($key == 13){

				$groupby .= "MONTH(c.date)  ";
				$data_type .= " MONTHNAME(c.date)  AS data_type13";

			}else if($key == 14){

				$groupby .= "YEAR(c.date)  ";
				$data_type .= " YEAR(c.date)  AS data_type14";
			}else if($key == 15){

				$join = " INNER JOIN {$table_prefix}stats_vast_keyword sk
	                       			ON sk.zone_id = rz.zoneid ";
	            $groupby .= " sk.keyword ";
	            $data_type .= " sk.keyword AS data_type15 ";
	            $types = ",sk.keyword";
			}
			
			$i++;
			if($i < $length){
				$groupby .= ',';
				$data_type .= ',';
			}
		}
	}
	if ($start_date && $end_date) {
		$sel =  OA_Dal_Delivery_Query("SELECT c.dsp_id as allcount
				 	FROM (SELECT b.dsp_id,b.exchange_name,Sum(b.count) AS count,b.vast_event_id,SUM(ds.request) AS auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS won_bid,ds.seat AS buyer,ds.devicetype as devicetype,ds.revenue_source as revenue_source ,(SUM(ds.won_bid) * SUM(ds.won_request)) AS ad_response_revenue,SUM(ds.impressions) AS impressions,SUM(ds.won_request) AS paid_impressions,(((SUM(ds.won_bid) * SUM(ds.won_request)) / ds.impressions) * 1000) AS ecpm
					FROM   (SELECT SUM(sv.count) AS count, 
			               sv.vast_event_id, 
			               sv.interval_start, 
			               rz.zonename,
			               da.dsp_id,
			               ae.exchange_name
			               ".$types."
			        FROM   ".$table_prefix."stats_vast sv 
			               INNER JOIN ".$table_prefix."zones rz 
			                       ON sv.zone_id = rz.zoneid
	                       INNER JOIN ".$table_prefix."dj_aff_dsp_assoc da 
			                       ON da.aff_id = rz.affiliateid
	                       INNER JOIN ".$table_prefix."dj_ad_exchange ae 
			                       ON ae.exchange_id = da.dsp_id
			               INNER JOIN {$table_prefix}banners rb 
			                       ON sv.creative_id = rb.bannerid 
						       ".$join."
			        WHERE  Date(sv.interval_start) >= '".$start_date."' 
			               AND Date(sv.interval_start) <= '".$end_date."' 
			               AND rb.exchange_id > 0
			        GROUP  BY sv.vast_event_id,da.dsp_id ) b 
			        LEFT JOIN ".$table_prefix."dj_bid_dspstatistics ds
			        	ON  ds.dsp_id = b.dsp_id
			GROUP  BY b.vast_event_id,b.dsp_id 
			ORDER  BY b.interval_start) c GROUP  BY c.dsp_id ");


		$records = OA_Dal_Delivery_numRows($sel);

			if ($rowperpage == -1) {
				$rowperpage = $records['allcount'];
			}

		$getDateReportQuery = OA_Dal_Delivery_Query("SELECT {$data_type},MAX(IF(c.vast_event_id = 1, c.count, 0)) AS start, 
					MAX(IF(c.vast_event_id = 2, c.count, 0)) AS midpoint,
					MAX(IF(c.vast_event_id = 3, c.count, 0)) AS firstquartile,
					MAX(IF(c.vast_event_id = 4, c.count, 0)) AS thirdquartile,
					MAX(IF(c.vast_event_id = 5, c.count, 0)) AS complete,
					MAX(IF(c.vast_event_id = 6, c.count, 0)) AS mute,
					MAX(IF(c.vast_event_id = 7, c.count, 0)) AS fullscreen,
					MAX(IF(c.vast_event_id = 8, c.count, 0)) AS stop,
					MAX(IF(c.vast_event_id = 9, c.count, 0)) AS unmute,
					MAX(IF(c.vast_event_id = 10, c.count, 0)) AS resume,
					MAX(IF(c.vast_event_id = 11, c.count, 0)) AS pause,
					IFNULL(c.auctions, 0) AS auctions,IFNULL(c.ad_responses, 0) AS ad_responses,IFNULL(c.won_bid, 0) AS won_bid,c.buyer,c.revenue_source,IFNULL(c.ad_response_revenue, 0) AS ad_response_revenue,IFNULL(c.impressions, 0) AS impressions,IFNULL(c.paid_impressions, 0) AS paid_impressions,IFNULL(c.ecpm, 0) AS ecpm
				 	FROM (SELECT b.dsp_id,b.exchange_name,Sum(b.count) AS count,b.vast_event_id,SUM(ds.request) AS auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS won_bid,ds.seat AS buyer,ds.devicetype as devicetype,ds.revenue_source as revenue_source ,(SUM(ds.won_bid) * SUM(ds.won_request)) AS ad_response_revenue,SUM(ds.impressions) AS impressions,SUM(ds.won_request) AS paid_impressions,(((SUM(ds.won_bid) * SUM(ds.won_request)) / ds.impressions) * 1000) AS ecpm
					FROM   (SELECT SUM(sv.count) AS count, 
			               sv.vast_event_id, 
			               sv.interval_start, 
			               rz.zonename,
			               da.dsp_id,
			               ae.exchange_name
			               ".$types."
			        FROM   ".$table_prefix."stats_vast sv 
			               INNER JOIN ".$table_prefix."zones rz 
			                       ON sv.zone_id = rz.zoneid
	                       INNER JOIN ".$table_prefix."dj_aff_dsp_assoc da 
			                       ON da.aff_id = rz.affiliateid
	                       INNER JOIN ".$table_prefix."dj_ad_exchange ae 
			                       ON ae.exchange_id = da.dsp_id
			               INNER JOIN {$table_prefix}banners rb 
			                       ON sv.creative_id = rb.bannerid 
						       ".$join."
			        WHERE  Date(sv.interval_start) >= '".$start_date."' 
			               AND Date(sv.interval_start) <= '".$end_date."' 
			               AND rb.exchange_id > 0
			        GROUP  BY sv.vast_event_id,da.dsp_id ) b 
			        LEFT JOIN ".$table_prefix."dj_bid_dspstatistics ds
			        	ON  ds.dsp_id = b.dsp_id
			GROUP  BY b.vast_event_id,b.dsp_id 
			ORDER  BY b.interval_start) c GROUP  BY c.dsp_id LIMIT ".$row.",".$rowperpage);
			

        
	} 

	$data = array();

	if (isset($getDateReportQuery) && !empty($getDateReportQuery)) {
		while ($row = OA_Dal_Delivery_fetchAssoc($getDateReportQuery)) {
		   $publishercpm = OA_Dal_Delivery_Query("SELECT cpm  FROM 
			".$table_prefix."affiliates where affiliateid=".$row['affiliateid']." ");
			$pubrow = OA_Dal_Delivery_fetchAssoc($publishercpm);
			$ad_res_revenue = ($row['won_bid'] > 0)? $row['won_bid']/1000:0;
			$gross_revenue = ($row['won_bid'] > 0)? $row['won_bid']:0;
			$publisher_revenue=($row['ad_responses'] > 0)? 
			$row['ad_responses']*$pubrow['cpm']:0;
			//$gross_revenue = ($cpm/1000)*$row['paid_impressions'];
			$ecpm = ($row['ad_response_revenue'] > 0)?( ($ad_res_revenue/$row['ad_responses'])* 1000 )  : 0;
			//Total Earnings/Impressions x 1000 
			//$ad_req_cpm = ($row['requests'] > 0) ? ($row['gross_revenue']/$row['requests'])*1000 : 0;
			$ad_req_cpm = ($row['auctions'] > 0) ? ($ad_res_revenue/$row['auctions'])*1000 : 0;
			
			$bid_cpm = ($row['impressions'] > 0) ? ($gross_revenue / $row['impressions'])/1000: 0;
			
		   	$data[] = array(
				"name" => $row['data_type'],
				"data_type1" => $row['data_type1'],
				"data_type2" => $row['data_type2'],
				"data_type3" => $row['data_type3'],
				"data_type4" => $row['data_type4'],
				"data_type5" => $row['data_type5'],
				"data_type6" => $row['data_type6'],
				"data_type7" => $row['data_type7'],
				"data_type8" => $row['data_type8'],
				"data_type9" => $row['data_type9'],
				"data_type10" => $row['data_type10'],
				"data_type11" => $row['data_type11'],
				"data_type12" => $row['data_type12'],
				"data_type13" => $row['data_type13'],
				"data_type14" => $row['data_type14'],
				"data_type15" => $row['data_type15'],
				"data_type16" => $row['data_type16'],

				"auctions" => $row['auctions'],
				"ad_responses" => $row['ad_responses'],
				"ad_response_revenue" => round($ad_res_revenue, 2),
				"impressions" =>  ($row['impressions'] == 0 || $row['impressions'] == '' ? '0' : $row['impressions']),
				"gross_revenue" => round($gross_revenue, 2),
				"pub_revenue" =>round($publisher_revenue, 2),
				"ecpm" => round($ecpm),
				"ad_request_cpm" => round($ad_req_cpm),
				"avg_bid_cpm" => round($bid_cpm,2),

		      	"start"=>$row['start'],
		      	"firstquartile"=>$row['firstquartile'],
		      	"midpoint"=>$row['midpoint'],
		      	"thirdquartile"=>$row['thirdquartile'],
		      	"complete"=>$row['complete'],
		      	"mute"=>$row['mute'],
		      	"fullscreen"=>$row['fullscreen'],
		      	"stop"=>$row['stop'],
		      	"unmute"=>$row['unmute'],
		      	"resume"=>$row['resume'],
		      	"pause"=>$row['pause'],

		   );
		}
	}
	

	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => $records,
	  "iTotalDisplayRecords" => $records,
	  "aaData" => $data
	);

	echo json_encode($response);
	exit();
?>
    
		
