<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../../../init.php';
      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}


   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];


   	$start_date = $_POST['start_date'];
   	$end_date = $_POST['end_date'];
    $line_dimension = $_POST['line_dimension']; 
    $join = "";
    
   	$totalRecords = 0;
   	$totalRecordwithFilter = 0;

   	## Read value
	$draw = $_POST['draw'];
	$row = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value
	 if(isset($_POST['id']) && !empty($_POST['id'])) {
		
      $id = explode('=', $_POST['id']);
    }

    if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
    }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND af.affiliateid='.$id[1];
    }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND af.agencyid='.$id[1];
    }

	## RECORD COUNT
	if ($rowperpage == -1) {
		$limit = "";	## ALL RECORDS
	}else{
		$limit = "limit ".$_POST['start'].",".$_POST['length'];	## LIMITTED RECORDS
	}
	$data_type = "ad.exchange_name AS data_type";
     if(!$line_dimension[0]) {

		$groupby = " GROUP BY ad.exchange_id ";
		
		

	}else{
		
		$groupby = " GROUP BY ad.exchange_id , ";
		$data_type = "";
		$length  = sizeof($line_dimension);
		$i = 0;

		foreach ($line_dimension as $key) {

			if($key == 1){

				$groupby .= "ds.devicetype ";
				$data_type .= " ds.devicetype AS data_type1";

			}else if($key == 2){

				$groupby .= "ds.country";
				$data_type .= " ds.country AS data_type2";

			}else if($key == 3){

				$groupby .= "ds.dealid ";
				$data_type .= " ds.dealid AS data_type3";

			}else if($key == 4){

				$groupby .= "ds.dealname ";
				$data_type .= " ds.dealname AS data_type4";

			}else if($key == 5){

				$groupby .= "ds.seat ";
				$data_type .= " ds.seat AS data_type5";

			}else if($key == 6){

				$groupby .= "af.affiliateid ";
				$data_type .= " af.website AS data_type6";

			}else if($key == 7){

				$groupby .= "af.name ";
				$data_type .= " af.name AS data_type7";

			}else if($key == 8){

				$groupby .= "z.zoneid  ";
				$data_type .= " z.zonename  AS data_type8";

			}else if($key == 9){

				$groupby .= "date(ds.date)  ";
				$data_type .= " date(ds.date)  AS data_type9";

			}else if($key == 10){

				$groupby .= "ds.os  ";
				$data_type .= " ds.os  AS data_type10";

			}else if($key == 11){

				$groupby .= "ds.revenue_source  ";
				$data_type .= " ds.revenue_source  AS data_type11";

			}else if($key == 12){

				$groupby .= "WEEK(ds.date)  ";
				$data_type .= " WEEK(ds.date)  AS data_type12";

			}else if($key == 13){

				$groupby .= "MONTH(ds.date)  ";
				$data_type .= " MONTHNAME(ds.date)  AS data_type13";

			}else if($key == 14){

				$groupby .= "YEAR(ds.date)  ";
				$data_type .= " YEAR(ds.date)  AS data_type14";

			}else if($key == 15){

				$groupby .= "ds.keyword  ";
				$data_type .= " ds.keyword  AS data_type15";
				//$join = " INNER JOIN {$table_prefix}stats_vast_keyword sk ON sk.zone_id = ds.zoneid " ;
			}
			
			$i++;
			if($i < $length){
				$groupby .= ',';
				$data_type .= ',';
			}
		}
	}
     if($key==15)
     {
	$sel =  OA_Dal_Delivery_Query("SELECT COUNT(ds.keyword) AS allcount FROM ".$table_prefix."dj_bid_dspstatistics_keyword ds INNER JOIN ".$table_prefix."dj_ad_exchange ad ON ds.dsp_id = ad.exchange_id {$join} INNER JOIN {$table_prefix}affiliates af ON af.affiliateid = ds.affiliateid INNER JOIN {$table_prefix}zones z ON z.zoneid = ds.zoneid		
	 WHERE z.delivery NOT IN(6,7,8) AND DATE(ds.date) >= '".$start_date."' AND DATE(ds.date) <= '". $end_date."' ".$condition." ".$groupby);

	$records = OA_Dal_Delivery_numRows($sel);
     }
     else
     {
		 $sel =  OA_Dal_Delivery_Query("SELECT COUNT(af.affiliateid) AS allcount FROM ".$table_prefix."dj_bid_dspstatistics ds INNER JOIN ".$table_prefix."dj_ad_exchange ad ON ds.dsp_id = ad.exchange_id {$join} INNER JOIN {$table_prefix}affiliates af ON af.affiliateid = ds.affiliateid INNER JOIN {$table_prefix}zones z ON z.zoneid = ds.zoneid		
	 WHERE z.delivery NOT IN(6,7,8) AND DATE(ds.date) >= '".$start_date."' AND DATE(ds.date) <= '". $end_date."' ".$condition." ".$groupby);

	$records = OA_Dal_Delivery_numRows($sel);
	 }
     
	if ($rowperpage == -1) {
		$rowperpage = $records['allcount'];
	}

   if($key==15)
   {
	   $getDateReportQuery = OA_Dal_Delivery_Query("SELECT 
	{$data_type},ad.exchange_id,ad.exchange_name AS name,SUM(ds.request) AS 
	auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS 
	won_bid,SUM(ds.won_bid) AS 
	ad_response_revenue,SUM(ds.won_request) AS 
	impressions,SUM(ds.won_request) AS paid_impressions,0 AS 
	publisher_gross_revenue,0 AS 
	ad_request_cpm,0 AS avg_bid_cpm,0 AS gross_revenue,ds.affiliateid as affiliateid,ds.zoneid 
	 FROM ".$table_prefix."dj_bid_dspstatistics_keyword ds INNER JOIN ".$table_prefix."dj_ad_exchange ad ON ds.dsp_id = ad.exchange_id {$join} INNER JOIN {$table_prefix}affiliates af ON af.affiliateid = ds.affiliateid INNER JOIN {$table_prefix}zones z ON z.zoneid = ds.zoneid		
	 WHERE z.delivery NOT IN(6,7,8) AND DATE(ds.date) >= '".$start_date."' AND DATE(ds.date) <= '". $end_date."' ".$condition." ".$groupby." LIMIT ".$row.",".$rowperpage);
   }
   else
   {
	$getDateReportQuery = OA_Dal_Delivery_Query("SELECT 
	{$data_type},ad.exchange_id,ad.exchange_name AS name,SUM(ds.request) AS 
	auctions,SUM(ds.response) AS ad_responses,SUM(ds.won_bid) AS 
	won_bid,ds.seat AS buyer,ds.revenue_source,SUM(ds.won_bid) AS 
	ad_response_revenue,SUM(ds.won_request) AS 
	impressions,SUM(ds.won_request) AS paid_impressions,0 AS 
	publisher_gross_revenue,(((SUM(ds.won_bid) * 
	SUM(ds.won_request)) / ds.impressions) * 1000) AS ecpm,0 AS 
	ad_request_cpm,0 AS avg_bid_cpm,0 AS gross_revenue,ds.affiliateid as affiliateid,ds.zoneid 
	 FROM ".$table_prefix."dj_bid_dspstatistics ds INNER JOIN ".$table_prefix."dj_ad_exchange ad ON ds.dsp_id = ad.exchange_id {$join} INNER JOIN {$table_prefix}affiliates af ON af.affiliateid = ds.affiliateid INNER JOIN {$table_prefix}zones z ON z.zoneid = ds.zoneid		
	 WHERE z.delivery NOT IN(6,7,8) AND DATE(ds.date) >= '".$start_date."' AND DATE(ds.date) <= '". $end_date."' ".$condition." ".$groupby." LIMIT ".$row.",".$rowperpage);
 }
	
	$data = array();

	if (isset($getDateReportQuery) && !empty($getDateReportQuery)) {
		while ($row = OA_Dal_Delivery_fetchAssoc($getDateReportQuery)) 
		{
			$publishercpm = OA_Dal_Delivery_Query("SELECT cpm  FROM 
			".$table_prefix."affiliates where affiliateid=".$row['affiliateid']." ");
			$pubrow = OA_Dal_Delivery_fetchAssoc($publishercpm);
			//print_r($pubrow);exit;
			$cpm = ($row['impressions'] > 0) ? ($row['clicks']/$row['impressions'])*100 : 0;

			$ad_res_revenue = ($row['won_bid'] > 0)? $row['won_bid']/1000:0;
			$gross_revenue = ($row['won_bid'] > 0)? $row['won_bid']:0;
			$publisher_revenue=($row['impressions'] > 0)? 
			$row['impressions']*$pubrow['cpm']:0;
			//$gross_revenue = ($cpm/1000)*$row['paid_impressions'];
			$ecpm = ($row['ad_response_revenue'] > 0)?( ($ad_res_revenue/$row['ad_responses'])* 1000 )  : 0;
			//Total Earnings/Impressions x 1000 
			//$ad_req_cpm = ($row['requests'] > 0) ? ($row['gross_revenue']/$row['requests'])*1000 : 0;
			$ad_req_cpm = ($row['auctions'] > 0) ? ($ad_res_revenue/$row['auctions'])*1000 : 0;
			
			$bid_cpm = ($row['impressions'] > 0) ? ($gross_revenue / $row['impressions'])/1000: 0;
			
			if($row['revenue_source']=='PMP')
			{
				$source=$row['revenue_source'];
				
			}
			else if($row['revenue_source']=='open')
			{
				$source=$row['revenue_source'];
				
			}
			else
			{
				$source="-";
			}
			
		    $data[] = array( 				
				
		   		"name" => ($row['name']) ? $row['name']: '-',
				"data_type1" => ($row['data_type1']) ? $row['data_type1'] : '-',
				"data_type2" => ($row['data_type2']) ? $row['data_type2'] : '-',
				"data_type3" => ($row['data_type3']) ? $row['data_type3'] : '-',
				"data_type4" => ($row['data_type4']) ? $row['data_type4'] : '-',
				"data_type5" => ($row['data_type5']) ? $row['data_type5'] : '-',
				"data_type6" => ($row['data_type6']) ? $row['data_type6'] : '-',
				"data_type7" => ($row['data_type7']) ? $row['data_type7'] : '-',
				"data_type8" => ($row['data_type8']) ? $row['data_type8'] : '-',
				"data_type9" => ($row['data_type9']) ? $row['data_type9'] : '-',
				"data_type10" => ($row['data_type10']) ? $row['data_type10'] : '-',
				"data_type11" => ($row['data_type11']) ? $row['data_type11'] : '-',
				"data_type12" => ($row['data_type12']) ? $row['data_type12'] : '-',
				"data_type13" => ($row['data_type13']) ? $row['data_type13'] : '-',
				"data_type14" => ($row['data_type14']) ? $row['data_type14'] : '-',
				"data_type15" => ($row['data_type15']) ? $row['data_type15'] : '-',
				"data_type16" => ($row['data_type16']) ? $row['data_type16'] : '-',
				"keyword" => $row['keyword'],
				"category" => $row['category'],
				"auctions" => $row['auctions'],
				"ad_responses" => $row['ad_responses'],
				"ad_response_revenue" => round($ad_res_revenue, 2),
				"impressions" =>  ($row['impressions'] == 0 || $row['impressions'] == '' ? '0' : $row['impressions']),
				"gross_revenue" => round($gross_revenue, 2),
				"pub_revenue" => round($publisher_revenue, 2),
				"ecpm" => round($ecpm, 2),
				"ad_request_cpm" => round($ad_req_cpm, 2),
				"avg_bid_cpm" => round($bid_cpm,2)
		   );
		   
		}
		
		
	}
	//exit;

	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => $records,
	  "iTotalDisplayRecords" => $records,
	  "aaData" => $data
	);

	echo json_encode($response);
	exit();
?>	
