jQuery.noConflict();
(function($){
    
    function generateChart(start_date, end_date, id, line_dimension, type, limit) {  

        $.ajax({

            url: 'device_report.php',
            type: 'post',
            dataType: 'json',
            data : {'start_date':start_date, 'end_date':end_date, 'line_dimension':line_dimension, 'id': id, 'limit' : limit},
            success: function(dataset){

                Chart.plugins.register({
                    afterDraw: function(chart) {
                        var data = chart.data;
                        if (data.datasets[0].data.length == 0 && data.datasets[1].data.length == 0 && data.datasets[2].data.length == 0 && data.datasets[3].data.length == 0 && data.datasets[4].data.length == 0 && data.datasets[5].data.length == 0) {
                            // No data is present
                            $('#download_btn').hide();
                            var ctx = chart.chart.ctx;
                            var width = chart.chart.width;
                            var height = chart.chart.height
                            chart.clear();
                            ctx.save();
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'middle';
                            ctx.font = "16px normal 'Helvetica Nueue'";
                            ctx.fillText('No data to display', width / 2, height / 2);
                            ctx.restore();
                        } else {
                            $('#download_btn').show();
                        }
                    }
                });

                // draw background
                var backgroundColor = 'white';
                Chart.plugins.register({
                    beforeDraw: function(c) {
                        var ctx = c.chart.ctx;
                        ctx.fillStyle = backgroundColor;
                        ctx.fillRect(0, 0, c.chart.width, c.chart.height);
                    }
                });

                
                backgroundColorData = [ 
                    "rgb(244,67,54)",
                    "rgb(40,50,80)",
                    "rgb(243,195,0)",
                    "rgb(33,150,243)",
                    "rgb(0,150,136)",
                    "rgb(233,30,99)",
                    "rgb(144,44,45)",
                    "rgb(103,58,183)"
                ];

                var ctx = document.getElementById('myChart').getContext("2d");
                if (type != 'pie'){
                    var data = {
                        labels: (dataset.labels ? dataset.labels : []),
                        datasets: [
                        {
                            label: "Request",
                            backgroundColor: "rgb(244,67,54)",
                            data: (dataset.requests ? dataset.requests : [])
                        },
                        {
                            label: "Impression",
                            backgroundColor: "rgb(40,50,80)",
                            data: (dataset.impressions ? dataset.impressions : [])
                        }, {
                            label: "View",
                            backgroundColor: "rgb(243,195,0)",
                            data: (dataset.views ? dataset.views : [])
                        }, {
                            label: "Click",
                            backgroundColor: "rgb(33,150,243)",
                            data: (dataset.clicks ? dataset.clicks : [])
                        }, {
                            label: "Conversion",
                            backgroundColor: "rgb(0,150,136)",
                            data: (dataset.conversions ? dataset.conversions : [])
                        }, {
                            label: "ECPM",
                            backgroundColor: "rgb(233,30,99)",
                            data: (dataset.ecpm ? dataset.ecpm : [])
                        }, {
                            label: "VECPM",
                            backgroundColor: "rgb(144,44,45)",
                            data: (dataset.vecpm ? dataset.vecpm : [])
                        }, {
                            label: "CTR",
                            backgroundColor: "rgb(103,58,183)",
                            data: (dataset.ctr ? dataset.ctr : [])
                        }]}
                }else{
                    var len = dataset.labels.length;
                    var labels = new Array();
                    var val = new Array();
                    var res = new Array();
                    var datas = new Array();
                     if (len == '1'){
                        type = 'doughnut';
                        Object.entries(dataset).forEach(([key, value]) => {
                            if (key != "labels"){
                                labels.push(key.toUpperCase());
                                val.push(value);
                            }
                        });
                            data = {
                                labels: labels,
                                datasets: [{
                                label: (dataset.labels ? dataset.labels : []),
                                backgroundColor: backgroundColorData,
                                data: val,
                            }]}
                    }else{
                        Object.entries(dataset).forEach(([key, value]) => {
                            if (key != "labels"){
                                labels.push(key.toUpperCase());
                                val.push(value);
                            }
                        });
                        var l;
                        for (i=0; i<len;i++){
                            l = dataset.labels ? dataset.labels[i] : [];
                            var m = new Array();
                            for(j=0;j<val.length;j++){
                                m.push(val[j][i]);
                            }
                            console.log(m);
                            res = {label: l,
                                backgroundColor: backgroundColorData,
                                data: m,};
                                // console.log(res);
                                datas.push(res);
                        }
                        
                        // console.log(datas);
                        var data = {
                            labels: labels,
                            datasets: datas,
                        }
                    }
                }
                if (window.bar != undefined) window.bar.destroy();
                window.bar = new Chart(ctx, {
                    type: type,            
                    data: data,
                    options: {
                        barValueSpacing: 20,
                        bezierCurve : false,
                        responsive: true, 
                        responsiveAnimationDuration: 0,
                        animation: {
                            onComplete: done
                        },
                        tooltips: {
                            enabled: true
                        },
                        hover: {
                            animationDuration: 1
                        },
                        scales: {
                            yAxes: [{
                                ticks: {
                                    beginAtZero: true
                                }
                            }]
                        }
                        }
                });

            }

        });
        
    }

    function done(){
        var base64Image = window.bar.toBase64Image();
        $('#download_btn').attr('href', base64Image);
    }

    $('#download_btnpng').unbind().click(function() {
        html2canvas($("#myChart"), {
            onrendered: function(canvas) {
                var a = document.createElement('a');
                a.href = canvas.toDataURL("image/png");
                a.download = formatAMPM() + '.png';
                a.click();
            }
        });
    });

    $('#download_btnjpeg').unbind().click(function() {
        html2canvas($("#myChart"), {
            onrendered: function(canvas) {
                var a = document.createElement('a');
                // toDataURL defaults to png, so we need to request a jpeg, then convert for file download.
                a.href = canvas.toDataURL("image/jpeg").replace("image/jpeg", "image/octet-stream");
                a.download = formatAMPM() + '.jpg';
                a.click();
            }
        });
    });

    $('#download_btnpdf').unbind().click(function() {
        html2canvas($("#myChart"), {
            onrendered: function(canvas) {
                var imgData = canvas.toDataURL('image/png');
                var doc = new jsPDF('p', 'mm');
                doc.addImage(imgData, 'PNG', 10, 10);
                var downpdf = doc.save(formatAMPM() + '.pdf');
                if (downpdf) {
                    return;
                }
            }
        });
    });

    function formatAMPM() {

        var d = new Date();

        // months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        // days = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
        
        return "Device_Report_"+d.getDate()+"_"+d.getMonth()+"_"+d.getFullYear();
    }

    $(document).on('change', '#chart_type', function() { 
        $('#period_end').trigger("change");
    });


    $(document).on('change', '.line_dimension', function() { 
        var line_dimension = $(this).val();
        var start_date = $('#period_start').val();
        var end_date = $('#period_end').val();
        var x_axis = $('#x_axis').val();
        var id = $('#ids').val();

        var val = $('#period_preset').val();

        if (val == 8) {
            var d = new Date();
            
            var start_date = '2019-08-01';
            var end_date = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        }

        if (start_date && end_date) {
            generateTable();
            dropdownmenu();
        } else {
            alert('Please select start and end date');
        }   
    });

    
    function toDate(dateStr) {
        var parts = dateStr.split("-");
        return new Date(parts[2], parts[1] - 1, parts[0]);
    }

    function generateTable() 
    {
        var start_date = $('#period_start').val();
        var end_date = $('#period_end').val();
        var line_dimension = $('.line_dimension').val();
        var id = $('#ids').val();

        var val = $('#period_preset').val();
        var id = $('#ids').val();
        var limit = "limit 0,25";
        var first = 0;


        if (val == 8) {
            var d = new Date();
            
            var start_date = '2019-08-01';
            var end_date = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        }

        var empDataTable=  $('#table_report').DataTable({
            "sScrollX": "100%",
            "sScrollXInner": "200%",
            "scrollY": true,
            "scrollY": "200px",
            'processing': true,
            'serverSide': true,
            'serverMethod': 'post',
            'bDestroy': true,
            'pageLength' : 25,
            'lengthMenu': [[25, 50, 75, 100, -1], [25, 50, 75, 100, "All"]],
            'bFilter' : false,
            'dom': 'l<"toolbar">Bfrtip',
            'buttons': [
                {
                    extend: 'excel',
                    text: 'Excel',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible:not(.notexport)',
                    }
                },
                {
                    extend: 'csv',
                    text: 'CSV',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible:not(.notexport)',
                    }
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    orientation: 'landscape',
                    pageSize: 'LEGAL',

                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible:not(.notexport)',

                    }
                }
            ],
            'ajax': {
                'url':'devrep_datatable.php',
                'data' : {'start_date' : start_date,'end_date' : end_date, 'line_dimension' : line_dimension, 'id' : id }
            },
            'drawCallback':function( settings, json){

                var type = $("#chart_type").val();
                if(first == 0){

                    generateChart(start_date, end_date, id, line_dimension, type, limit);
                }
                
                $('.paginate_button').on('click', function () {
                    var current = empDataTable.page.info();
                    limit = " LIMIT " + current['start'] + "," + current['end'];
                    generateChart(start_date, end_date, id, line_dimension, type, limit);
                    first = 1;
                });
            },
            'columns': [
                { data: 'name' },
                // { data: 'device_version' },
                { data: 'data_type1' },
                { data: 'data_type2' },
                { data: 'data_type3' },
                { data: 'data_type4' },
                { data: 'data_type5' },
                { data: 'data_type6' },
                { data: 'data_type7' },
                { data: 'data_type8' },
                { data: 'request' },
                { data: 'impressions' },
                { data: 'passback' },
                { data: 'views' },
                { data: 'clicks' },
                { data: 'conversions' },
                { data: 'ctr' },
                { data: 'ecpm' },
                { data: 'vctr' },
                { data: 'vecpm' },
                { data: 'total_revenue' },
                { data: 'pub_income' },
                { data: 'ad_fill' },
            ]
        });


        // $("div.toolbar").html('<div><div id="list1" class="dropdown-check-list dropdown-menu" tabindex="100"><span id="anchor" class="anchor">Show/Hide</span><ul id="items" class="items"> <li> <input type="checkbox" name="hide_columns[]" value="0"> Device </li> <li> <input type="checkbox" name="hide_columns[]" value="1"> Device Version </li> <li class="hide_clm2"></li><li class="hide_clm3"></li><li class="hide_clm4"></li><li class="hide_clm5"></li><li class="hide_clm6"></li> <li class="hide_clm7"></li><li class="hide_clm8"><li class="hide_clm9"></li></li><li><input type="checkbox" name="hide_columns[]" value="10"> Request </li>    <li><input type="checkbox" name="hide_columns[]" value="11"> Impression </li> <li><input type="checkbox" name="hide_columns[]" value="12"> Pass back </li> <li><input type="checkbox" name="hide_columns[]" value="13"> Views </li> <li><input type="checkbox" name="hide_columns[]" value="14"> Clicks </li><li><input type="checkbox" name="hide_columns[]"" value="15"> Conversion </li><li><input type="checkbox" name="hide_columns[]"" value="16"> CTR </li><li><input type="checkbox" name="hide_columns[]" value="17"> ECPM</li><li><input type="checkbox" name="hide_columns[]" value="18"> VCTR </li> <li><input type="checkbox" name="hide_columns[]" value="19"> VECPM</li> <li><input type="checkbox" name="hide_columns[]" value="20"> Revenue</li>  <li><input type="checkbox" name="hide_columns[]" value="21">Pub-Rev</li> <li><input type="checkbox" name="hide_columns[]" value="22">Ad Fill Rate</li> </ul></div><div>');


        $("div.toolbar").html('<div><div id="list1" class="dropdown-check-list dropdown-menu" tabindex="100"><span id="anchor" class="anchor">Show/Hide</span><ul id="items" class="items"> <li> <input type="checkbox" name="hide_columns[]" value="0"> Device </li> <li class="hide_clm2"></li><li class="hide_clm3"></li><li class="hide_clm4"></li><li class="hide_clm5"></li><li class="hide_clm6"></li> <li class="hide_clm7"></li><li class="hide_clm8"><li class="hide_clm9"></li></li><li><input type="checkbox" name="hide_columns[]" value="9"> Request </li>    <li><input type="checkbox" name="hide_columns[]" value="10"> Impression </li> <li><input type="checkbox" name="hide_columns[]" value="11"> Pass back </li> <li><input type="checkbox" name="hide_columns[]" value="12"> Views </li> <li><input type="checkbox" name="hide_columns[]" value="13"> Clicks </li><li><input type="checkbox" name="hide_columns[]"" value="14"> Conversion </li><li><input type="checkbox" name="hide_columns[]"" value="15"> CTR </li><li><input type="checkbox" name="hide_columns[]" value="16"> ECPM</li><li><input type="checkbox" name="hide_columns[]" value="17"> VCTR </li> <li><input type="checkbox" name="hide_columns[]" value="18"> VECPM</li> <li><input type="checkbox" name="hide_columns[]" value="19"> Revenue</li>  <li><input type="checkbox" name="hide_columns[]" value="20">Pub-Rev</li> <li><input type="checkbox" name="hide_columns[]" value="21">Ad Fill Rate</li> </ul></div><div>');

        if (line_dimension == "") {
            var dt = $('#table_report').DataTable();

            //hide the first column
            dt.column(1).visible(false);
            dt.column(2).visible(false);
            dt.column(3).visible(false);
            dt.column(4).visible(false);
            dt.column(5).visible(false);
            dt.column(6).visible(false);
            dt.column(7).visible(false);
            dt.column(8).visible(false);
        } else {

            var dt = $('#table_report').DataTable();

            if (line_dimension.includes('1')) {
                dt.column(1).visible(true);
                $(".hide_clm1").html('<input type="checkbox" name="hide_columns[]" value="1"> Advertiser');
            }else{
                dt.column(1).visible(false);
            }if (line_dimension.includes('2')) {
                dt.column(2).visible(true);
                $(".hide_clm2").html('<input type="checkbox" name="hide_columns[]" value="2"> Campaign');
            }else{
                dt.column(2).visible(false);
            }if (line_dimension.includes('3')) {
                 dt.column(3).visible(true);
                $(".hide_clm3").html('<li><input type="checkbox" name="hide_columns[]" value="3"> Banner ');
            }else{
                dt.column(3).visible(false);
            }if (line_dimension.includes('4')) {
                 dt.column(4).visible(true);
                $(".hide_clm4").html('<li><input type="checkbox" name="hide_columns[]" value="4"> Publisher ');
            }else{
                dt.column(4).visible(false);
            }if (line_dimension.includes('5')) {
                 dt.column(5).visible(true);
                $(".hide_clm5").html('<li><input type="checkbox" name="hide_columns[]" value="5"> Website ');
            }else{
                dt.column(5).visible(false);
            }if (line_dimension.includes('6')) {
                 dt.column(6).visible(true);
                $(".hide_clm6").html('<li><input type="checkbox" name="hide_columns[]" value="6"> Zone ');
            }else{
                dt.column(6).visible(false);
            }if (line_dimension.includes('7')) {
                 dt.column(7).visible(true);
                $(".hide_clm7").html('<li><input type="checkbox" name="hide_columns[]" value="7"> Date ');
            }else{
                dt.column(7).visible(false);
            }if (line_dimension.includes('8')) {
                 dt.column(8).visible(true);
                $(".hide_clm8").html('<li><input type="checkbox" name="hide_columns[]" value="8"> Geo ');
            }else{
                dt.column(8).visible(false);
            }
        
        }

        // Hide & show columns
        $('.items').click(function() {
            var checked_arr = [];
            var unchecked_arr = [];
            $.each($('input[type="checkbox"]:checked'), function(key, value) {
                checked_arr.push(this.value);
            });
            // Read all unchecked checkboxes
            $.each($('input[type="checkbox"]:not(:checked)'), function(key, value) {
                unchecked_arr.push(this.value);
            });

            // Hide the checked columns
            empDataTable.columns(checked_arr).visible(false);
            // Show the unchecked columns
            empDataTable.columns(unchecked_arr).visible(true);
        });  
    }

    $(document).ready(function(){
        var d = new Date();
        var strDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        $('#period_end').val(strDate);
        $("#period_start").val(strDate);

        $('#period_end').trigger("change");

        $('#x_axis').multiSelect({
            afterSelect: function(values){
                var values = $('#x_axis').val();
                $('#period_end').trigger("change");
            },

            afterDeselect: function(values){
                var values = $('#x_axis').val();
                $('#period_end').trigger("change");
            }
        });
    });

   
    $(document).on('change','#period_preset',function(){
        var val = $(this).val();
        var d = new Date();

        if (val == 1) {
            var strDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
            $('#period_end').val(strDate);
            $("#period_start").val(strDate);
            $('#period_end').trigger("change");
        } else if (val == 2) {
            var strDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+(d.getDate()-1);
            $('#period_end').val(strDate);
            $("#period_start").val(strDate);
            $('#period_end').trigger("change");
        } else if (val == 3) {
            var current = new Date();     // get current date    
            var weekstart = current.getDate() - current.getDay() +1;    
            var weekend = weekstart + 6;       // end day is the first day + 6 

            var d = new Date(current.setDate(weekstart));
            var strDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();

            var e = new Date(current.setDate(weekend));
            var endDate = e.getFullYear()+"-"+(e.getMonth()+1)+"-"+e.getDate();

            $('#period_start').val(strDate);  
            $("#period_end").val(endDate);
            $('#period_end').trigger("change");
        } else if(val == 4) {
            d.setTime(d.getTime() - (d.getDay() ? d.getDay() : 7) * 24 * 60 * 60 * 1000);

            $("#period_end").val(d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate());

            d.setTime(d.getTime() - 6 * 24 * 60 * 60 * 1000);
            $("#period_start").val(d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate());

            $('#period_end').trigger("change");
        } else if (val == 5) {
            var strDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+(d.getDate());
            var endDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+(d.getDate()-7);
            $('#period_end').val(strDate);
            $("#period_start").val(endDate);

            $('#period_end').trigger("change");
        } else if (val == 6) {
            var firstDay = new Date(d.getFullYear(), d.getMonth(), 1);
            var lastDay = new Date(d.getFullYear(), d.getMonth() + 1, 0);

            var strDate = firstDay.getFullYear()+"-"+(firstDay.getMonth()+1)+"-"+(firstDay.getDate());
            var endDate = lastDay.getFullYear()+"-"+(lastDay.getMonth()+1)+"-"+(lastDay.getDate());

            $('#period_start').val(strDate);
            $("#period_end").val(endDate);

            $('#period_end').trigger("change");
        } else if (val == 7) {
            var prevMonthLastDate = new Date(d.getFullYear(), d.getMonth(), 0);
            var prevMonthFirstDate = new Date(d.getFullYear() - (d.getMonth() > 0 ? 0 : 1), (d.getMonth() - 1 + 12) % 12, 1);

            var strDate = prevMonthFirstDate.getFullYear()+"-"+(prevMonthFirstDate.getMonth()+1)+"-"+(prevMonthFirstDate.getDate());
            var endDate = prevMonthLastDate.getFullYear()+"-"+(prevMonthLastDate.getMonth()+1)+"-"+(prevMonthLastDate.getDate());

            $('#period_start').val(strDate);
            $("#period_end").val(endDate);

            $('#period_end').trigger("change");
        } else if (val == 8) {

            /*var strDate = '2019-08-01';
            var endDate = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();*/

            $('#period_start').val('');
            $("#period_end").val('');

            $('#period_end').trigger("change");
        }
    });

    /*$(document).on('change','#x_axis',function(){
        $('#period_end').trigger("change");
    });*/

    function getChartData(start_date, end_date, line_dimension = '', x_axis='') {
        generateTable();
        dropdownmenu();
    }

    $(document).on('change','#period_end',function(){
        var start_date = $('#period_start').val();
        var end_date = $('#period_end').val();
        var line_dimension = $('.line_dimension').val();
        var x_axis = $('#x_axis').val();

        var val = $('#period_preset').val();

        if (val == 8) {
            var d = new Date();
            
            var start_date = '2019-08-01';
            var end_date = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        }

        var change_start_date = new Date(start_date);
        var change_end_date = new Date(end_date);

        if (change_start_date && end_date) {
            if (change_start_date <= change_end_date) {
                getChartData(start_date, end_date, line_dimension, x_axis);
            } else {
                $('#period_end').val('');
                $('#period_start').val('');
                alert('Start date must be less than end data');
            }    
        }
    });

    function catcalc(cal,type) {
        var date = cal.date;
        var time = date.getTime()

        var field = document.getElementById(type);
        var date2 = new Date(time);
        field.value = date2.print("%Y-%m-%d");

        $('#period_end').trigger("change");
    }


    Calendar.setup({
        inputField : 'period_start',
        ifFormat   : '%Y-%m-%d',
        button     : 'period_start_button',
        align      : 'Bl',
        weekNumbers: false,
        firstDay   : 1,
        electric   : false,
        onSelect : function(cal){
            catcalc(cal,'period_start')
        }
    });

    Calendar.setup({
        inputField : 'period_end',
        ifFormat   : '%Y-%m-%d',
        button     : 'period_end_button',
        align      : 'Bl',
        weekNumbers: false,
        firstDay   : 1,
        electric   : false,
        onSelect : function(cal){
            catcalc(cal,'period_end')
        }
    });

    function dropdownmenu() {
        var checkList = document.getElementById('list1');
        var items = document.getElementById('items');

        checkList.getElementsByClassName('anchor')[0].onclick = function(evt) {
            if (items.classList.contains('visible')) {
                items.classList.remove('visible');
                items.style.display = "none";
            } else {
                items.classList.add('visible');
                items.style.display = "block";
            }
        }

        items.onblur = function(evt) {
            items.classList.remove('visible');
        }
        
        $(document).mouseup(function(e) {
            if ($(e.target).closest(".items").length === 0) {
                items.classList.remove('visible');
                items.style.display = "none";
            }
        });
    }

    $(document).on('click','.time-data',function()
    {
        var cur_date = $(this).attr('cur_date');
        var id = $('#ids').val();

        if (cur_date) 
        {
            $('#table_report').DataTable({
                "sScrollX": "100%",
                "sScrollXInner": "200%",
                "scrollY": true,
                "scrollY": "200px",
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'bDestroy': true,
                'bSort' : false,
                'pageLength' : 25,
                'lengthMenu': [[25], [25]],
                'bFilter' : false,
                'dom': 'l<"toolbar">Bfrtip',
                'buttons': [
                    {
                        extend: 'excel',
                        text: 'Excel',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':visible:not(.notexport)',
                        }
                    },
                    {
                        extend: 'csv',
                        text: 'CSV',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':visible:not(.notexport)',
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        orientation: 'landscape',
                        pageSize: 'LEGAL',

                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':visible:not(.notexport)',

                        }
                    }
                ],
                'ajax': {
                    'url':'timewise_data_tables.php',
                    'data' : {'cur_date' : cur_date, 'type' : 9, 'id' : id }
                },
                'columns': [
                    { data: 'name' },
                    { data: 'name1' },
                    { data: 'data_type1' },
                    { data: 'data_type2' },
                    { data: 'data_type3' },
                    { data: 'data_type4' },
                    { data: 'data_type5' },
                    { data: 'data_type6' },
                    { data: 'data_type7' },
                    { data: 'data_type8' },
                    { data: 'request' },
                    { data: 'impressions' },
                    { data: 'passback' },
                    { data: 'views' },
                    { data: 'clicks' },
                    { data: 'conversions' },
                    { data: 'ctr' },
                    { data: 'ecpm' },
                    { data: 'vctr' },
                    { data: 'vecpm' },
                    { data: 'total_revenue' },
                    { data: 'pub_income' },
                    { data: 'ad_fill' },
                ]
            });
        } else {
            alert('Something went wrong');
        }
    });
    var dt = $('#table_report').DataTable();
    dt.column(8).visible(false);

    var isOpen = 0;
    $(document).on('click','.switchTrigger',function() {
        if (isOpen == 0) {
            $(".accountSwitcher").addClass("expanded");
            $('accountSwitcherOverlay').css({ display: "block" });
            isOpen++;
        } else {
            $(".accountSwitcher").removeClass("expanded");
            $('accountSwitcherOverlay').css({ display: "none" });
            isOpen--;
        }
    });
})(jQuery);
