<?php
   
   ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
   header("Access-Control-Allow-Origin: *");
   header("Content-Type: application/json; charset=UTF-8");
   header("Access-Control-Allow-Methods: POST");
   header("Access-Control-Max-Age: 3600");
   header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

   require_once '../../../../init.php';
      
   ## Required files
   require_once MAX_PATH . '/lib/OA/Dal.php';      
   require_once MAX_PATH . '/lib/OA/Admin/Option.php';
   require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
   require_once MAX_PATH . '/www/admin/config.php';
   require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
     
   if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
   }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
   }

   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];


   $data = array(); 

   $labels = array();
   $request =array();
   $impressions = array();
   $clicks = array();
   $conversions = array();
   $views = array();
   $ecpm = array();
   $vecpm = array();
   $ctr = array();
   $total_revenue = array();

   ## ACCOUNT TYPE
   if(isset($_POST['id']) && !empty($_POST['id'])) {
      $id = explode('=', $_POST['id']);
   }

   $condition = '';

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND a.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }

   
   ## INITIALISATIN
   $getQuery = '';
   $limit = "";
   $id = "";
   $groupby = "";
   $data_type = " CONCAT(z.width,'X', z.height) AS data_type ";

   ## REQUIRED POST VALIES
   $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   $start_date = $_POST['start_date'];
   $end_date = $_POST['end_date'];
   $line_dimension = $_POST['line_dimension'];
   $total_record = $_POST['count'];
   $rowperpage = $_POST['length']; // Rows display per page
   $columnIndex = $_POST['order'][0]['column']; // Column index
   $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
   $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
   $searchValue = $_POST['search']['value']; // Search value



   ## LINE DIMENSION
   if(!$line_dimension[0]) {

      $groupby = " GROUP BY CONCAT(z.width,'X', z.height) ";

   }else{
      
      $groupby = " GROUP BY ";
      $data_type = "";
      $length  = sizeof($line_dimension);
      $i = 0;

      foreach ($line_dimension as $key) {

     	if($key == 1){

			$groupby .= "cl.clientid ";
			$data_type .= " cl.clientname AS data_type";

		}else if($key == 2){

			$groupby .= "c.campaignid ";
			$data_type .= " c.campaignname AS data_type";

		}else if($key == 3){

			$groupby .= "b.bannerid ";
			$data_type .= " b.description AS data_type";

		}else if($key == 4){

			$groupby .= "p.id ";
			$data_type .= " p.name AS data_type";

		}else if($key == 5){

			$groupby .= "a.affiliateid ";
			$data_type .= " a.name AS data_type";

		}else if($key == 6){

			$groupby .= "z.zonename ";
			$data_type .= " z.zonename AS data_type";

		}else if($key == 7){

			$groupby .= "DATE(adh.date_time) ";
			$data_type .= " DATE(adh.date_time) AS data_type";

		}else if($key == 8){

			$groupby .= "sco.country ";
			$data_type .= " sco.country AS data_type";

		}$i++;
		if($i < $length){
			$groupby .= ',';
			$data_type .= ',';
		}

      }
   }

   //~ $getQuery = " SELECT {$data_type}, z.width, z.height, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id LEFT JOIN {$table_prefix}stats_country sco ON sco.zone_id = adh.zone_id  WHERE adh.ad_id > 0 AND DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$groupby . $_POST['limit'];
   
   $getQuery = " SELECT {$data_type}, z.width, z.height, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.views) as views, SUM(adh.conversions) as conversions, SUM(adh.pub_income) as pub_income, SUM(adh.total_revenue) AS total_revenue FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}publishers p ON p.id = a.publisher_id   WHERE adh.ad_id > 0 AND b.exchange_id IS NULL AND DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$groupby . $_POST['limit'];
   
   $data = array();
   $getQuery = OA_Dal_Delivery_Query($getQuery);

   
   while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) 
   {
      $name = '';
      if( $aRow['width'] == '-1' && $aRow['height'] == '-1'){
         $name = 'Image';
      }else if( $aRow['width'] == '-2' && $aRow['height'] == '-2'){
         $name = 'Overlay';
      }else if( $aRow['width'] == '-3' && $aRow['height'] == '-3'){
         $name = 'Inline';
      }else if( $aRow['width'] == '-6' && $aRow['height'] == '-6'){
         $name = 'Inline';
      }else if( $aRow['width'] == '-7' && $aRow['height'] == '-7'){
         $name = 'Audio';
      }else if( $aRow['width'] == '-9' && $aRow['height'] == '-9'){
         $name = 'Audio';
      }else if( $aRow['width'] == '-10' && $aRow['height'] == '-10'){
         $name = 'Outstream';
      }else if( $aRow['width'] == '-8' && $aRow['height'] == '-8'){
         $name = 'Outstream';
      }
      else{
         $name = $aRow['data_type'];
      }

      $labels[] = (strlen($name) > 5 ? substr($name,0,10)."..." : $name);
      $requests[] = $aRow['requests'];
      $impressions[] = $aRow['impressions'];
      $clicks[] = $aRow['clicks'];
      $views[] = $aRow['views'];
      $conversions[] = $aRow['conversions'];
      $total_revenue[] = $aRow['total_revenue'];

        $ctr[] = ($aRow['impressions'] > 0)? round($aRow['clicks']/$aRow['impressions']*100, 2) : 0.00;
        $ecpm[] = ($aRow['impressions'] > 0)? round($aRow['total_revenue']/$aRow['impressions']*1000, 2) : 0.00;
        $vecpm[] = ($aRow['views'] > 0)? round($aRow['total_revenue']/$aRow['views']*1000, 2) : 0.00;
    }

    $data = array('labels' => $labels,'requests'=>$requests,'impressions' => $impressions, 'clicks' => $clicks, 'conversions'=>$conversions, 'views'=>$views, 'ecpm'=>$ecpm, 'vecpm'=>$vecpm,'ctr'=>$ctr);

      echo json_encode($data);
   exit();
