<?php

/*
 * @copyright   2016 Mautic, Inc. All rights reserved
 * @author      Mautic, Inc
 *
 * @link        https://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Helper;

use Mautic\AssetBundle\Helper\TokenHelper as AssetTokenHelper;
use Mautic\LeadBundle\Entity\Lead;
use Mautic\LeadBundle\Helper\TokenHelper;
use Mautic\PageBundle\Entity\Trackable;
use Mautic\PageBundle\Helper\TokenHelper as PageTokenHelper;
use Mautic\PageBundle\Model\TrackableModel;
use Mautic\PluginBundle\Helper\IntegrationHelper;
use MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharsmsModel;

/**
 * Class CampaignEventHelper.
 */
class CampaignEventHelper
{
    /**
     * @var IntegrationHelper
     */
    protected $integrationHelper;

    /**
     * @var TrackableModel
     */
    protected $trackableModel;

    /**
     * @var PageTokenHelper
     */
    protected $pageTokenHelper;

    /**
     * @var AssetTokenHelper
     */
    protected $assetTokenHelper;

    /**
     * @var textalertModel
     */
    protected $myupcharsmsModel;

    /**
     * @var array
     */
    protected $clickthrough = [];

    /**
     * CampaignEventHelper constructor.
     *
     * @param IntegrationHelper $integrationHelper
     * @param TrackableModel    $trackableModel
     * @param PageTokenHelper   $pageTokenHelper
     * @param AssetTokenHelper  $assetTokenHelper
     * @param MyupcharsmsModel        $myupcharsmsModel
     */
    public function __construct(
        IntegrationHelper $integrationHelper,
        TrackableModel $trackableModel,
        PageTokenHelper $pageTokenHelper,
        AssetTokenHelper $assetTokenHelper,
        MyupcharsmsModel $myupcharsmsModel
    ) {
        $this->integrationHelper = $integrationHelper;
        $this->trackableModel    = $trackableModel;
        $this->pageTokenHelper   = $pageTokenHelper;
        $this->assetTokenHelper  = $assetTokenHelper;
        $this->textalertModel    = $myupcharsmsModel;
    }

    /**
     * @param Lead  $lead
     * @param array $event
     *
     * @return array|false
     */
    public function sendTextAction(Lead $lead, array $event)
    {
        $response = ['failed' => 1, 'response' => "success"];

        return $response;
    }
}
