<?php

/*
 * @copyright   2016 Mautic, Inc. All rights reserved
 * @author      Mautic, Inc
 *
 * @link        https://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Form\Type;

use Mautic\CoreBundle\Form\EventListener\CleanFormSubscriber;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Mautic\CoreBundle\Form\Type\FormButtonsType;
use Mautic\CoreBundle\Form\Type\ButtonGroupType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MyupcharyType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->addEventSubscriber(new CleanFormSubscriber());

        $contenttype= array(
            'Plain 7-Bit Text' => '1',
            'Plain 7-Bit Text' => '2',
            'For Unicode' => '3',
            'Nokia Ring tone Mono' =>'4',
            'Nokia V-Card' => '5',
            'Plain EMS Message' => '6',
            'Operator Logo' => '7',
            'Picture Message' => '8',
            'Reserved' => '9',
            'Plain SI Message' => '10',
            'Reserved' => '11',
            'Group Grphics' => '12',
            'Flash Message' => '13',
            'Reserved' => '14',
            'EMS Picture/Ring tone' => '15',
            'For Internal Use' =>'16',
            'DRM Content' =>'17');

        $builder->add('contenttype', ChoiceType::class, [
            'required' => true,
            'label'      => 'mautic.myupchar.contenttype',
            'label_attr' => ['class' => 'control-label'],
            'choices'    =>$contenttype,
            'attr'              => [
               'class'   => 'form-control',
               'tooltip' => 'Content type'
           ],
        ]);

        $builder->add('message',  TextareaType::class, [
            'label'      => 'mautic.myupchar.message',
            'label_attr' => ['class' => 'control-label'],
            'attr'       => ['class' => 'form-control editor'],
            'required'   => true,
        ]);
        
        

	    $builder->add('alert', ButtonGroupType::class, [
            'label'   => 'mautic.myupcharsms.myupcharsms.form.alert',
            'choices' => [
                'mautic.myupcharsms.myupcharsms.form.alert.afalse'  => '0',
                'mautic.myupcharsms.myupcharsms.form.alert.atrue' => '1',
            ]

        ]);

        $builder->add('selfid', ButtonGroupType::class, [
            'label'   => 'mautic.myupcharsms.myupcharsms.form.selfid',
            'choices' => [
                'mautic.myupcharsms.myupcharsms.form.selfid.sfalse'  => 'false',
                'mautic.myupcharsms.myupcharsms.form.selfid.strue' => 'true',
            ]

        ]);

        $builder->add('dlrreq', ButtonGroupType::class, [
            'label'   => 'mautic.myupcharsms.myupcharsms.form.dlrreq',
            'choices' => [
                 'mautic.myupcharsms.myupcharsms.form.dlrreq.dfalse' => 'false' ,
                 'mautic.myupcharsms.myupcharsms.form.dlrreq.dtrue' => 'true' ,
            ]
        ]);



	
        $builder->add('buttons', FormButtonsType::class);
    }

    /**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults([
                'data_class' => 'MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupchar',
            ]);

        // allow network types to be sent through - list
       // $resolver->setRequired(['networkTypes']);

        // allow the specific network type - single
        //$resolver->setOptional(['networkType']);
    }

    public function getName()
    {
        return 'myup';
    }

   
}
