<?php

/*
 * @copyright   2015 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharsmsModel;
use Mautic\CoreBundle\Form\Type\FormButtonsType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class MyupcharsmsType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public $MyupcharsmsModel;
    public function __construct(MyupcharsmsModel $MyupcharsmsModel)
    {
      
        $this->MyupcharsmsModel = $MyupcharsmsModel;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {


        $builder->add(
            'objectId',
             HiddenType::class,
            [
                'attr' => [
                    'message' => $options['data']['objectId'],
                ],
            ]
        );

        $builder->add(
            'buttons',
            FormButtonsType::class,
            [
                'apply_text'     => false,
                'save_text'      => 'mautic.core.form.submit',
                'cancel_onclick' => 'javascript:void(0);',
                'cancel_attr'    => [
                    'data-dismiss' => 'modal',
                ],
            ]
        );
        
        $Multimyupcharsms = $this->MyupcharsmsModel->getMyupcharType();
        $smslist   = [];
       
        foreach ($Multimyupcharsms as $myupcharsms) {

                $smslist[$myupcharsms['message']] = $myupcharsms['message'];
           
        }
 
        $builder->add('sms_msg', ChoiceType::class, array(
            'choices' => $smslist,
            'label'      => 'mautic.widget.myupcharsms',
                    'label_attr' => ['class' => 'control-label'],
                    'required'   => true,
                    'multiple'   => false,
                    'attr'       => [
                        'class' => 'form-control',
                    ],
        ));

        if (!empty($options['action'])) {
            $builder->setAction($options['action']);
        }
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return 'myupcharsms_form';
    }
}
