<?php

/*
 * @copyright   2014 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\EventListener;

use Mautic\DashboardBundle\Event\WidgetDetailEvent;
use Mautic\DashboardBundle\EventListener\DashboardSubscriber as MainDashboardSubscriber;
use MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharsmsModel;

/**
 * Class DashboardSubscriber.
 */
class DashboardSubscriber extends MainDashboardSubscriber
{
    /**
     * Define the name of the bundle/category of the widget(s).
     *
     * @var string
     */
    protected $bundle = 'myupcharsms';

    /**
     * Define the widget(s).
     *
     * @var string
     */
    protected $types = [
        'myupcharsms' => [],
    ];

    /**
     * Define permissions to see those widgets.
     *
     * @var array
     */
    protected $permissions = [
        'myupchar:myupcharsms:viewown',
        'myupchar:myupcharsms:viewother',
    ];

    /**
     * @var myupcharsmsModel
     */
    protected $myupcharsmsModel;

    /**
     * DashboardSubscriber constructor.
     *
     * @param MyupcharsmsModel $myupcharsmsModel
     */
    public function __construct(MyupcharsmsModel $myupcharsmsModel)
    {
        $this->myupcharsmsModel = $myupcharsmsModel;
    }

    /**
     * Set a widget detail when needed.
     *
     * @param WidgetDetailEvent $event
     */
    public function onWidgetDetailGenerate(WidgetDetailEvent $event)
    {
        $this->checkPermissions($event);
        $canViewOthers = $event->hasPermission('myupchar:myupcharsms:viewother');
       if ($event->getType() == 'myupcharsms') {
            if (!$event->isCached()) {
                $params = $event->getWidget()->getParams();


                if (empty($params['limit'])) {
                    // Count the list limit from the widget height
                    $limit = round((($event->getWidget()->getHeight() - 80) / 35) - 1);
                } else {
                    $limit = $params['limit'];
                }

				$params['dateTo'] = $params['dateTo']->modify('+1 day');
                $lists = $this->myupcharsmsModel->getMyupcharsmsLists($limit, $params['dateFrom'], $params['dateTo'], $canViewOthers);
                $items = [];

                // Build table rows with links
                if ($lists) {
                    foreach ($lists as &$list) {

                         $row        = [
                            [
                                'value' => $list['sentTime'],
                                'type'  => 'text',
                            ],
                            [
                                'value' => $list['lead_id'],
                                'type'  => 'text',
                            ],
                            [
                                'value' => $list['mobileNo'],
                                'type'  => 'text',
                            ],
                            [
                                'value' => ucfirst($list['response_status']),
                                'type'  => 'text',
                            ],

                        ];
                        $items[] = $row;
                    }
                }

                $event->setTemplateData([
                    'headItems' => [
                        'mautic.myupcharsms.label.date',
                        'mautic.myupcharsms.label.leadid',
                        'mautic.myupcharsms.label.mobileno',
                        'mautic.myupcharsms.label.resstatus',
  
                    ],
                    'bodyItems' => $items,
                    'raw'       => $lists,
                ]);
            }

            $event->setTemplate('MauticCoreBundle:Helper:table.html.php');
            $event->stopPropagation();

            return;
        }
    }
}
