<?php

/*
 * @copyright   2014 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */


namespace MauticPlugin\MauticMyupcharSmsBundle\Entity;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupcharsms;
use Mautic\CoreBundle\Entity\CommonRepository;

/**
 * CampaignRepository.
 */
class MyupcharsmsRepository extends CommonRepository
{
    /**
     * {@inheritdoc}
     */
    public function getEntities(array $args = [])
    {
        $q = $this->getEntityManager()
            ->createQueryBuilder()
            ->select($this->getTableAlias())
            ->from('MauticMyupcharSmsBundle:Myupcharsms', $this->getTableAlias());

        $args['qb'] = $q;
        
        return parent::getEntities($args);
    }


    public function getMyupcharRow($id){
        $q = $this->getEntityManager()->getConnection()->createQueryBuilder();

        $q->select('ta.*')
            ->from(MAUTIC_TABLE_PREFIX.'myupcharsms', 'ta')
            ->where('ta.response_id="'.$id.'"');
        $result = $q->execute()->fetchAll();
        return $result[0];
    }
    public function setMyupcharRow($id,$newStatus){

		$data =  $this->createQueryBuilder('u')
            ->update()
            ->set('u.response_status', '?1')
            ->setParameter(1, $newStatus)
            ->set('u.callStatus', '?2')
            ->setParameter(2, $newStatus)
            ->where('u.id = ?3')
            ->setParameter(3, $id)
            ->getQuery()
            ->getSingleScalarResult()
        ;
        
        return $data;
        
    }

    public function getMyupcharType(){
        $q = $this->getEntityManager()->getConnection()->createQueryBuilder();

        $q->select('ta.*')
            ->from(MAUTIC_TABLE_PREFIX.'myupchar_lists', 'ta');
        $result = $q->execute()->fetchAll();
        return $result;
    }

    
    /**
     * @return string
     */
    public function getTableAlias()
    {
        return 'ta';
    }

}
