<?php

/*
 * @copyright   2016 Mautic, Inc. All rights reserved
 * @author      Mautic, Inc
 *
 * @link        https://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Entity;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupchar;

use Doctrine\ORM\Mapping as ORM;
use Mautic\CoreBundle\Doctrine\Mapping\ClassMetadataBuilder;
use Mautic\CoreBundle\Entity\FormEntity;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Mapping\ClassMetadata;

/**
 * Class Monitoring.
 */
class Myupchar
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $contenttype;
    private $alert = 1;
    private $selfid='true';
    private $dlrreq='true';
    private $intflag=0;

/**
     * @var string
     */
    //~ private $networkType;

    public static function loadMetadata(ORM\ClassMetadata $metadata)
    {
        $builder = new ClassMetadataBuilder($metadata);

        $builder->setTable('myupchar_lists')
            ->setCustomRepositoryClass('MauticPlugin\MauticMyupcharSmsBundle\Entity\MyupcharRepository');
 
			$builder->addId();

			$builder->createField('message', 'text')
				 ->columnName('message')
				->length(100)
				->nullable()
				->build();
	
			$builder->createField('contenttype', 'integer')
				->columnName('contenttype')
				->nullable()
				->build();

            $builder->createField('alert', 'string')
            ->columnName('alert')
            ->nullable()
            ->build();

            $builder->createField('selfid', 'string')
            ->columnName('selfid')
           ->nullable()
           ->build();

           $builder->createField('dlrreq', 'string')
              ->columnName('dlrreq')
             ->nullable()
             ->build();

            $builder->createField('intflag', 'string')
             ->columnName('intflag')
            ->nullable()
            ->build();

       //$builder->addNamedField('networkType', 'string', 'network_type', true);
    }

	protected function isChanged($prop, $val)
	{
		$getter  = 'get'.ucfirst($prop);
		$current = $this->$getter();
		$this->changes[$prop] = [$current, $val];
	}
	public function setId($id)
	{
		$this->isChanged('id', $id);
		$this->id = $id;
	}

    public function getId()
    {
        return $this->id;
	}

	public function setMessage($message)
	{
		$this->isChanged('message', $message);
		$this->message = $message;
	}

    public function getMessage()
    {
        return $this->message;
	}
	public function setContenttype($contenttype)
	{
		$this->isChanged('contenttype', $contenttype);
		$this->contenttype = $contenttype;
	}

    public function getContenttype()
    {
        return $this->contenttype;
	}
    public function setAlert($alert)
    {
        $this->isChanged('alert', $alert);
        $this->alert = $alert;

        return $this;
    }
    public function setSelfid($selfid)
    {
        $this->isChanged('selfid', $selfid);
        $this->selfid = $selfid;

        return $this;
    }

    /**
     * Get self id.
     *
     * @return string
     */
    public function getSelfid()
    {
        if (null === $this->selfid) {
            $this->selfid = 'true';
        }

        return $this->selfid;
    }

    /**
     * Get alert.
     *
     * @return string
     */
    public function getAlert()
    {
        if (null === $this->alert)
        {
            $this->alert = '1';
        }

        return $this->alert;
    }

    /**
     * Get delivery request.
     *
     * @return string
     */
    public function getDlrreq()
    {
        if (null === $this->dlrreq) {
            $this->dlrreq = 'true';
        }

        return $this->dlrreq;
    }

    public function setDlrreq($dlrreq)
    {
        $this->isChanged('dlrreq', $dlrreq);
        $this->dlrreq = $dlrreq;

        return $this;
    }

    public function setIntflag($intflag)
    {
        $this->isChanged('intflag', $intflag);
        $this->intflag = $intflag;

        return $this;
    }
    /**
     * Get Intflag.
     *
     * @return string
     */
    public function getIntflag()
    {
        if (null === $this->intflag) {
            $this->intflag = '0';
        }

        return $this->intflag;
    }


	
	public static function loadValidatorMetadata(ClassMetadata $metadata)
    {
        $metadata->addPropertyConstraint('message', new Assert\NotBlank(
            ['message' => 'A message is required']
        ));

        //$metadata->addPropertyConstraint('messagetype', new Assert\NotBlank(
        //    ['message' => 'Messagetype is Required']
       // ));
        
    }

}
