/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.converter;

import com.google.gson.Gson;
import com.highcharts.export.converter.SVGConverterException;
import com.highcharts.export.pool.BlockingQueuePool;
import com.highcharts.export.pool.PoolException;
import com.highcharts.export.server.Server;
import com.highcharts.export.util.MimeType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="svgConverter")
public class SVGConverter {
    @Autowired
    private BlockingQueuePool serverPool;
    protected static Logger logger = Logger.getLogger((String)"converter");

    public ByteArrayOutputStream convert(String input, MimeType mime, String constructor, String callback, Float width, Float scale) throws SVGConverterException, IOException, PoolException, NoSuchElementException, TimeoutException {
        return this.convert(input, null, null, null, mime, constructor, callback, width, scale);
    }

    public ByteArrayOutputStream convert(String input, String globalOptions, String dataOptions, String customCode, MimeType mime, String constructor, String callback, Float width, Float scale) throws SVGConverterException, IOException, PoolException, NoSuchElementException, TimeoutException {
        String json;
        String output;
        ByteArrayOutputStream stream = null;
        String extension = mime.name().toLowerCase();
        String outFilename = this.createUniqueFileName("." + extension);
        HashMap<String, String> params = new HashMap<String, String>();
        Gson gson = new Gson();
        params.put("infile", input);
        params.put("outfile", outFilename);
        if (constructor != null && !constructor.isEmpty()) {
            params.put("constr", constructor);
        }
        if (callback != null && !callback.isEmpty()) {
            params.put("callback", callback);
        }
        if (globalOptions != null && !globalOptions.isEmpty()) {
            params.put("globaloptions", globalOptions);
        }
        if (dataOptions != null && !dataOptions.isEmpty()) {
            params.put("dataoptions", dataOptions);
        }
        if (customCode != null && !customCode.isEmpty()) {
            params.put("customcode", customCode);
        }
        if (width != null) {
            params.put("width", String.valueOf(width));
        }
        if (scale != null) {
            params.put("scale", String.valueOf(scale));
        }
        if ((output = this.requestServer(json = gson.toJson(params))).substring(0, 5).equalsIgnoreCase("error")) {
            logger.debug((Object)("recveived error from phantomjs: " + output));
            throw new SVGConverterException("recveived error from phantomjs:" + output);
        }
        stream = new ByteArrayOutputStream();
        if (output.equalsIgnoreCase(outFilename)) {
            stream.write(FileUtils.readFileToByteArray((File)new File(outFilename)));
        } else if (extension.equals("svg")) {
            stream.write(output.getBytes());
        } else {
            stream.write(Base64.decodeBase64((String)output));
        }
        return stream;
    }

    public String requestServer(String params) throws SVGConverterException, TimeoutException, NoSuchElementException, PoolException {
        Server server = null;
        try {
            String response;
            server = (Server)this.serverPool.borrowObject();
            String string = response = server.request(params);
            return string;
        }
        catch (SocketTimeoutException ste) {
            throw new TimeoutException(ste.getMessage());
        }
        catch (TimeoutException te) {
            throw new TimeoutException(te.getMessage());
        }
        catch (PoolException nse) {
            logger.error((Object)"POOL EXHAUSTED!!");
            throw new PoolException(nse.getMessage());
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            throw new SVGConverterException("Error converting SVG" + e.getMessage());
        }
        finally {
            try {
                this.serverPool.returnObject(server, true);
            }
            catch (Exception e) {
                logger.error((Object)("Exception while returning server to pool: " + e.getMessage()));
            }
        }
    }

    public String createUniqueFileName(String extension) throws IOException {
        return System.getProperty("java.io.tmpdir") + "/" + RandomStringUtils.randomAlphanumeric((int)8) + extension;
    }
}

