package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.dto.SspCreateDTO;
import com.example.demo.dto.SspDeleteDTO;
import com.example.demo.dto.SspResponseDTO;
import com.example.demo.dto.SspUpdateDTO;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.Ssp;
import com.example.demo.redisentity.SspRedis;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.SspRepository;
import com.example.demo.service.SspService;

import redis.clients.jedis.Jedis;

@Service
public class SspServiceImpl implements SspService{

	@Autowired
	private SspRepository repo;
	
	@Autowired
	private ConfigurationRepo configRepo;

	@Autowired
	private Jedis jedis;
	
	@Override
	public APIResponse createssp(SspCreateDTO create) {
		APIResponse api = new APIResponse();
		
		Ssp ssp = new Ssp();
		ssp.setAdexchange_name(create.getAdexchange_name());
		ssp.setCreated_by(create.getCreated_by());
		ssp.setEmail(create.getEmail());
		ssp.setRtb_mode(create.getRtb_mode());
		ssp.setVersion(create.getVersion());
		ssp.setCreated_at(LocalDateTime.now());
		ssp.setUpdated_at(LocalDateTime.now());
		ssp.setStatus(1);
	    repo.save(ssp);
	    
	    SspRedis sspredis = new SspRedis();
	    
	    sspredis.setAdexchange_id(ssp.getAdexchange_id());
	    UUID id = sspredis.getAdexchange_id();
	    String id_str = id.toString();
	    
	    sspredis.setAdexchange_name(ssp.getAdexchange_name());
	    String name_str =  sspredis.getAdexchange_name();
	    
	    sspredis.setEmail(ssp.getEmail());
	    String email_str = sspredis.getEmail();
	    
	    sspredis.setVersion(ssp.getVersion());
	    String version_str = sspredis.getVersion();
	    
	    sspredis.setRtb_mode(ssp.getRtb_mode());
	    int rtb_mode = sspredis.getRtb_mode();
	    String rtb_mode_str = Integer.toString(rtb_mode);
	    
	    sspredis.setCreated_at(ssp.getCreated_at());
		LocalDateTime now = sspredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = now.toString();

		arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);
		
		sspredis.setCreated_by(ssp.getCreated_by());
		UUID created_by = sspredis.getCreated_by();
		String created_by_str = created_by.toString();
		
		sspredis.setUpdated_at(ssp.getUpdated_at());
		LocalDateTime now1 = sspredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = now1.toString();

		arr1[1] = now1.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr1);

		String key ="Ssp_"+ssp.getAdexchange_id();
		Map<String,String> map = new HashMap<>();
		map.put("adexchange_id", id_str);
		map.put("name", name_str);
		map.put("email", email_str);
		map.put("version",version_str);
		map.put("rtb_mode", rtb_mode_str);
		map.put("created_at",created_at_str);
		map.put("created_by",created_by_str);
		map.put("updated_at",updated_at_str);
		jedis.hmset(key, map);

	    api.setData(ssp);
	    api.setMessage("Ssp Created Successfully");
	    api.setMsgCode("SSP CREATED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse updatessp(SspUpdateDTO update, UUID adexchange_id) {
		APIResponse api = new APIResponse();
		
		Ssp ssp = repo.findById(adexchange_id).orElse(null);
		if(ssp==null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Ssp Id Not Found In Database");
			api.setError(error);
			api.setMessage("Ssp Id Not Found");
			api.setMsgCode("SSP ID NOT FOUND");
			return api;
		}
		else {
			ssp.setAdexchange_name(update.getAdexchange_name());
			ssp.setEmail(update.getEmail());
			ssp.setRtb_mode(update.getRtb_mode());
			ssp.setStatus(1);
			ssp.setVersion(update.getVersion());
			ssp.setUpdated_by(update.getUpdated_by());
			ssp.setUpdated_at(LocalDateTime.now());
			repo.save(ssp);
			
		    SspRedis sspredis = new SspRedis();
		    
		    sspredis.setAdexchange_id(ssp.getAdexchange_id());
		    UUID id = sspredis.getAdexchange_id();
		    String id_str = id.toString();
		    
		    sspredis.setAdexchange_name(ssp.getAdexchange_name());
		    String name_str =  sspredis.getAdexchange_name();
		    
		    sspredis.setEmail(ssp.getEmail());
		    String email_str = sspredis.getEmail();
		    
		    sspredis.setVersion(ssp.getVersion());
		    String version_str = sspredis.getVersion();
		    
		    sspredis.setRtb_mode(ssp.getRtb_mode());
		    int rtb_mode = sspredis.getRtb_mode();
		    String rtb_mode_str = Integer.toString(rtb_mode);
		    
		    sspredis.setCreated_at(ssp.getCreated_at());
			LocalDateTime now = sspredis.getCreated_at();

			String[] arr = new String[2];

			arr[0] = now.toString();

			arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);
			
			sspredis.setCreated_by(ssp.getCreated_by());
			UUID created_by = sspredis.getCreated_by();
			String created_by_str = created_by.toString();
			
			sspredis.setUpdated_at(ssp.getUpdated_at());
			LocalDateTime now1 = sspredis.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = now1.toString();

			arr1[1] = now1.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr1);
			
			sspredis.setUpdated_by(ssp.getUpdated_by());
			UUID updated_by = sspredis.getUpdated_by();
			String updated_by_str = updated_by.toString();
			

			String key ="Ssp_"+ssp.getAdexchange_id();
			Map<String,String> map = new HashMap<>();
			map.put("adexchange_id", id_str);
			map.put("name", name_str);
			map.put("email", email_str);
			map.put("version",version_str);
			map.put("rtb_mode", rtb_mode_str);
			map.put("created_at",created_at_str);
			map.put("created_by",created_by_str);
			map.put("updated_at",updated_at_str);
			map.put("updated_by",updated_by_str);
			jedis.hmset(key, map);

			
			api.setData(update);
			api.setMessage("Ssp Updated Successfully");
			api.setMsgCode("SSP UPDATED SUCCESSFULLY");
			return api;
		}
		
	}

	@Override
	public APIResponse getbyid(UUID adexchange_id) {
		APIResponse api = new APIResponse();
		
        Ssp ssp = repo.findById(adexchange_id).orElse(null);
        if(ssp==null) {
        	ErrorObj error = new ErrorObj();
        	error.setCode("Ssp Id Not Found In Database");
        	api.setError(error);
        	api.setMessage("Ssp Id Not Found");
        	api.setMsgCode("SSP ID NOT FOUND");
        	return api;
        }
        SspResponseDTO response = MapToDTO(ssp);
        api.setData(response);
        api.setMessage("Ssp Details Get Successfully");
        api.setMsgCode("SSP DETAILS GET SUCCESSFULLY");
        return api;
		
	}

	@Override
	public APIResponse blockssp(UUID adexchange_id) {
		APIResponse api = new APIResponse();
		Ssp ssp = repo.findById(adexchange_id).orElse(null);
		if(ssp==null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Ssp Id Not Found In Database");
			api.setError(error);
			api.setMessage("Ssp Id Not Found");
			api.setMsgCode("SSP ID NOT FOUND");
			return api;
		}
		else {
			ssp.setStatus(0);
			repo.save(ssp);
			
			SspRedis sspredis = new SspRedis();
			
			sspredis.setStatus(ssp.getStatus());
			int status = sspredis.getStatus();
			String status_str = Integer.toString(status);
			
			String key ="Ssp_"+ssp.getAdexchange_id();
			Map<String,String> map = new HashMap<>();
			map.put("status",status_str);
			jedis.hmset(key, map);
			
			api.setData(ssp);
			api.setMessage("Ssp Blocked Successfully");
			api.setMsgCode("SSP BLOCKED SUCCESSFULLY");
			return api;
		}
	}

	@Override
	public APIResponse unblockssp(UUID adexchange_id) {
		APIResponse api =new APIResponse();
		Ssp ssp = repo.findById(adexchange_id).orElse(null);
		if(ssp==null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Ssp Id Not Found In Database");
			api.setError(error);
			api.setMessage("Ssp Id Not Found");
			api.setMsgCode("SSP ID NOT FOUND");
			return api;
		}
		else {
			ssp.setStatus(1);
			repo.save(ssp);
			
			SspRedis sspredis = new SspRedis();
			
			sspredis.setStatus(ssp.getStatus());
			int status = sspredis.getStatus();
			String status_str = Integer.toString(status);
			
			String key ="Ssp_"+ssp.getAdexchange_id();
			Map<String,String> map = new HashMap<>();
			map.put("status",status_str);
			jedis.hmset(key, map);

			api.setData(ssp);
			api.setMessage("Ssp UnBlocked Successfully");
			api.setMsgCode("SSP UNBLOCKED SUCCESSFULLY");
			return api;
		}
		
	}

	@Override
	public APIResponse getall() {
		APIResponse api = new APIResponse();
		List<Ssp> ssp = repo.findAll();
		List<SspResponseDTO> response = ssp.stream().map(use->MapToDTO(use)).collect(Collectors.toList());
		api.setData(response);
		api.setMessage("List Of Ssp Get Successfully");
		api.setMsgCode("LIST OF SSP GET SUCCESSFULLY");
		return api;
	}
	
	private SspResponseDTO MapToDTO(Ssp ssp) {
		SspResponseDTO response = new SspResponseDTO();
		response.setAdexchange_id(ssp.getAdexchange_id());
		response.setAdexchange_name(ssp.getAdexchange_name());
		response.setEmail(ssp.getEmail());
		response.setRtb_mode(ssp.getRtb_mode());	
		if(ssp.getStatus()==1) {
		response.setStatus("Active");
		}
		else if(ssp.getStatus()==0) {
		response.setStatus("InActive");
		}
		response.setVersion(ssp.getVersion());
		
		List<Configurations> allObj = configRepo.findAll();
		Configurations config = allObj.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(config.getConfigValue());
		String arr = newYorkDateFormatter.format(ZonedDateTime.of(ssp.getCreated_at(), ZoneId.of("UTC-4")));
        response.setCreated_at(arr);
        response.setCreated_by(ssp.getCreated_by());
		
		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(ssp.getUpdated_at(), ZoneId.of("UTC-4")));
        response.setUpdated_at(arr1);
        response.setUpdated_by(ssp.getUpdated_by());
		
        response.setPing_url("https://djax.adserver.com/rtb/request?ex="+ssp.getAdexchange_id());
        
        if(ssp.getDeleted_at()!=null) {
    		String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(ssp.getDeleted_at(), ZoneId.of("UTC-4")));
            response.setCreated_at(arr2);
        }
        
        response.setDeleted_by(ssp.getDeleted_by());
        response.setIs_deleted(ssp.getIs_deleted());
        return response;
	}

	@Override
	public APIResponse deletessp(SspDeleteDTO delete) {
		APIResponse api = new APIResponse();
		
		Ssp ssp = repo.findById(delete.getAdexchange_id()).orElse(null);
		ssp.setIs_deleted(1);
		ssp.setDeleted_at(LocalDateTime.now());
		ssp.setDeleted_by(delete.getDeleted_by());
		
		repo.save(ssp);
		
		SspRedis sspredis = new SspRedis();
		
		sspredis.setIs_deleted(ssp.getIs_deleted());
		int is_deleted = sspredis.getIs_deleted();
		String is_deleted_str = Integer.toString(is_deleted);
		
		sspredis.setDeleted_by(ssp.getDeleted_by());
		UUID deleted_by = sspredis.getDeleted_by();
		String deleted_by_str = deleted_by.toString();
		
		sspredis.setDeleted_at(ssp.getDeleted_at());
		LocalDateTime now1 = sspredis.getDeleted_at();

		String[] arr1 = new String[2];

		arr1[0] = now1.toString();

		arr1[1] = now1.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String deleted_at_str = Arrays.toString(arr1);
		
		
		String key ="Ssp_"+ssp.getAdexchange_id();
		Map<String,String> map = new HashMap<>();
        map.put("is_deleted",is_deleted_str);
        map.put("deleted_at",deleted_at_str);
        map.put("deleted_by",deleted_by_str);
        
        jedis.hmset(key, map);
        
        api.setData(ssp);
        api.setMessage("Ssp Deleted Successfully");
        api.setMsgCode("SSP DELETED SUCCESSFULLY");

		return api;
	}

}
