package com.example.demo.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.SettingResponseDTO;
import com.example.demo.dto.SettingsCreateDTO;
import com.example.demo.entity.Currency;
import com.example.demo.entity.Setting;
import com.example.demo.repository.CurrencyRepo;
import com.example.demo.repository.SettingsRepo;
import com.example.demo.service.SettingsService;

import redis.clients.jedis.Jedis;

@Service
public class SettingsServiceImpl implements SettingsService {

	@Autowired
	private SettingsRepo repo;

	@Autowired
	private CurrencyRepo currencyrepo;

	@Autowired
	private Jedis jedis;

	@Override
	public APIResponse createsettings(SettingsCreateDTO create, UUID user_id) {

		APIResponse api = new APIResponse();

		Setting set = repo.findbyuser(user_id);
		if (set == null) {
			Setting setting = new Setting();
			setting.setName(create.getName());
			setting.setDomain(create.getDomain());
			setting.setUser_id(user_id);
			setting.setAccount_currency(create.getAccount_currency());
			setting.setHome_currency(create.getHome_currency());
			repo.save(setting);

			String key = "Settings_" + setting.getSetting_id();
			Map<String, String> map = new HashMap<>();

			map.put("setting_id", setting.getSetting_id().toString());
			map.put("name", setting.getName());
			map.put("domain", setting.getDomain());
			Currency acccur = currencyrepo.findById(setting.getAccount_currency()).orElse(null);
			if (acccur != null) {
				map.put("account_currency", acccur.getCode());
			}
			Currency homecur = currencyrepo.findById(setting.getHome_currency()).orElse(null);
			if (homecur != null) {
				map.put("home_currency", homecur.getCode());
			}
			map.put("user_id", setting.getUser_id().toString());
			jedis.hmset(key, map);

			api.setData(setting);
			api.setMessage("Settings_created_successfully");
			api.setMsgCode("SETTING CREATED SUCCESSFULLY");
		} else {
			Setting setting = repo.findbyuser(user_id);
			setting.setName(create.getName());
			setting.setDomain(create.getDomain());
			setting.setUser_id(user_id);
			setting.setAccount_currency(create.getAccount_currency());
			setting.setHome_currency(create.getHome_currency());
			repo.save(setting);

			String key = "Settings_" + setting.getSetting_id();
			Map<String, String> map = new HashMap<>();

			map.put("setting_id", setting.getSetting_id().toString());
			map.put("name", setting.getName());
			map.put("domain", setting.getDomain());
			Currency acccur = currencyrepo.findById(setting.getAccount_currency()).orElse(null);
			if (acccur != null) {
				map.put("account_currency", acccur.getCode());
			}
			Currency homecur = currencyrepo.findById(setting.getHome_currency()).orElse(null);
			if (homecur != null) {
				map.put("home_currency", homecur.getCode());
			}
			map.put("user_id", setting.getUser_id().toString());
			jedis.hmset(key, map);

			api.setData(setting);
			api.setMessage("Settings_updated_successfully");
			api.setMsgCode("SETTING UPDATED SUCCESSFULLY");
		}
		return api;
	}

	@Override
	public APIResponse getbyId(UUID settings_id) {
		APIResponse api = new APIResponse();
		Setting set = repo.findById(settings_id).orElse(null);
		SettingResponseDTO response = MapToDto(set);

		api.setData(response);
		api.setMessage("Setting_Get_Successfully");
		api.setMsgCode("SETTINGS_GET_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getall() {
		APIResponse api = new APIResponse();
		List<Setting> set = repo.findAll();
		List<SettingResponseDTO> response = set.stream().map(sett -> MapToDto(sett)).collect(Collectors.toList());

		api.setData(response);
		api.setMessage("Settings_List_Successfully");
		api.setMsgCode("SETTINGS_LIST_SUCCESSFULLY");
		return api;
	}

	private SettingResponseDTO MapToDto(Setting set) {
		SettingResponseDTO response = new SettingResponseDTO();

		response.setUser_id(set.getUser_id());
		response.setName(set.getName());
		response.setSetting_id(set.getSetting_id());
		response.setAccount_currency(set.getAccount_currency());
		response.setHome_currency(set.getHome_currency());
		response.setDomain(set.getDomain());

		return response;
	}
}
