package com.example.demo.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.dto.RolesResponseDTO;
import com.example.demo.entity.Roles;
import com.example.demo.repository.RolesRepository;
import com.example.demo.service.RoleService;

@Service
public class RolesServiceIMPL implements RoleService {

	@Autowired
	RolesRepository repo;

	public Roles saveRole(Roles roles) {

		return repo.save(roles);
	}

	@Override
	public List<RolesResponseDTO> getRoles(int level) {
		List<RolesResponseDTO> responseList = null;
		if (level != 1) {
			List<Roles> roles = repo.findByAccessLevel(level);
			responseList = roles.stream().map(role -> mapToDTO(role)).collect(Collectors.toList());
		} else if (level == 1) {
			List<Roles> roles = repo.findAll();
			responseList = roles.stream().map(role -> mapToDTO(role)).collect(Collectors.toList());
		}
		return responseList;
	}

	public RolesResponseDTO mapToDTO(Roles role) {
		RolesResponseDTO dto = new RolesResponseDTO();
		dto.setAccessLevel(role.getAccessLevel());
		dto.setRolename(role.getRolename());
		dto.setRoletype(role.getRoletype());
		dto.setRoleid(role.getRoleid());
		if (dto.getAccessLevel() == 1) {
			dto.setLevel("Master Admin");
		} else if (dto.getAccessLevel() == 2) {
			dto.setLevel("Publisher");
		} else if (dto.getAccessLevel() == 3) {
			dto.setLevel("Advertiser");
		}
		return dto;
	}

}
