package com.example.demo.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.ReportResponseDTO;
import com.example.demo.entity.Advertriser;
import com.example.demo.entity.Campign;
import com.example.demo.repository.AdvertriserRepo;
import com.example.demo.repository.CampignRepository;
import com.example.demo.service.ReportingService;

@Service
public class ReportingServiceImpl implements ReportingService{

	@Autowired
	private AdvertriserRepo advertrepo;
	
	@Autowired
	private CampignRepository campaignrepo;
	
	@Override
	public APIResponse generatereport() {
		APIResponse api = new APIResponse();
		List<Campign> camp = campaignrepo.findalladvertiser();
		List<ReportResponseDTO> response = camp.stream().map(us->MapToDTO(us)).collect(Collectors.toList());
		api.setData(response);
		api.setMessage("Report Generete Successfully");
		api.setMsgCode("REPORT GENERATE SUCCESSFULLY");
		return api;
	}

	private ReportResponseDTO MapToDTO(Campign camp) {
		ReportResponseDTO response = new ReportResponseDTO();
		response.setCampaign_id(camp.getCampign_id());
		response.setCampaign_name(camp.getCampign_name());
		Advertriser add = advertrepo.findById(camp.getAdvertiser_id()).orElse(null);
		response.setAdvertiser_name(add.getAdvertiser_name());
		response.setAdvertiser_id(camp.getAdvertiser_id());
		response.setCreative_type("Banner");
		response.setAdmin_revenue(70);
		response.setBidrate(50);
		response.setClickerror(25);
		response.setClkcount(50);
		response.setCpm(300.00);
		response.setCtr(100);
		response.setFillrate(70);
		response.setGrossrevenue(40);
		response.setImpcount(3250);
		response.setImprerror(2000);
		response.setPubrevenue(50);
		response.setPubrevenueusdavg(20);
		response.setReqcount(10);
		response.setRescount(40);
		response.setWinerror(0);
		response.setWoncount(30);
		response.setWonprice(30);
		return response;
	}
	
}
