package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.ReportCreateDTO;
import com.example.demo.dto.ReportDeleteDTO;
import com.example.demo.entity.Report;
import com.example.demo.repository.ReportRepository;
import com.example.demo.service.ReportService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@Service
public class ReportServiceImpl implements ReportService{

	@Autowired
	private ReportRepository repo;
	
	@Override
	public APIResponse create(ReportCreateDTO create) throws JsonProcessingException {
		APIResponse api = new APIResponse();
		
		Report rep = new Report();
		
		rep.setPeriod(create.getPeriod());
		rep.setName(create.getName());
		ObjectMapper mapper = new ObjectMapper();

		rep.setStart_date(create.getDate().getStartDate());
		rep.setEnd_date(create.getDate().getEndDate());
		
        String srcstring1 = mapper.writeValueAsString(create.getGroup_by());
        rep.setGroup_by(srcstring1);
        
        String srcstring2 = mapper.writeValueAsString(create.getValues());
        rep.setFilter(srcstring2);
        
        rep.setTimezone_id(create.getTimezone_id());
        
        repo.save(rep);
        
        api.setData(rep);
        api.setMessage("Report Saved Successfully");
        api.setMsgCode("REPORT SAVED SUCCESSFULLY");
        
		return api;
	}

	@Override
	public APIResponse list() {
		APIResponse api = new APIResponse();
		
		List<Report> rep = repo.findAll();
		
		api.setData(rep);
		api.setMessage("List Of Report Get Successfully");
		api.setMsgCode("LIST OF REPORT GET SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getbyid(UUID report_id) {
		APIResponse api = new APIResponse();
		
		Report rep = repo.findById(report_id).orElse(null);
		
		api.setData(rep);
		api.setMessage("Report Details Get Successfully");
		api.setMsgCode("REPORT DETAILS GET SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse deletereport(ReportDeleteDTO delete) {
		APIResponse api = new APIResponse();
		
		Report rep = repo.findById(delete.getReport_id()).orElse(null);
		rep.setIs_deleted(1);
		rep.setDeleted_at(LocalDateTime.now());
		rep.setDeleted_by(delete.getDeleted_by());
		
		repo.save(rep);
		
		api.setData(rep);
		api.setMessage("Report Deleted Successfully");
		api.setMsgCode("REPORT DELETED SUCCESSFULLY");
		return api;
	}
	
	

}
