package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.common.FilterResponse;
import com.example.demo.common.PageDetails;
import com.example.demo.common.PageResponse;
import com.example.demo.dto.PublisherDeleteDTO;
import com.example.demo.dto.PublisherFilterRequest;
import com.example.demo.dto.PublisherLoginCreateDTO;
import com.example.demo.dto.PublisherResponseDTO;
import com.example.demo.dto.PublisherUpdateDTO;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.ManageUser;
import com.example.demo.entity.Publisher;
import com.example.demo.entity.PublisherFilterEntity;
import com.example.demo.entity.Roles;
import com.example.demo.redisentity.PublisherRedis;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.ManageUserRepository;
import com.example.demo.repository.PublisherRepo;
import com.example.demo.repository.RolesRepository;
import com.example.demo.service.PublisherService;

import redis.clients.jedis.Jedis;

@Service
public class PublisherServiceImpl implements PublisherService {

	@Autowired
	private PublisherRepo publisherRepo;

	@Autowired
	private ManageUserRepository repo;

	@Autowired
	private RolesRepository rolerepo;

	@Autowired
	PasswordEncoder password;

	@Autowired
	private ConfigurationRepo configrepo;

	@Autowired
	private Jedis jedis;

	@Override
	public APIResponse create(PublisherLoginCreateDTO create) {
		APIResponse api = new APIResponse();
		if (!create.getPwd_hash().equals(create.getConfirmPassword())) {
			ErrorObj error = new ErrorObj();
			error.setCode("Password are not same");
			api.setError(error);
			api.setMessage("Password and confirmpassword are not same");
			api.setMsgCode("PASSWORD AND CONFIRMPASSWORD ARE NOT SAME");
			return api;
		}
		Publisher ad = publisherRepo.findbyemail(create.getEmail());
		ManageUser use = repo.findbyemail(create.getEmail());
		if (ad != null || use!= null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Email already exists");
			api.setError(error);
			api.setMessage("Email Already Exists");
			api.setMsgCode("EMAIL ALREADY EXISTS");
			return api;
		}

		Publisher pub = new Publisher();
		pub.setName(create.getName());
		pub.setEmail(create.getEmail());
		pub.setPublisher_share(create.getPublisher_share());
		pub.setWebsite(create.getWebsite());
		pub.setAdblocker(create.getAdblocker());
		pub.setCreated_at(LocalDateTime.now());
		pub.setUpdated_at(LocalDateTime.now());
		pub.setCreated_by(create.getCreated_by());
		pub.setUpdated_at(LocalDateTime.now());
		pub.setStatus(1);
		publisherRepo.save(pub);

		PublisherRedis pubredis = new PublisherRedis();

		pubredis.setId(pub.getId());
		UUID id = pubredis.getId();
		String id_str = id.toString();

		pubredis.setName(pub.getName());
		String name_str = pubredis.getName();

		pubredis.setEmail(pub.getEmail());
		String email_str = pubredis.getEmail();

		pubredis.setWebsite(pub.getWebsite());
		String website_str = pubredis.getWebsite();

		String publisher_share_str=null;
		if(pub.getPublisher_share()!=0) {
		pubredis.setPublisher_share(pub.getPublisher_share());
		int publisher_share = pubredis.getPublisher_share();
		publisher_share_str = Integer.toString(publisher_share);
		}
		
		String adblocker_str = null;
		if (pub.getAdblocker() != 0) {
			pubredis.setAdblocker(pub.getAdblocker());
			int adblocker = pubredis.getAdblocker();
			adblocker_str = Integer.toString(adblocker);
		}

		pubredis.setStatus(pub.getStatus());
		int status = pubredis.getStatus();
		String status_str = Integer.toString(status);

		pubredis.setCreated_at(pub.getCreated_at());
		LocalDateTime created_at = pubredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = created_at.toString();

		arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		pubredis.setCreated_by(pub.getCreated_by());
		UUID created_by = pubredis.getCreated_by();
		String created_by_str = created_by.toString();

		pubredis.setUpdated_at(pub.getUpdated_at());
		LocalDateTime updated_at = pubredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = updated_at.toString();

		arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr);

		String key = "Publisher_" + pub.getId();
		Map<String, String> map = new HashMap<>();
		map.put("publisher_id", id_str);
		map.put("name", name_str);
		map.put("email", email_str);
		map.put("website", website_str);
		if(publisher_share_str!=null) {
		map.put("publisher_share", publisher_share_str);
		}
		if (adblocker_str != null) {
			map.put("adblocker", adblocker_str);
		}
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);

		jedis.hmset(key, map);

		ManageUser user = new ManageUser();
		user.setId(pub.getId());
		user.setRoleid(create.getAccounttype());
		user.setName(create.getName());
		user.setEmail(create.getEmail());
		user.setPassword(password.encode(create.getPwd_hash()));
		user.setCreated_at(LocalDateTime.now());
		user.setCreated_by(create.getCreated_by());
		user.setUpdated_at(LocalDateTime.now());
		user.setStatus(1);

		repo.save(user);
		api.setData(pub);
		api.setMessage("Publisher created successfully");
		api.setMsgCode("PUBLISHER CREATED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse update(PublisherUpdateDTO dto, UUID publisher_id) {
		APIResponse api = new APIResponse();
		if (!dto.getPwd_hash().equals(dto.getConfirmPassword())) {
			ErrorObj error = new ErrorObj();
			error.setCode("Password are not same");
			api.setError(error);
			api.setMessage("Password and confirmpassword are not same");
			api.setMsgCode("PASSWORD AND CONFIRMPASSWORD ARE NOT SAME");
			return api;
		}
		Publisher existingpub = publisherRepo.findById(publisher_id).orElse(null);
		if (existingpub == null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Publisher and user is not in db");
			api.setError(error);
			api.setMessage("Publisher and user is not Present");
			api.setMsgCode("Publisher and user is not Present");
			return api;

		}
		existingpub.setName(dto.getName());
		existingpub.setEmail(dto.getEmail());
		existingpub.setWebsite(dto.getWebsite());
		existingpub.setPublisher_share(dto.getPublisher_share());
		existingpub.setAdblocker(dto.getAdblocker());
		existingpub.setStatus(1);
		existingpub.setUpdated_at(LocalDateTime.now());
		existingpub.setUpdated_by(dto.getUpdated_by());
		publisherRepo.save(existingpub);

		PublisherRedis pubredis = new PublisherRedis();

		pubredis.setId(existingpub.getId());
		UUID id = pubredis.getId();
		String id_str = id.toString();

		pubredis.setName(existingpub.getName());
		String name_str = pubredis.getName();

		pubredis.setEmail(existingpub.getEmail());
		String email_str = pubredis.getEmail();

		pubredis.setWebsite(existingpub.getWebsite());
		String website_str = pubredis.getWebsite();

		String publisher_share_str=null;
		if(existingpub.getPublisher_share()!=0) {
		pubredis.setPublisher_share(existingpub.getPublisher_share());
		int publisher_share = pubredis.getPublisher_share();
		publisher_share_str = Integer.toString(publisher_share);
		}

		String adblocker_str = null;
		if (existingpub.getAdblocker() != 0) {
			pubredis.setAdblocker(existingpub.getAdblocker());
			int adblocker = pubredis.getAdblocker();
			adblocker_str = Integer.toString(adblocker);
		}

		pubredis.setStatus(existingpub.getStatus());
		int status = pubredis.getStatus();
		String status_str = Integer.toString(status);

		pubredis.setCreated_at(existingpub.getCreated_at());
		LocalDateTime created_at = pubredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = created_at.toString();

		arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		pubredis.setCreated_by(existingpub.getCreated_by());
		UUID created_by = pubredis.getCreated_by();
		String created_by_str = created_by.toString();

		pubredis.setUpdated_at(existingpub.getUpdated_at());
		LocalDateTime updated_at = pubredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = updated_at.toString();

		arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr);
		

		pubredis.setUpdated_by(existingpub.getUpdated_by());
		UUID updated_by = pubredis.getUpdated_by();
		String updated_by_str = updated_by.toString();

		String key = "Publisher_" + existingpub.getId();
		Map<String, String> map = new HashMap<>();
		map.put("publisher_id", id_str);
		map.put("name", name_str);
		map.put("email", email_str);
		map.put("website", website_str);
		if(publisher_share_str!=null) {
		map.put("publisher_share", publisher_share_str);
		}
		if (adblocker_str != null) {
			map.put("adblocker", adblocker_str);
		}
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);
		map.put("updated_by", updated_by_str);

		jedis.hmset(key, map);

		ManageUser user = repo.findById(publisher_id).orElse(null);
		user.setName(dto.getName());
		user.setRoleid(dto.getAccounttype());
		user.setPassword(password.encode(dto.getPwd_hash()));
		user.setUpdated_at(LocalDateTime.now());
		user.setUpdated_by(dto.getUpdated_by());

		api.setData(existingpub);
		api.setMessage("Publisher_Updated_Successfully");
		api.setMsgCode("PUBlISHER_UPDATED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse block(UUID publisher_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Publisher pub = publisherRepo.findById(publisher_id).orElse(null);
		if (pub == null) {
			err.setCode("Given Publisher Is Not Present In Database");
			api.setError(err);
			api.setMessage("Publisher Is Not Present");
			api.setMsgCode("PUBLISHER IS NOT PRESENT");
			return api;
		}
		if (pub.getIs_deleted() == 1) {
			err.setCode("Cannot Block The Deleted Publisher");
			api.setError(err);
			api.setMessage("Deleted Publisher Cannot Be Blocked");
			api.setMsgCode("DELETED PUBLISHER CANNOT BE BLOCKED");
			return api;
		}
		if (pub.getStatus() == 0) {
			err.setCode("Publisher Is Already InActive");
			api.setError(err);
			api.setMessage("Publisher Is Already Blocked");
			api.setMsgCode("PUBLISHER IS ALREADY BLOCKED");
			return api;
		}
		pub.setStatus(0);
		publisherRepo.save(pub);

		PublisherRedis pubredis = new PublisherRedis();

		pubredis.setStatus(pub.getStatus());
		int status = pubredis.getStatus();
		String status_str = Integer.toString(status);

		String key = "Publisher_" + pub.getId();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);
		jedis.hmset(key, map);

		ManageUser user = repo.findById(publisher_id).orElse(null);
		user.setStatus(0);
		repo.save(user);

		api.setMessage("Publisher_Blocked_Successfully");
		api.setMsgCode("PUBLISHER_BLOCKED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse unblock(UUID publisher_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Publisher pub = publisherRepo.findById(publisher_id).orElse(null);
		if (pub == null) {
			err.setCode("Given Publisher Is Not Present In Database");
			api.setError(err);
			api.setMessage("Publisher Is Not Present");
			api.setMsgCode("PUBLISHER IS NOT PRESENT");
			return api;
		}
		if (pub.getIs_deleted() == 1) {
			err.setCode("Cannot Unblock The Deleted Publisher");
			api.setError(err);
			api.setMessage("Deleted Publisher Cannot Be UnBlocked");
			api.setMsgCode("DELETED PUBLISHER CANNOT BE UNBLOCKED");
			return api;
		}
		if (pub.getStatus() == 1) {
			err.setCode("Publisher Is Already Active");
			api.setError(err);
			api.setMessage("Publisher Is Already UnBlocked");
			api.setMsgCode("PUBLISHER IS ALREADY UNBLOCKED");
			return api;
		}
		pub.setStatus(1);
		publisherRepo.save(pub);

		PublisherRedis pubredis = new PublisherRedis();

		pubredis.setStatus(pub.getStatus());
		int status = pubredis.getStatus();
		String status_str = Integer.toString(status);

		String key = "Publisher_" + pub.getId();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);
		jedis.hmset(key, map);

		ManageUser user = repo.findById(publisher_id).orElse(null);
		user.setStatus(1);
		repo.save(user);

		api.setMessage("Publisher_UnBlocked_Successfully");
		api.setMsgCode("PUBLISHER_UNBLOCKED_SUCCESSFULLY");

		return api;
	}

	@Override
	public APIResponse delete(PublisherDeleteDTO dto) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Publisher pub = publisherRepo.findById(dto.getPublisher_id()).orElse(null);
		if (pub == null) {
			err.setCode("Given Publisher Is Not Present In Database");
			api.setError(err);
			api.setMessage("Publisher Is Not Present");
			api.setMsgCode("PUBLISHER IS NOT PRESENT");
			return api;
		}
		if (pub.getIs_deleted() == 1) {
			err.setCode("Cannot Delete The Deleted Publisher");
			api.setError(err);
			api.setMessage("Publisher Is Already Deleted");
			api.setMsgCode("PUBLISHER IS ALREADY DELETED");
			return api;
		}
		pub.setIs_deleted(1);
		pub.setDeleted_at(LocalDateTime.now());
		pub.setDeleted_by(dto.getDeleted_by());
		publisherRepo.save(pub);

		PublisherRedis pubredis = new PublisherRedis();

		pubredis.setIs_deleted(pub.getIs_deleted());
		int is_deleted = pubredis.getIs_deleted();
		String is_deleted_str = Integer.toString(is_deleted);

		pubredis.setDeleted_at(pub.getDeleted_at());
		LocalDateTime deleted_at = pubredis.getDeleted_at();

		String[] arr = new String[2];

		arr[0] = deleted_at.toString();

		arr[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String deleted_at_str = Arrays.toString(arr);

		pubredis.setDeleted_by(pub.getDeleted_by());
		UUID deleted_by = pubredis.getDeleted_by();
		String deleted_by_str = deleted_by.toString();

		String key = "Publisher_" + pub.getId();
		Map<String, String> map = new HashMap<>();
		map.put("is_deleted", is_deleted_str);
		map.put("deleted_at", deleted_at_str);
		map.put("deleted_by", deleted_by_str);

		jedis.hmset(key, map);

		ManageUser user = repo.findById(dto.getPublisher_id()).orElse(null);
		user.setIs_deleted(1);
		user.setDeleted_at(LocalDateTime.now());
		user.setDeleted_by(dto.getDeleted_by());
		repo.save(user);

		api.setMessage("Publisher_Deleted_Successfully");
		api.setMsgCode("PUBLISHER_DELETED_SUCCESSFULLY");

		return api;
	}

	@Override
	public FilterResponse getall(PublisherFilterRequest filter, UUID user_id) {
		FilterResponse api = new FilterResponse();

		String field = null, order = null;
		if (filter.getSort() != null && filter.getSort().size() == 1) {
			for (Map.Entry m : filter.getSort().entrySet()) {
				field = (String) m.getKey();
				order = (String) m.getValue();
			}
		} else {

		}

		PageDetails pageing = filter.getPages();
		Pageable pageable = null;

		if (filter.getFilter() == null && filter.getPages() == null) {

			List<Publisher> publisher = null;
			List<PublisherResponseDTO> dto = null;
			ManageUser user = repo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				publisher = publisherRepo.findAll();
			} else if (role.getRoletype().equals("PUBLISHER")) {
				publisher = publisherRepo.findbypublisher(user_id);
			}
			dto = publisher.stream().map(dt1 -> MapToDto2(dt1)).collect(Collectors.toList());
			api.setData(dto);
			api.setMessage("List_Of_Publisher");
			api.setMsgCode("LIST_OF_PUBLISHER");
			return api;
		}

		if (filter.getPages() == null) {
			PageDetails pageing2 = new PageDetails();

			pageable = null;

			List<Publisher> publisher = null;
			List<PublisherResponseDTO> dto = null;
			int ResponseCount;
			ManageUser user = repo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				publisher = publisherRepo.findAll();
			} else if (role.getRoletype().equals("PUBLISHER")) {
				publisher = publisherRepo.findbypublisher(user_id);
			}
			dto = publisher.stream().map(dt1 -> MapToDto2(dt1)).collect(Collectors.toList());
			PublisherFilterEntity publisherFilter = filter.getFilter();
			List<UUID> publisherIdList = publisher.stream().map(camp -> camp.getId()).collect(Collectors.toList());
			List<Publisher> filteredList = publisherRepo.getallDetails(publisherFilter.getName(),
					publisherFilter.getWebsite(), publisherFilter.getAdblocker(), publisherFilter.getStatus(),
					publisherFilter.getIs_deleted(), publisherIdList);
			List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getId()).collect(Collectors.toList());
			ResponseCount = publisherRepo.getResultCount(filteredIdList);
			if (ResponseCount == 0) {
				ResponseCount = 10;
			}
			if (filter.getSort() == null || filter.getSort().size() == 0) {

				pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));
			} else {
				if (field.equals("") || order.equals("")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));

				}

				else if (order.equalsIgnoreCase("asc")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field).descending());
				}
			}

			List<Publisher> campignListWithPage = publisherRepo.getFilteredListwithoutPage(filteredIdList, pageable)
					.getContent();
			dto = campignListWithPage.stream().map(CampignRes -> MapToDto2(CampignRes)).collect(Collectors.toList());

			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageSize(10);
			pageRes.setTotalCount(ResponseCount);
			api.setPage(pageRes);
			api.setData(dto);
			return api;
		}
		List<PublisherResponseDTO> CampignResList = null;

		// set 2 if filterRequest Page details not null

		int ResponseCount = 0;
		if (filter.getFilter() == null) {
			Page<Publisher> publisher = null;
			ManageUser user = repo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				publisher = publisherRepo.findAll(pageable);
			} else if (role.getRoletype().equals("PUBLISHER")) {
				publisher = publisherRepo.findbypublisher_id(user_id, pageable);
			}

			List<UUID> CampignIdList = publisher.stream().map(camUni -> camUni.getId()).collect(Collectors.toList());
			ResponseCount = publisherRepo.getResultCount(CampignIdList);
			publisher = publisherRepo.getFilteredListwithoutPage(CampignIdList, pageable);

			List<Publisher> ResContent = publisher.getContent();
			CampignResList = ResContent.stream().map(campignunitRes -> MapToDto2(campignunitRes))
					.collect(Collectors.toList());
			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageCount(pageing.getPageIndex());
			if (pageing.getPageSize() == 0) {
				pageRes.setPageSize(10);
			} else {
				pageRes.setPageSize(pageing.getPageSize());
			}
			api.setData(CampignResList);
			api.setPage(pageRes);
			api.setMessage("PublisherList_With_Filter_2");
			api.setMsgCode("PUBLISHERLIST_WITH_FILTER_2");
			return api;
		}

		if (filter.getSort() == null || filter.getSort().size() == 0) {
			if (pageing.getPageSize() == 0) {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
			} else {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by("name"));
			}
		} else {
			if (field.equals("") || order.equals("")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by("name"));
				}
			}

			else if (order.equalsIgnoreCase("asc")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by(field));
				}
			} else {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field).descending());
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by(field).descending());
				}
			}
		}

		List<Publisher> publisher = null;
		ManageUser user = repo.findById(user_id).orElse(null);
		Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
		if (role.getRoletype().equals("MASTER_ADMIN")) {
			publisher = publisherRepo.findAll();
		} else if (role.getRoletype().equals("PUBLISHER")) {
			publisher = publisherRepo.findbypublisher(user_id);
		}

		PublisherFilterEntity publisherFilter = filter.getFilter();
		List<UUID> publisherIdList = publisher.stream().map(cam -> cam.getId()).collect(Collectors.toList());
		List<Publisher> filteredList = publisherRepo.getallDetails(publisherFilter.getName(),
				publisherFilter.getWebsite(), publisherFilter.getAdblocker(), publisherFilter.getStatus(),
				publisherFilter.getIs_deleted(), publisherIdList);
		List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getId()).collect(Collectors.toList());
		ResponseCount = publisherRepo.getResultCount(filteredIdList);
		List<Publisher> campignFilteredContent = publisherRepo.getFilteredList(filteredIdList, pageable).getContent();
		CampignResList = campignFilteredContent.stream().map(campignRes -> MapToDto2(campignRes))
				.collect(Collectors.toList());

		PageResponse pageRes = new PageResponse();
		pageRes.setTotalCount(ResponseCount);
		pageRes.setPageCount(pageing.getPageIndex());
		if (pageing.getPageSize() == 0) {
			pageRes.setPageSize(10);
		} else {
			pageRes.setPageSize(pageing.getPageSize());
		}
		api.setData(CampignResList);
		api.setPage(pageRes);
		api.setMessage("Filtered List of Publisher");
		api.setMsgCode("FILTERED_LIST_OF_PUBLISHER");

		return api;
	}

	private PublisherResponseDTO MapToDto2(Publisher ad) {
		PublisherResponseDTO response = new PublisherResponseDTO();
		response.setPublisher_id(ad.getId());
		response.setName(ad.getName());
		response.setEmail(ad.getEmail());
		response.setAdblocker(ad.getAdblocker());
		List<Configurations> allconfig = configrepo.findAll();
		Configurations obj = allconfig.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(obj.getConfigValue());
		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(ad.getCreated_at(), ZoneId.of("UTC-4")));
		response.setCreated_at(arr1);
		response.setCreated_by(ad.getCreated_by());
		String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(ad.getUpdated_at(), ZoneId.of("UTC-4")));
		response.setUpdated_at(arr2);
		response.setUpdated_by(ad.getUpdated_by());
		if (ad.getStatus() == 0) {
			response.setStatus("InActive");
		} else if (ad.getStatus() == 1) {
			response.setStatus("Active");
		}
		response.setWebsite(ad.getWebsite());
		response.setPublisher_share(ad.getPublisher_share());
		if (ad.getDeleted_at() != null) {
			String arr3 = newYorkDateFormatter.format(ZonedDateTime.of(ad.getDeleted_at(), ZoneId.of("UTC-4")));
			response.setDeleted_at(arr3);
		}
		response.setIs_deleted(ad.getIs_deleted());
		response.setDeleted_by(ad.getDeleted_by());
		return response;
	}

	@Override
	public APIResponse getbyid(UUID publisher_id) {
		APIResponse api = new APIResponse();

		Publisher pub = publisherRepo.findById(publisher_id).orElse(null);
		PublisherResponseDTO response = MapToDto2(pub);
		api.setData(response);
		api.setMessage("Publisher Get Successfully");
		api.setMsgCode("PUBLISHER GET SUCCESSFULLY");
		return api;
	}

}
