package com.example.demo.service.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.ManageUserResponseDTO;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.ManageUser;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.ManageUserRepository;
import com.example.demo.service.ManageUserService;

@Service
public class ManageUserServiceImpl implements ManageUserService {

	@Autowired
	private ManageUserRepository repo;

	@Autowired
	private ConfigurationRepo configrepo;

	@Autowired
	PasswordEncoder passencoder;

	@Override
	public APIResponse getall() {
		APIResponse api = new APIResponse();

		List<ManageUser> user = repo.findAll();
		List<ManageUserResponseDTO> response = user.stream().map(use -> MapToDto(use)).collect(Collectors.toList());
		api.setData(response);
		api.setMessage("ManageUser List Get Successfully");
		api.setMsgCode("MANAGEUSER LIST GET SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getbtid(UUID user_id) {
		APIResponse api = new APIResponse();

		ManageUser user = repo.findById(user_id).orElse(null);
		ManageUserResponseDTO response = MapToDto(user);
		api.setData(response);
		api.setMessage("ManageUser Get Successfully");
		api.setMsgCode("MANAGEUSER GET SUCCESSFULLY");
		return api;
	}

	private ManageUserResponseDTO MapToDto(ManageUser user) {
		ManageUserResponseDTO response = new ManageUserResponseDTO();
		response.setEmail(user.getEmail());
		response.setUser_name(user.getName());
		response.setUser_id(user.getId());
		if (user.getStatus() == 0) {
			response.setStatus("InActive");
		} else if (user.getStatus() == 1) {
			response.setStatus("Active");
		}
		List<Configurations> allconfig = configrepo.findAll();
		Configurations obj = allconfig.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(obj.getConfigValue());
		String arr = newYorkDateFormatter.format(ZonedDateTime.of(user.getCreated_at(), ZoneId.of("UTC-4")));
		response.setCreated_at(arr);
		response.setCreated_by(user.getCreated_by());

		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(user.getUpdated_at(), ZoneId.of("UTC-4")));
		response.setUpdated_at(arr1);
		response.setUpdated_by(user.getUpdated_by());

		if (user.getDeleted_at() != null) {
			String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(user.getDeleted_at(), ZoneId.of("UTC-4")));
			response.setDeleted_at(arr2);
		}
		response.setIs_deleted(0);
		response.setDeleted_by(user.getDeleted_by());
		return response;
	}

//	@Override
//	public APIResponse updateUser(ManageUserUpdateDTO update, UUID user_id) {
//		APIResponse api = new APIResponse();
//		ManageUser user = repo.findById(user_id).orElse(null);
//		user.setPassword(passencoder.encode(update.getPwd_hash()));
//		
//		repo.save(user);
//	
//		api.setData(update);
//		api.setMessage("User Updated successfully");
//		return api;
//	}

}
