//package com.example.demo.service.impl;
//
//import java.io.File;
//import java.nio.charset.StandardCharsets;
//import java.util.HashMap;
//import java.util.Map;
//
//import javax.mail.MessagingException;
//import javax.mail.internet.MimeMessage;
//
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.core.io.FileSystemResource;
//import org.springframework.mail.SimpleMailMessage;
//import org.springframework.mail.javamail.JavaMailSender;
//import org.springframework.mail.javamail.MimeMessageHelper;
//import org.springframework.stereotype.Service;
//import org.thymeleaf.context.Context;
//import org.thymeleaf.spring5.SpringTemplateEngine;
//
//import com.example.demo.common.APIResponse;
//import com.example.demo.entity.EmailDetails;
//import com.example.demo.service.EmailService;
//
//@Service
//
//public class EmailServiceImpl implements EmailService {
//
//	@Autowired
//	private JavaMailSender javaMailSender;
//
//	@Autowired
//	private SpringTemplateEngine templateEngine;
//
//	@Value("${spring.mail.username}")
//	private String sender;
//
//	// Method 1
//	// To send a simple email
//	public APIResponse sendSimpleMail(EmailDetails details) {
//		APIResponse apiResponse = new APIResponse();
//		MimeMessage mimemessage = javaMailSender.createMimeMessage();
//		MimeMessageHelper mimeMessagehelper;
//		try {
//
//			// Creating a simple mail message
//			SimpleMailMessage mailMessage = new SimpleMailMessage();
//			mimeMessagehelper = new MimeMessageHelper(mimemessage, MimeMessageHelper.MULTIPART_MODE_MIXED_RELATED,
//					StandardCharsets.UTF_8.name());
//			Map<String, Object> model = new HashMap<String, Object>();
//			model.put("name", details.getMsgBody());
//			Context context = new Context();
//			context.setVariables(model);
//
//			String html = templateEngine.process("index", context);
//
//			// Setting up necessary details
//			mimeMessagehelper.setFrom(sender);
//			mimeMessagehelper.setTo(details.getRecipient());
//			mimeMessagehelper.setText(html, true);
//			mimeMessagehelper.setSubject(details.getSubject());
//
//			// Sending the mail
//			javaMailSender.send(mimemessage);
//			apiResponse.setStatus(200);
//			apiResponse.setMessage("Mail sent successfully");
//			return apiResponse;
//		}
//
//		// Catch block to handle the exceptions
//		catch (Exception e) {
//			apiResponse.setStatus(404);
//			apiResponse.setMessage("Mail not sent");
//			return apiResponse;
//		}
//	}
//
//	// Method 2
//	// To send an email with attachment
//	public APIResponse sendMailWithAttachment(EmailDetails details) {
//		// Creating a mime message
//		MimeMessage mimeMessage = javaMailSender.createMimeMessage();
//		MimeMessageHelper mimeMessageHelper;
//		APIResponse apiResponse = new APIResponse();
//
//		try {
//			mimeMessageHelper = new MimeMessageHelper(mimeMessage, MimeMessageHelper.MULTIPART_MODE_MIXED_RELATED,
//					StandardCharsets.UTF_8.name());
//
//			Map<String, Object> model = new HashMap<String, Object>();
//			model.put("name", details.getMsgBody());
//			Context context = new Context();
//			context.setVariables(model);
//
//			String html = templateEngine.process("index", context);
//			// Setting multipart as true for attachments to
//			// be send
//			mimeMessageHelper = new MimeMessageHelper(mimeMessage, true);
//			mimeMessageHelper.setFrom(sender);
//			mimeMessageHelper.setTo(details.getRecipient());
//			mimeMessageHelper.setText(html, true);
//			mimeMessageHelper.setSubject(details.getSubject());
//
//			// Adding the attachment
//			FileSystemResource file = new FileSystemResource(new File(details.getAttachment()));
//
//			mimeMessageHelper.addAttachment(file.getFilename(), file);
//
//			// Sending the mail
//			javaMailSender.send(mimeMessage);
//			apiResponse.setStatus(200);
//			apiResponse.setMessage("Mail sent successfully");
//			return apiResponse;
//		}
//
//		// Catch block to handle MessagingException
//		catch (MessagingException e) {
//
//			// Display message when exception occurred
//			apiResponse.setStatus(404);
//			apiResponse.setMessage("Mail not sent");
//			return apiResponse;
//		}
//	}
//
//}
