package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.config.RedisConfiguration;
import com.example.demo.entity.ADFORMAT;
import com.example.demo.entity.ADTYPE;
import com.example.demo.entity.AdunitBidder;
import com.example.demo.entity.AdunitDeal;
import com.example.demo.entity.AdunitEndpoint;
import com.example.demo.entity.Adunits;
import com.example.demo.entity.Advertriser;
import com.example.demo.entity.Bidder;
import com.example.demo.entity.CampaignAdunit;
import com.example.demo.entity.CampaignTarget;
import com.example.demo.entity.Campign;
import com.example.demo.entity.Creative;
import com.example.demo.entity.Currency;
import com.example.demo.entity.Deal;
import com.example.demo.entity.Dsp;
import com.example.demo.entity.EndPoint;
import com.example.demo.entity.Publisher;
import com.example.demo.entity.Setting;
import com.example.demo.redisentity.AdunitRedis;
import com.example.demo.redisentity.AdvertiserRedis;
import com.example.demo.redisentity.BidderRedis;
import com.example.demo.redisentity.CampaignRedis;
import com.example.demo.redisentity.CampaignTargetRedis;
import com.example.demo.redisentity.CreativeRedis;
import com.example.demo.redisentity.DealRedis;
import com.example.demo.redisentity.DspRedis;
import com.example.demo.redisentity.EndPointRedis;
import com.example.demo.redisentity.PublisherRedis;
import com.example.demo.repository.AdunitBidderRepository;
import com.example.demo.repository.AdunitDealRepository;
import com.example.demo.repository.AdunitEndpointRepository;
import com.example.demo.repository.AdunitRepository;
import com.example.demo.repository.AdvertriserRepo;
import com.example.demo.repository.BidderRepository;
import com.example.demo.repository.CampaignAdunitRepo;
import com.example.demo.repository.CampaignTargetRepo;
import com.example.demo.repository.CampignRepository;
import com.example.demo.repository.CreativeRepository;
import com.example.demo.repository.CurrencyRepo;
import com.example.demo.repository.DealRepository;
import com.example.demo.repository.DspRepository;
import com.example.demo.repository.EndpointRepository;
import com.example.demo.repository.PublisherRepo;
import com.example.demo.repository.SettingsRepo;
import com.example.demo.service.CrossTalkService;

import redis.clients.jedis.Jedis;

@Service
public class CrossTalkServiceImpl implements CrossTalkService{

	@Autowired
	private RedisConfiguration jedis;
	
	@Autowired
	private AdunitBidderRepository adunitbidrepo;
	
	@Autowired
	private AdunitDealRepository adunitdealrepo;
	
	@Autowired
	private AdunitEndpointRepository adunitendrepo;
	
	@Autowired
	private AdunitRepository adunitrepo;
	
	@Autowired
	private AdvertriserRepo advertiserrepo;
	
	@Autowired
	private BidderRepository bidderrepo;
	
	@Autowired
	private CampaignAdunitRepo campaignadurepo;
	
	@Autowired
	private CampaignTargetRepo campaigntargetrepo;
	
	@Autowired
	private CampignRepository campignrepo;
	
	@Autowired
	private CreativeRepository creativerepo;

	@Autowired
	private DealRepository dealrepo;

	@Autowired
	private DspRepository dsprepo;

	@Autowired
	private EndpointRepository endpointrepo;
	
	@Autowired
	private PublisherRepo publisherRepo;

	@Autowired
	private SettingsRepo settingrepo;
	
	@Autowired
	private CurrencyRepo currencyrepo;


	
	@Override
	public APIResponse crosstalk() {
		// TODO Auto-generated method stub
		APIResponse api = new APIResponse();
		List<AdunitBidder> adunit_bit = adunitbidderRedis();
		List<AdunitDeal> adunit_deal = adunitdealredis();
		List<AdunitEndpoint> adunit_End = adunitendpointredis();
		List<Adunits> adunit = adunitredis();
		List<Advertriser> advertiser = advertiserredis();
		List<Bidder> bidder = bidderredis();
		List<CampaignAdunit> campadu = campaignadunitredis();
		List<CampaignTarget> camptarg = campaigntargetredis();
		List<Campign> camp = campaignredis();
		List<Creative> create = creativeredis();
		List<Deal> deal = dealredis();
		List<Dsp> dsp = dspredis();
		List<EndPoint> endpoint = endpointredis();
		List<Publisher> pub = publisherredis();
		List<Setting> set = settingredis();
		api.setMessage("Redis backup successfully");
		api.setMsgCode("REDIS BACKUP SUCCESSFULLY");
		return api;
	}

	private List<Setting> settingredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Setting> bidder = settingrepo.findAll();
		for(Setting bid : bidder) {
			Setting setting = settingrepo.findById(bid.getSetting_id()).orElse(null);
			
			String key = "Settings_" + setting.getSetting_id();
			Map<String, String> map = new HashMap<>();

			map.put("setting_id", setting.getSetting_id().toString());
			map.put("name", setting.getName());
			map.put("domain", setting.getDomain());
			Currency acccur = currencyrepo.findById(setting.getAccount_currency()).orElse(null);
			if (acccur != null) {
				map.put("account_currency", acccur.getCode());
			}
			Currency homecur = currencyrepo.findById(setting.getHome_currency()).orElse(null);
			if (homecur != null) {
				map.put("home_currency", homecur.getCode());
			}
			map.put("user_id", setting.getUser_id().toString());
			jedis1.hmset(key, map);

		}
		
		return null;
	}

	private List<Publisher> publisherredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Publisher> bidder = publisherRepo.findAll();
		for(Publisher bid : bidder) {
			Publisher pub = publisherRepo.findById(bid.getId()).orElse(null);
			
			PublisherRedis pubredis = new PublisherRedis();

			pubredis.setId(pub.getId());
			UUID id = pubredis.getId();
			String id_str = id.toString();

			pubredis.setName(pub.getName());
			String name_str = pubredis.getName();

			pubredis.setEmail(pub.getEmail());
			String email_str = pubredis.getEmail();

			String website_str = null;
			if(pub.getWebsite()!=null) {
			pubredis.setWebsite(pub.getWebsite());
			website_str = pubredis.getWebsite();
			}
			String publisher_share_str=null;
			if(pub.getPublisher_share()!=0) {
			pubredis.setPublisher_share(pub.getPublisher_share());
			int publisher_share = pubredis.getPublisher_share();
			publisher_share_str = Integer.toString(publisher_share);
			}
			
			String adblocker_str = null;
			if (pub.getAdblocker() != 0) {
				pubredis.setAdblocker(pub.getAdblocker());
				int adblocker = pubredis.getAdblocker();
				adblocker_str = Integer.toString(adblocker);
			}

			pubredis.setStatus(pub.getStatus());
			int status = pubredis.getStatus();
			String status_str = Integer.toString(status);

			pubredis.setCreated_at(pub.getCreated_at());
			LocalDateTime created_at = pubredis.getCreated_at();

			String[] arr = new String[2];

			arr[0] = created_at.toString();

			arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			pubredis.setCreated_by(pub.getCreated_by());
			UUID created_by = pubredis.getCreated_by();
			String created_by_str = created_by.toString();

			pubredis.setUpdated_at(pub.getUpdated_at());
			LocalDateTime updated_at = pubredis.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = updated_at.toString();

			arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr);
			
			String updated_by_str = null;
			if(pub.getUpdated_by()!=null) {
			pubredis.setUpdated_by(pub.getUpdated_by());
			UUID updated_by = pubredis.getUpdated_by();
		    updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str=null;
			if(pub.getIs_deleted()!=0) {
			pubredis.setIs_deleted(pub.getIs_deleted());
			int is_deleted = pubredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str=null;
			if(pub.getDeleted_at()!=null) {
			pubredis.setDeleted_at(pub.getDeleted_at());
			LocalDateTime deleted_at = pubredis.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = deleted_at.toString();

			arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr);
			}
			
			String deleted_by_str=null;
			if(deleted_by_str!=null) {
			pubredis.setDeleted_by(pub.getDeleted_by());
			UUID deleted_by = pubredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}
			
			String key = "Publisher_" + pub.getId();
			Map<String, String> map = new HashMap<>();
			map.put("publisher_id", id_str);
			map.put("name", name_str);
			map.put("email", email_str);
			if(website_str!=null) {
			map.put("website", website_str);
			}
			if(publisher_share_str!=null) {
			map.put("publisher_share", publisher_share_str);
			}
			if (adblocker_str != null) {
				map.put("adblocker", adblocker_str);
			}
			map.put("status", status_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str!=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(key, map);

		}
		return null;
	}




	private List<EndPoint> endpointredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<EndPoint> bidder = endpointrepo.findAll();
		for(EndPoint bid : bidder) {
			EndPoint end = endpointrepo.findById(bid.getEndpoint_id()).orElse(null);
			
			EndPointRedis endpointredis = new EndPointRedis();

			endpointredis.setEndpoint_id(end.getEndpoint_id());
			UUID id = endpointredis.getEndpoint_id();
			String id_str = id.toString();

			endpointredis.setEndpoint_name(end.getEndpoint_name());
			String name_str = endpointredis.getEndpoint_name();

			endpointredis.setDemand_partner(end.getDemand_partner());
			UUID demand_partner = endpointredis.getDemand_partner();
			String demand_partner_str = demand_partner.toString();

			endpointredis.setBid_floor(end.getBid_floor());
			double bid_floor = endpointredis.getBid_floor();
			String bid_floor_str = Double.toString(bid_floor);

			String seller_id_str = null;
			if (end.getSeller_id() != null) {
				endpointredis.setSeller_id(end.getSeller_id());
				seller_id_str = endpointredis.getSeller_id();
			}

			String adtype_str =null;
			if(end.getAdtype()!=0) {
			endpointredis.setAdtype(end.getAdtype());
			adtype_str = Integer.toString(endpointredis.getAdtype());
			}
			
			String dsp_params_str =null;
			if(end.getDsp_params()!=null) {
			endpointredis.setDsp_params(end.getDsp_params());
			dsp_params_str = endpointredis.getDsp_params();
			}
			endpointredis.setCreated_at(end.getCreated_at());
			LocalDateTime created_at = endpointredis.getCreated_at();

			String[] arr = new String[2];

			arr[0] = created_at.toString();

			arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			endpointredis.setCreated_by(end.getCreated_by());
			UUID created_by = endpointredis.getCreated_by();
			String created_by_str = created_by.toString();

			endpointredis.setUpdated_at(end.getUpdated_at());
			LocalDateTime updated_at = endpointredis.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = updated_at.toString();

			arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr);
			
			String updated_by_str = null;
			if(end.getUpdated_by()!=null) {
			endpointredis.setUpdated_by(end.getUpdated_by());
			UUID updated_by = endpointredis.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(end.getIs_deleted()!=0) {
			endpointredis.setIs_deleted(end.getIs_deleted());
			int is_deleted = endpointredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(end.getDeleted_at()!=null) {
			endpointredis.setDeleted_at(end.getDeleted_at());
			LocalDateTime deleted_at = endpointredis.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = deleted_at.toString();

			arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr1);
			}
			
			String deleted_by_str=null;
			if(end.getDeleted_by()!=null) {
			endpointredis.setDeleted_by(end.getDeleted_by());
			UUID deleted_by = endpointredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}

			String Key = "Endpoint_" + end.getEndpoint_id();
			Map<String, String> map = new HashMap<>();
			map.put("endpoint_id", id_str);
			map.put("endpoint_name", name_str);
			map.put("demand_partner", demand_partner_str);
			if(adtype_str!=null) {
			map.put("adtype",adtype_str);
			}
			if(dsp_params_str!=null) {
			map.put("dsp_params",dsp_params_str);
			}
			map.put("bid_floor", bid_floor_str);
			map.put("seller_id", seller_id_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str!=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(Key, map);

		}
		return null;
	}




	private List<Dsp> dspredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Dsp> bidder = dsprepo.findAll();
		for(Dsp bid : bidder) {
			Dsp dsp = dsprepo.findById(bid.getAdexchange_id()).orElse(null);
			
			DspRedis dspredis = new DspRedis();

			dspredis.setAdexchange_id(dsp.getAdexchange_id());
			UUID id = dspredis.getAdexchange_id();
			String id_str = id.toString();

			dspredis.setAdexchange_name(dsp.getAdExchange_name());
			String name_str = dspredis.getAdexchange_name();

			dspredis.setEmail(dsp.getEmail());
			String email_str = dspredis.getEmail();

			dspredis.setVersion(dsp.getVersion());
			String version_str = dspredis.getVersion();

			dspredis.setBid_auction_type(dsp.getBid_auction_type());
			String bid_auction_type_str = dspredis.getBid_auction_type();
			
			dspredis.setParams(dsp.getParams());
			String params_str = dspredis.getParams();

			dspredis.setRtb_mode(dsp.getRtb_mode());
			int rtb_mode = dspredis.getRtb_mode();
			String rtb_mode_str = Integer.toString(rtb_mode);

			dspredis.setStatus(dsp.getStatus());
			int status = dspredis.getStatus();
			String status_str = Integer.toString(status);

			dspredis.setCreated_at(dsp.getCreated_at());
			LocalDateTime created_at = dsp.getCreated_at();

			String[] arr = new String[2];

			arr[0] = created_at.toString();

			arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			dspredis.setCreated_by(dsp.getCreated_by());
			UUID created_by = dspredis.getCreated_by();
			String created_by_str = created_by.toString();

			dspredis.setUpdated_at(dsp.getUpdated_at());
			LocalDateTime updated_at = dsp.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = updated_at.toString();

			arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr1);
			
			String updated_by_str = null;
			if(dsp.getUpdated_by()!=null) {
			dspredis.setUpdated_by(dsp.getUpdated_by());
			UUID updated_by = dspredis.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(dsp.getIs_deleted()!=0) {
			dspredis.setIs_deleted(dsp.getIs_deleted());
			int is_deleted = dspredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(dsp.getDeleted_at()!=null) {
			dspredis.setDeleted_at(dsp.getDeleted_at());
			LocalDateTime deleted_at = dsp.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = deleted_at.toString();

			arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr1);
			}
			
			String deleted_by_str = null;
			if(dsp.getDeleted_by()!=null) {
			dspredis.setDeleted_by(dsp.getDeleted_by());
			UUID deleted_by = dspredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}

			String key = "Dsp_" + dsp.getAdexchange_id();
			Map<String, String> map = new HashMap<>();
			map.put("adexchange_id", id_str);
			map.put("adexchange_name", name_str);
			map.put("email", email_str);
			map.put("version", version_str);
			map.put("rtb_mode", rtb_mode_str);
			map.put("bid_auction_type", bid_auction_type_str);
			map.put("params", params_str);
			map.put("status", status_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str != null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str !=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str !=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str !=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(key, map);

		}
		return null;
	}




	private List<Deal> dealredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Deal> bidder = dealrepo.findAll();
		for(Deal bid : bidder) {
			Deal deal = dealrepo.findById(bid.getDeal_id()).orElse(null);
			
			DealRedis dealredis = new DealRedis();

			dealredis.setDeal_id(deal.getDeal_id());
			UUID id = dealredis.getDeal_id();
			String id_str = id.toString();

			dealredis.setName(deal.getName());
			String name_str = dealredis.getName();

			String bid_floor_str = null;
			if (deal.getBidfloor() != null) {
				dealredis.setBid_floor(deal.getBidfloor());
				bid_floor_str = dealredis.getBid_floor();
			}
			String including_seats_str = null;
			if (deal.getIncluding_seats() != null) {
				dealredis.setIncluding_seats(deal.getIncluding_seats());
				including_seats_str = dealredis.getIncluding_seats();
			}

			String keywords_str = null;
			if (deal.getKeywords() != null) {
				dealredis.setKeyword(deal.getKeywords());
				keywords_str = dealredis.getKeyword();
			}

			dealredis.setCreated_at(deal.getCreated_at());
			LocalDateTime now = deal.getCreated_at();

			String[] arr = new String[2];

			arr[0] = now.toString();

			arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			dealredis.setCreated_by(deal.getCreated_by());
			UUID created_by = dealredis.getCreated_by();
			String created_by_str = created_by.toString();

			dealredis.setUpdated_at(deal.getUpdated_at());
			LocalDateTime now1 = deal.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = now1.toString();

			arr1[1] = now1.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr1);
			
			String updated_by_str = null;
			if(deal.getUpdated_by()!=null) {
			dealredis.setUpdated_by(deal.getUpdated_by());
			UUID updated_by = dealredis.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(deal.getIs_deleted()!=0) {
			dealredis.setIs_deleted(deal.getIs_deleted());
			int is_deleted = dealredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(deal.getDeleted_at()!=null) {
			dealredis.setDeleted_at(deal.getDeleted_at());
			LocalDateTime now12 = dealredis.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = now12.toString();

			arr2[1] = now12.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr2);
			}
			
			String deleted_by_str = null;
			if(deal.getDeleted_by()!=null) {
			dealredis.setDeleted_by(deal.getDeleted_by());
			UUID deleted_by = dealredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}

			String Key = "Deal_" + deal.getDeal_id();
			Map<String, String> map = new HashMap<>();
			map.put("deal_id", id_str);
			map.put("name", name_str);
			if (bid_floor_str != null) {
				map.put("bid_floor", bid_floor_str);
			}
			if (including_seats_str != null) {
				map.put("including_seats", including_seats_str);
			}
			if (keywords_str != null) {
				map.put("keywords", keywords_str);
			}
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str !=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!= null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(Key, map);

		}
		return null;
	}




	private List<Creative> creativeredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Creative> bidder = creativerepo.findAll();
		for(Creative bid : bidder) {
			Creative creat = creativerepo.findById(bid.getCreative_id()).orElse(null);
			
			CreativeRedis createredis = new CreativeRedis();

			createredis.setCreative_id(creat.getCreative_id());
			UUID id = createredis.getCreative_id();
			String id_str = id.toString();

			createredis.setName(creat.getName());
			String name_str = createredis.getName();

			createredis.setAd_format(creat.getAdformat());
			ADFORMAT ad_format = createredis.getAd_format();
			String ad_format_str = ad_format.toString();

			createredis.setAd_type(creat.getAdtype());
			ADTYPE ad_type = createredis.getAd_type();
			String ad_type_str = ad_type.toString();

			createredis.setFilename(creat.getFilename());
			String filename_str = createredis.getFilename();

			createredis.setDestination(creat.getDestination());
			String destination_str = createredis.getDestination();

			String frequency_str = null;
			if (creat.getFrequency_capping() != null) {
				createredis.setFrequency_capping(creat.getFrequency_capping());
				frequency_str = createredis.getFrequency_capping();
			}

			String impression_str = null;
			if (creat.getImpression_capping() != null) {
				createredis.setImpression_capping(creat.getImpression_capping());
				impression_str = createredis.getImpression_capping();
			}

			createredis.setCampaign_id(creat.getCampign_id());
			UUID campaign_id = createredis.getCampaign_id();
			String campaign_id_str = campaign_id.toString();

			String banner_size_str = null;
			if (creat.getBanner_size() != null) {
				createredis.setBanner_size(creat.getBanner_size());
				UUID banner_size = createredis.getBanner_size();
				banner_size_str = banner_size.toString();
			}

			String thirdparty_str = null;
			if (creat.getThirdparty_tag() != null) {
				createredis.setThirdparty_tag(creat.getThirdparty_tag());
				thirdparty_str = createredis.getThirdparty_tag();
			}

			createredis.setSrc_obj(creat.getSrc_obj());
			String src_obj_str = createredis.getSrc_obj();

			createredis.setCreated_at(creat.getCreated_at());
			LocalDateTime created_at = createredis.getCreated_at();

			String[] arr1 = new String[2];

			arr1[0] = created_at.toString();

			arr1[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr1);

			createredis.setCreated_by(creat.getCreated_by());
			UUID created_by = createredis.getCreated_by();
			String created_by_str = created_by.toString();

			createredis.setUpdated_at(creat.getUpdated_at());
			LocalDateTime updated_at = createredis.getUpdated_at();

			String[] arr2 = new String[2];

			arr2[0] = updated_at.toString();

			arr2[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr2);
			
			String updated_by_str = null;
			if(creat.getUpdated_by()!=null) {
			createredis.setUpdated_by(creat.getUpdated_by());
			UUID updated_by = createredis.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(creat.getIs_deleted()!=0) {
			createredis.setIs_deleted(creat.getIs_deleted());
			int is_deleted = createredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(creat.getDeleted_at()!=null) {
			createredis.setDeleted_at(creat.getDeleted_at());
			LocalDateTime deleted_at = createredis.getDeleted_at();

			String[] arr3 = new String[2];

			arr3[0] = deleted_at.toString();

			arr3[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr3);
			}
			
			String deleted_by_str = null;
			if(creat.getDeleted_by()!=null) {
			createredis.setDeleted_by(creat.getDeleted_by());
			UUID deleted_by = createredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
            }

			String Key = "Creative_" + creat.getCreative_id();
			Map<String, String> map = new HashMap<>();
			map.put("creative_id", id_str);
			map.put("name", name_str);
			map.put("ad_format", ad_format_str);
			map.put("ad_type", ad_type_str);
			map.put("filename", filename_str);
			map.put("destination", destination_str);
			map.put("campaign_id", campaign_id_str);
			if (banner_size_str != null) {
				map.put("banner_size", banner_size_str);
			}
			if (frequency_str != null) {
				map.put("frequency_capping", frequency_str);
			}
			if (impression_str != null) {
				map.put("impression_capping", impression_str);
			}
			if (thirdparty_str != null) {
				map.put("thirdparty_tag", thirdparty_str);
			}
			map.put("src_obj", src_obj_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str !=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str !=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(Key, map);

		}
		return null;
	}




	private List<Campign> campaignredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Campign> bidder = campignrepo.findAll();
		for(Campign bid : bidder) {
			Campign camp = campignrepo.findById(bid.getCampign_id()).orElse(null);
			
			CampaignRedis campaignredis = new CampaignRedis();

			campaignredis.setCampaign_id(camp.getCampign_id());
			UUID campaign_id = campaignredis.getCampaign_id();
			String id_str = campaign_id.toString();

			campaignredis.setName(camp.getCampign_name());
			String name = campaignredis.getName();

			campaignredis.setAdvertiser_id(camp.getAdvertiser_id());
			UUID advertiser_id = campaignredis.getAdvertiser_id();
			String advertiser_id_str = advertiser_id.toString();

			campaignredis.setEnv_type(camp.getEnv_type());
			int env_type = campaignredis.getEnv_type();
			String env_type_str = Integer.toString(env_type);

			campaignredis.setBid_price(camp.getBid_price());
			double bid_price = campaignredis.getBid_price();
			String bid_price_str = Double.toString(bid_price);

			campaignredis.setDuration(camp.getDuration());
			String duration_str = campaignredis.getDuration();
			
			String auction_type_str=null;
			if(camp.getAuction_type()!=null) {
			campaignredis.setAuction_type(camp.getAuction_type());
			auction_type_str = campaignredis.getAuction_type();
			}

			String pricing_model_str = null;
			if (camp.getPricing_model() != null) {
				campaignredis.setPricing_model(camp.getPricing_model());
				pricing_model_str = campaignredis.getPricing_model();
			}

			String deal_str = null;
			if (camp.getDeal() != null) {
				campaignredis.setDeal(camp.getDeal());
				deal_str = campaignredis.getDeal();
			}

			String ssp_str =null;
			if(camp.getSsp()!=null) {
				campaignredis.setSsp(camp.getSsp());
				ssp_str = campaignredis.getSsp();
			}
			String categories_str = null;
			if (camp.getCategories() != null) {
				campaignredis.setCategories_id(camp.getCategories());
				categories_str = campaignredis.getCategories_id();
			}

			String dayparty_str = null;
			if(camp.getDayparting()!=null) {
				campaignredis.setDayparty(camp.getDayparting());
				dayparty_str = campaignredis.getDayparty();
			}
			
			String impression_str = null;
			if (camp.getImpression_capping() != null) {
				campaignredis.setImpression_capping(camp.getImpression_capping());
				impression_str = campaignredis.getImpression_capping();
			}

			String pacing_str = null;
			if (camp.getPacing() != null) {
				campaignredis.setPacing(camp.getPacing());
				pacing_str = campaignredis.getPacing();
			}

			campaignredis.setCampaign_budget(camp.getCampaignBudget());
			double campaign_budget = campaignredis.getCampaign_budget();
			String campaign_budget_str = Double.toString(campaign_budget);

			campaignredis.setDaily_budget(camp.getDailyBudget());
			double daily_budget = campaignredis.getDaily_budget();
			String daily_budget_str = Double.toString(daily_budget);

			campaignredis.setStatus(camp.getStatus());
			int status = campaignredis.getStatus();
			String status_str = Integer.toString(status);

			campaignredis.setTotal_impression(camp.getTotal_impression());
			int total_impression = campaignredis.getTotal_impression();
			String total_impression_str = Integer.toString(total_impression);

			campaignredis.setDaliy_impression(camp.getDaily_impression());
			int daliy_impression = campaignredis.getDaliy_impression();
			String daily_impression_str = Integer.toString(daliy_impression);

			campaignredis.setCreated_at(camp.getCreated_at());
			LocalDateTime created_at = campaignredis.getCreated_at();

			String[] arr = new String[2];

			arr[0] = created_at.toString();

			arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			campaignredis.setCreated_by(camp.getCreated_by());
			UUID created_by = campaignredis.getCreated_by();
			String created_by_str = created_by.toString();

			campaignredis.setUpdated_at(camp.getUpdated_at());
			LocalDateTime updated_at = campaignredis.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = updated_at.toString();

			arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr);
			
			String updated_by_str = null;
			if(updated_by_str!=null) {
		     campaignredis.setUpdated_by(camp.getUpdated_by());
		     UUID updated_by = campaignredis.getUpdated_by();
		    updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(camp.getIs_deleted()!=0) {
			campaignredis.setIs_deleted(camp.getIs_deleted());
			int is_deleted = campaignredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(camp.getDeleted_at()!=null) {
			campaignredis.setDeleted_at(camp.getDeleted_at());
			LocalDateTime deleted_at = campaignredis.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = deleted_at.toString();

			arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr1);
			}
			
			String deleted_by_str = null;
			if(camp.getDeleted_by()!=null) {
			campaignredis.setDeleted_by(camp.getDeleted_by());
			UUID deleted_by = campaignredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}
			
			String key = "Campaign_" + camp.getCampign_id();
			Map<String, String> map = new HashMap<>();
			map.put("campaign_id", id_str);
			map.put("name", name);
			map.put("advertiser_id", advertiser_id_str);
			map.put("env_type", env_type_str);
			map.put("bid_price", bid_price_str);
			map.put("duration", duration_str);
			if (pricing_model_str != null) {
				map.put("pricing_model", pricing_model_str);
			}

			if(dayparty_str!=null) {
				map.put("dayparting", dayparty_str);
			}
			if (categories_str != null) {
				map.put("categories", categories_str);
			}
			if (deal_str != null) {
				map.put("deal", deal_str);
			}
			if(ssp_str!=null) {
				map.put("ssp", ssp_str);
			}
			if (impression_str != null) {
				map.put("impression_capping", impression_str);
			}
			if (pacing_str != null) {
				map.put("pacing", pacing_str);
			}
			if(auction_type_str!=null) {
				map.put("auction_type", auction_type_str);
			}
			map.put("total_budget", campaign_budget_str);
			map.put("daily_budget", daily_budget_str);
			map.put("total_impression", total_impression_str);
			map.put("daily_impression", daily_impression_str);
			map.put("status", status_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str!=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(key, map);

		}
		return null;
	}




	private List<CampaignTarget> campaigntargetredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<CampaignTarget> bidder = campaigntargetrepo.findAll();
		for(CampaignTarget bid : bidder) {
			CampaignTarget campaigntarget = campaigntargetrepo.findById(bid.getTarget_id()).orElse(null);
			
			CampaignTargetRedis redis = new CampaignTargetRedis();

			redis.setTarget_data(campaigntarget.getTarget_data());
			String target_data = redis.getTarget_data();

			String key = "targetData_" + campaigntarget.getCampaign_id();
			jedis1.set(key, target_data);

		}
		return null;
	}




	private List<CampaignAdunit> campaignadunitredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<CampaignAdunit> bidder = campaignadurepo.findAll();
		for(CampaignAdunit bid : bidder) {
			CampaignAdunit campadu = campaignadurepo.findById(bid.getAssoc_id()).orElse(null);
			
			String key = "Campaign_Adunit_" + campadu.getAdunit_id();
			List<CampaignAdunit> campList = campaignadurepo.findbyadunit(campadu.getAdunit_id());
			List<UUID> camapaignidlist = campList.stream().map(id -> id.getCampaign_id()).collect(Collectors.toList());
			JSONArray ja = new JSONArray();
			for (UUID id : camapaignidlist) {
				JSONObject obj = new JSONObject();
				obj.put("campaign_id", id.toString());
				ja.add(obj);
			}
			Map<String, String> map = new HashMap<>();
			map.put("connectedCampaign", ja.toString());
			jedis1.hmset(key, map);

		}

		return null;
	}




	private List<AdunitBidder> adunitbidderRedis() {
		Jedis jedis1 = jedis.redisConnection();
		List<AdunitBidder> bidder = adunitbidrepo.findAll();
		for(AdunitBidder bid : bidder) {
			AdunitBidder adubid = adunitbidrepo.findById(bid.getAssoc_id()).orElse(null);
			
			String key = "Adunit_Bidder_" + adubid.getAdunit_id();
			List<AdunitBidder> bidderList = adunitbidrepo.findbyadunitid(adubid.getAdunit_id());
			List<UUID> camapaignidlist = bidderList.stream().map(id -> id.getBidder_id()).collect(Collectors.toList());
			JSONArray ja = new JSONArray();
			for (UUID id : camapaignidlist) {
				JSONObject obj = new JSONObject();
				obj.put("bidder_id", id.toString());
				ja.add(obj);
			}
			Map<String, String> map = new HashMap<>();
			map.put("connectedbidder", ja.toString());
			jedis1.hmset(key, map);

		}
		return bidder;
	}
	
	private List<AdunitDeal> adunitdealredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<AdunitDeal> deal = adunitdealrepo.findAll();
		for(AdunitDeal bid : deal) {
			AdunitDeal adudeal = adunitdealrepo.findById(bid.getAssoc_id()).orElse(null);
			
			String key = "Adunit_Deal_" + adudeal.getAdunit_id();
			List<AdunitDeal> dealList = adunitdealrepo.findbyadunitid(adudeal.getAdunit_id());
			List<UUID> camapaignidlist = dealList.stream().map(id -> id.getDeal_id()).collect(Collectors.toList());
			JSONArray ja = new JSONArray();
			for (UUID id : camapaignidlist) {
				JSONObject obj = new JSONObject();
				obj.put("deal_id", id.toString());
				ja.add(obj);
			}
			Map<String, String> map = new HashMap<>();
			map.put("connecteddeal", ja.toString());
			jedis1.hmset(key, map);

		}
		return deal;
	}

	private List<AdunitEndpoint> adunitendpointredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<AdunitEndpoint> endpoint = adunitendrepo.findAll();
		for(AdunitEndpoint bid : endpoint) {
			AdunitEndpoint aduend = adunitendrepo.findById(bid.getAssoc_id()).orElse(null);
			
			String key ="Adunit_Endpoint_"+aduend.getAdunit_id();
			List<AdunitEndpoint> adu = adunitendrepo.findbyadunit(aduend.getAdunit_id());
			List<UUID> adunit_id = adu.stream().map(id->id.getEndpoint_id()).collect(Collectors.toList());
			JSONArray ja = new JSONArray();
			for (UUID id : adunit_id) {
				JSONObject obj = new JSONObject();
				obj.put("endpoint_id", id.toString());
				ja.add(obj);
			}
			Map<String, String> map = new HashMap<>();
			map.put("connectedEndpoint", ja.toString());
			jedis1.hmset(key, map);

		}
		return endpoint;
	}

	private List<Adunits> adunitredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Adunits> adunit = adunitrepo.findAll();
		for(Adunits aduend : adunit) {
			Adunits adu = adunitrepo.findById(aduend.getAdunit_id()).orElse(null);
			
			AdunitRedis adunitredis = new AdunitRedis();

			adunitredis.setAdunit_id(adu.getAdunit_id());
			UUID id = adunitredis.getAdunit_id();
			String id_str = id.toString();

			adunitredis.setName(adu.getName());
			String name_str = adunitredis.getName();

			adunitredis.setPublisher_id(adu.getPublisher_id());
			UUID publisher_id = adunitredis.getPublisher_id();
			String publisher_id_str = publisher_id.toString();

			String site_id_str = null;
			if (adu.getSite_id() != null) {
				adunitredis.setSite_id(adu.getSite_id());
				UUID site_id = adunitredis.getSite_id();
				site_id_str = site_id.toString();
			}

			String banner_size_str = null;
			if (adu.getBanner_size() != null) {
				adunitredis.setBanner_size(adu.getBanner_size());
				UUID banner_size = adunitredis.getBanner_size();
				banner_size_str = banner_size.toString();
			}
			adunitredis.setAdunit_type(adu.getAdunit_type());
			ADFORMAT adunit_type = adunitredis.getAdunit_type();
			String adunit_type_str = adunit_type.toString();

			adunitredis.setEnv_type(adu.getEnv_type());
			int env_type = adunitredis.getEnv_type();
			String env_type_str = Integer.toString(env_type);
			
			String auction_type_str=null;
			if(adu.getAuction_type()!=null) {
			adunitredis.setAuction_type(adu.getAuction_type());
			auction_type_str = adunitredis.getAuction_type();
			}
			String floor_str = null;
			if (adu.getFloor_price() != null) {
				adunitredis.setFloor_price(adu.getFloor_price());
				floor_str = adunitredis.getFloor_price();
			}
			adunitredis.setStatus(adu.getStatus());
			int status = adunitredis.getStatus();
			String status_str = Integer.toString(status);

			adunitredis.setCreated_at(adu.getCreated_at());
			LocalDateTime created_at = adunitredis.getCreated_at();

			String[] arr = new String[2];

			arr[0] = created_at.toString();

			arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			adunitredis.setCreated_by(adu.getCreated_by());
			UUID created_by = adunitredis.getCreated_by();
			String created_by_str = created_by.toString();

			adunitredis.setUpdated_at(adu.getUpdated_at());
			LocalDateTime updated_at = adunitredis.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = updated_at.toString();

			arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr1);
			
			String updated_by_str = null;
			if(adu.getUpdated_by()!=null) {
			adunitredis.setUpdated_by(adu.getUpdated_by());
			UUID updated_by = adunitredis.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str =null;
			if(adu.getIs_deleted()!=0) {
			adunitredis.setIs_deleted(adu.getIs_deleted());
			int is_deleted = adunitredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(adu.getDeleted_at()!=null) {
			adunitredis.setDeleted_at(adu.getDeleted_at());
			LocalDateTime deleted_at = adunitredis.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = deleted_at.toString();

			arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr2);
			}

			String deleted_by_str = null;
			if(adu.getDeleted_by()!=null) {
			adunitredis.setDeleted_by(adu.getDeleted_by());
			UUID deleted_by = adunitredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}
			
			String Key = "Adunit_" + adu.getAdunit_id();
			Map<String, String> map = new HashMap<>();
			map.put("adunit_id", id_str);
			map.put("name", name_str);
			map.put("publisher_id", publisher_id_str);
			if (site_id_str != null) {
				map.put("site_id", site_id_str);
			}
			if (banner_size_str != null) {
				map.put("banner_size", banner_size_str);
			}
			if (floor_str != null) {
				map.put("floor_price", floor_str);
			}
			map.put("adunit_type", adunit_type_str);
			if(auction_type_str!=null) {
			map.put("auction_type", auction_type_str);
			}
			map.put("env_type", env_type_str);
			map.put("status", status_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str!=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			jedis1.hmset(Key, map);

		}
		return adunit;
	}

	private List<Advertriser> advertiserredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Advertriser> adver = advertiserrepo.findAll();
		for(Advertriser ad : adver) {
			Advertriser add = advertiserrepo.findById(ad.getAdvertiser_id()).orElse(null);
			
			AdvertiserRedis advertiser = new AdvertiserRedis();

			advertiser.setAdvertiser_id(add.getAdvertiser_id());
			UUID id = advertiser.getAdvertiser_id();
			String id_str = id.toString();

			advertiser.setAdvertiser_name(add.getAdvertiser_name());
			String name_str = advertiser.getAdvertiser_name();

			advertiser.setEmail(add.getEmail());
			String email_str = advertiser.getEmail();

			advertiser.setStatus(add.getStatus());
			int status = advertiser.getStatus();
			String status_str = Integer.toString(status);
			
			String total_balance_str = null;
			if(add.getTotal_balance()!=0) {
    		advertiser.setTotal_balance(add.getTotal_balance());
    		double total_balance = advertiser.getTotal_balance();
    		total_balance_str = Double.toString(total_balance);
			}
			
			String deposite_amount_str=null;
			if(add.getTotal_balance()!=0) {
    		advertiser.setDeposite_amount(add.getDeposite_amount());
    		double deposite_amount = advertiser.getDeposite_amount();
    		deposite_amount_str = Double.toString(deposite_amount);
			}

			advertiser.setCreated_by(add.getCreated_by());
			UUID created_by = advertiser.getCreated_by();
			String created_by_str = created_by.toString();

			advertiser.setCreated_at(add.getCreated_at());
			LocalDateTime now = advertiser.getCreated_at();

			String[] arr = new String[2];

			arr[0] = now.toString();

			arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);

			advertiser.setUpdated_at(add.getUpdated_at());
			LocalDateTime update_at = advertiser.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = update_at.toString();

			arr1[1] = update_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr1);
			
			String updated_by_str =null;
			if(add.getUpdated_by()!=null) {
			advertiser.setUpdated_by(add.getUpdated_by());
			UUID updated_by = advertiser.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(add.getIs_deleted()!=0) {
			advertiser.setIs_deleted(add.getIs_deleted());
			int is_deleted = advertiser.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(add.getDeleted_at()!=null) {
			advertiser.setDeleted_at(add.getDeleted_at());
			LocalDateTime deleted_at = advertiser.getDeleted_at();
			String[] arr2 = new String[2];

			arr2[0] = deleted_at.toString();

			arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr2);
			}
			
			String deleted_by_str = null;
			if(add.getDeleted_by()!=null) {
			advertiser.setDeleted_by(add.getDeleted_by());
			UUID deleted_by = advertiser.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}
            
			String key = "Advertiser_" + add.getAdvertiser_id();
			Map<String, String> map = new HashMap<>();
			map.put("advertiser_id", id_str);
			map.put("name", name_str);
			map.put("email", email_str);
			map.put("status", status_str);
			map.put("created_at", created_at_str);
			map.put("created_by", created_by_str);
			map.put("updated_at", updated_at_str);
			if(updated_by_str!=null) {
			map.put("updated_by", updated_by_str);
			}
			if(is_deleted_str!=null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by", deleted_by_str);
			}
			if(total_balance_str!=null) {
    		map.put("total_balance", total_balance_str);
			}
			if(deposite_amount_str!=null) {
    		map.put("deposite_amount", deposite_amount_str);
			}
			jedis1.hmset(key, map);
         }

		return adver;
	}
	
	private List<Bidder> bidderredis() {
		Jedis jedis1 = jedis.redisConnection();
		List<Bidder> bidder = bidderrepo.findAll();
		for(Bidder bidd : bidder) {
			Bidder bid = bidderrepo.findById(bidd.getBidder_id()).orElse(null);
			
			BidderRedis bidderredis = new BidderRedis();
			
			bidderredis.setBidder_id(bid.getBidder_id());
			UUID id = bidderredis.getBidder_id();
			String id_str = id.toString();
			
			bidderredis.setBidder_name(bid.getBidder_name());
			String name_str = bidderredis.getBidder_name();
			
			bidderredis.setBidder_code(bid.getBidder_code());
			String bidder_code_str = bidderredis.getBidder_code();
			
			bidderredis.setBidder_parameters(bid.getBidder_parameters());
			String bidder_parameters_str = bidderredis.getBidder_parameters();
			
			bidderredis.setCreated_at(bid.getCreated_at());
			LocalDateTime now = bidderredis.getCreated_at();

			String[] arr = new String[2];

			arr[0] = now.toString();

			arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String created_at_str = Arrays.toString(arr);
			
			bidderredis.setCreated_by(bid.getCreated_by());
			UUID created_by = bidderredis.getCreated_by();
			String created_by_str = created_by.toString();
			
			bidderredis.setUpdated_at(bid.getUpdated_at());
			LocalDateTime now1 = bidderredis.getUpdated_at();

			String[] arr1 = new String[2];

			arr1[0] = now1.toString();

			arr1[1] = now1.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			String updated_at_str = Arrays.toString(arr);
			
			String updated_by_str = null;
			if(bid.getUpdated_by()!=null) {
			bidderredis.setUpdated_by(bid.getUpdated_by());
			UUID updated_by =  bidderredis.getUpdated_by();
			updated_by_str = updated_by.toString();
			}
			
			String is_deleted_str = null;
			if(bid.getIs_deleted()!=0) {
			bidderredis.setIs_deleted(bid.getIs_deleted());
			int is_deleted = bidderredis.getIs_deleted();
			is_deleted_str = Integer.toString(is_deleted);
			}
			
			String deleted_at_str = null;
			if(bid.getDeleted_at()!=null) {
			bidderredis.setDeleted_at(bid.getDeleted_at());
			LocalDateTime now2= bidderredis.getDeleted_at();

			String[] arr2 = new String[2];

			arr2[0] = now2.toString();

			arr2[1] = now2.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
			deleted_at_str = Arrays.toString(arr);
			}
			
			String deleted_by_str = null;
			if(bid.getDeleted_by()!=null) {
			bidderredis.setDeleted_by(bid.getDeleted_by());
			UUID deleted_by = bidderredis.getDeleted_by();
			deleted_by_str = deleted_by.toString();
			}

			String key ="Bidder_"+bid.getBidder_id();
			Map<String,String> map = new HashMap<>();
			map.put("bidder_id", id_str);
			map.put("name", name_str);
			map.put("bidder_code",bidder_code_str);
			map.put("bidder_parameters",bidder_parameters_str);
			map.put("created_at",created_at_str);
			map.put("created_by",created_by_str);
			map.put("updated_at",updated_at_str);
			if(updated_by_str != null) {
			map.put("updated_by",updated_by_str);
			}
			if(is_deleted_str != null) {
			map.put("is_deleted", is_deleted_str);
			}
			if(deleted_at_str!=null) {
			map.put("deleted_at", deleted_at_str);
			}
			if(deleted_by_str!=null) {
			map.put("deleted_by",deleted_by_str);
			}
			jedis1.hmset(key, map);

		}
		return null;
	}


	
}
