package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.common.FilterResponse;
import com.example.demo.common.PageDetails;
import com.example.demo.common.PageResponse;
import com.example.demo.dto.CreativeCreateDTO;
import com.example.demo.dto.CreativeDeleteDTO;
import com.example.demo.dto.CreativeFilterRequest;
import com.example.demo.dto.CreativeResponseDTO;
import com.example.demo.dto.CreativeUpdateDTO;
import com.example.demo.entity.ADFORMAT;
import com.example.demo.entity.ADTYPE;
import com.example.demo.entity.Campign;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.Creative;
import com.example.demo.entity.CreativeFilterEntity;
import com.example.demo.entity.ManageUser;
import com.example.demo.entity.Roles;
import com.example.demo.redisentity.CreativeRedis;
import com.example.demo.repository.CampignRepository;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.CreativeRepository;
import com.example.demo.repository.ManageUserRepository;
import com.example.demo.repository.RolesRepository;
import com.example.demo.service.CreativeService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import redis.clients.jedis.Jedis;

@Service
public class CreativeServiceImpl implements CreativeService {

	@Autowired
	private CreativeRepository repo;

	@Autowired
	private ConfigurationRepo configrepo;

	@Autowired
	private CampignRepository campignrepo;

	@Autowired
	private ManageUserRepository userrepo;

	@Autowired
	private RolesRepository rolerepo;

	@Autowired
	private Jedis jedis;

	@Override
	public APIResponse createcreative(CreativeCreateDTO create) throws JsonProcessingException {
		APIResponse api = new APIResponse();

		Creative creat = new Creative();
		creat.setAdformat(create.getAdformat());
		creat.setName(create.getName());
		creat.setAdtype(create.getAdtype());
		creat.setDestination(create.getDestinationurl());
		creat.setFilename(create.getFilename());
		creat.setCreated_by(create.getCreated_by());
		creat.setBanner_size(create.getBanner_size());
		creat.setCampign_id(create.getCampign_id());
		creat.setFrequency_capping(create.getFrequency_capping());
		creat.setImpression_capping(create.getImpression_capping());
		creat.setThirdparty_tag(create.getThirdparty_tag());
		ObjectMapper mapper = new ObjectMapper();
		String srcstring = mapper.writeValueAsString(create.getSrc_obj());
		creat.setSrc_obj(srcstring);
		creat.setCreated_at(LocalDateTime.now());
		creat.setUpdated_at(LocalDateTime.now());
		repo.save(creat);

		CreativeRedis createredis = new CreativeRedis();

		createredis.setCreative_id(creat.getCreative_id());
		UUID id = createredis.getCreative_id();
		String id_str = id.toString();

		createredis.setName(creat.getName());
		String name_str = createredis.getName();

		createredis.setAd_format(creat.getAdformat());
		ADFORMAT ad_format = createredis.getAd_format();
		String ad_format_str = ad_format.toString();

		createredis.setAd_type(creat.getAdtype());
		ADTYPE ad_type = createredis.getAd_type();
		String ad_type_str = ad_type.toString();

		createredis.setFilename(creat.getFilename());
		String filename_str = createredis.getFilename();

		createredis.setDestination(creat.getDestination());
		String destination_str = createredis.getDestination();

		String frequency_str = null;
		if (creat.getFrequency_capping() != null) {
			createredis.setFrequency_capping(creat.getFrequency_capping());
			frequency_str = createredis.getFrequency_capping();
		}

		String impression_str = null;
		if (creat.getImpression_capping() != null) {
			createredis.setImpression_capping(creat.getImpression_capping());
			impression_str = createredis.getImpression_capping();
		}

		createredis.setCampaign_id(creat.getCampign_id());
		UUID campaign_id = createredis.getCampaign_id();
		String campaign_id_str = campaign_id.toString();

		String banner_size_str = null;
		if (create.getBanner_size() != null) {
			createredis.setBanner_size(creat.getBanner_size());
			UUID banner_size = createredis.getBanner_size();
			banner_size_str = banner_size.toString();
		}

		String thirdparty_str = null;
		if (creat.getThirdparty_tag() != null) {
			createredis.setThirdparty_tag(creat.getThirdparty_tag());
			thirdparty_str = createredis.getThirdparty_tag();
		}

		createredis.setSrc_obj(creat.getSrc_obj());
		String src_obj_str = createredis.getSrc_obj();

		createredis.setCreated_at(creat.getCreated_at());
		LocalDateTime created_at = createredis.getCreated_at();

		String[] arr1 = new String[2];

		arr1[0] = created_at.toString();

		arr1[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr1);

		createredis.setCreated_by(creat.getCreated_by());
		UUID created_by = createredis.getCreated_by();
		String created_by_str = created_by.toString();

		createredis.setUpdated_at(creat.getUpdated_at());
		LocalDateTime updated_at = createredis.getUpdated_at();

		String[] arr2 = new String[2];

		arr2[0] = updated_at.toString();

		arr2[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr2);

		String Key = "Creative_" + creat.getCreative_id();
		Map<String, String> map = new HashMap<>();
		map.put("creative_id", id_str);
		map.put("name", name_str);
		map.put("ad_format", ad_format_str);
		map.put("ad_type", ad_type_str);
		map.put("filename", filename_str);
		map.put("destination", destination_str);
		map.put("campaign_id", campaign_id_str);
		if (banner_size_str != null) {
			map.put("banner_size", banner_size_str);
		}
		if (frequency_str != null) {
			map.put("frequency_capping", frequency_str);
		}
		if (impression_str != null) {
			map.put("impression_capping", impression_str);
		}
		if (thirdparty_str != null) {
			map.put("thirdparty_tag", thirdparty_str);
		}
		map.put("src_obj", src_obj_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);

		jedis.hmset(Key, map);

		api.setData(creat);
		api.setMessage("Creative Created successfully");
		api.setMsgCode("CREATIVE CREATED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse Updatecreative(CreativeUpdateDTO update, UUID creative_id) throws JsonProcessingException {
		APIResponse api = new APIResponse();

		Creative add = repo.findById(creative_id).orElse(null);
		if (add == null) {
			ErrorObj err = new ErrorObj();
			err.setCode("Given creative Is Not Present In Database");
			api.setError(err);
			api.setMessage("Creative Is Not present");
			api.setMsgCode("CREATIVE IS NOT PRESENT");
			return api;
		}
		add.setAdformat(update.getAdformat());
		add.setName(update.getName());
		add.setAdtype(update.getAdtype());
		add.setFilename(update.getFilename());
		add.setDestination(update.getDestinationurl());
		add.setBanner_size(update.getBanner_size());
		add.setCampign_id(update.getCampign_id());
		add.setFrequency_capping(update.getFrequency_capping());
		add.setImpression_capping(update.getImpression_capping());
		add.setThirdparty_tag(update.getThirdparty_tag());
		ObjectMapper mapper = new ObjectMapper();
		String srcstring = mapper.writeValueAsString(update.getSrc_obj());
		add.setSrc_obj(srcstring);
		add.setUpdated_at(LocalDateTime.now());
		add.setUpdated_by(update.getUpdated_by());
		repo.save(add);

		CreativeRedis createredis = new CreativeRedis();

		createredis.setCreative_id(add.getCreative_id());
		UUID id = createredis.getCreative_id();
		String id_str = id.toString();

		createredis.setName(add.getName());
		String name_str = createredis.getName();

		createredis.setAd_format(add.getAdformat());
		ADFORMAT ad_format = createredis.getAd_format();
		String ad_format_str = ad_format.toString();

		createredis.setAd_type(add.getAdtype());
		ADTYPE ad_type = createredis.getAd_type();
		String ad_type_str = ad_type.toString();

		createredis.setFilename(add.getFilename());
		String filename_str = createredis.getFilename();

		createredis.setDestination(add.getDestination());
		String destination_str = createredis.getDestination();

		createredis.setCampaign_id(add.getCampign_id());
		UUID campaign_id = createredis.getCampaign_id();
		String campaign_id_str = campaign_id.toString();

		String banner_size_str = null;
		if (add.getBanner_size() != null) {
			createredis.setBanner_size(add.getBanner_size());
			UUID banner_size = createredis.getBanner_size();
			banner_size_str = banner_size.toString();
		}

		String frequency_str = null;
		if (add.getFrequency_capping() != null) {
			createredis.setFrequency_capping(add.getFrequency_capping());
			frequency_str = createredis.getFrequency_capping();
		}

		String impression_str = null;
		if (add.getImpression_capping() != null) {
			createredis.setImpression_capping(add.getImpression_capping());
			impression_str = createredis.getImpression_capping();
		}

		String thirdparty_str = null;
		if (update.getThirdparty_tag() != null) {
			createredis.setThirdparty_tag(update.getThirdparty_tag());
			thirdparty_str = createredis.getThirdparty_tag();
		}

		createredis.setSrc_obj(add.getSrc_obj());
		String src_obj_str = createredis.getSrc_obj();

		createredis.setCreated_at(add.getCreated_at());
		LocalDateTime created_at = createredis.getCreated_at();

		String[] arr1 = new String[2];

		arr1[0] = created_at.toString();

		arr1[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr1);

		createredis.setCreated_by(add.getCreated_by());
		UUID created_by = createredis.getCreated_by();
		String created_by_str = created_by.toString();

		createredis.setUpdated_at(add.getUpdated_at());
		LocalDateTime updated_at = createredis.getUpdated_at();

		String[] arr2 = new String[2];

		arr2[0] = updated_at.toString();

		arr2[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr2);

		createredis.setUpdated_by(add.getUpdated_by());
		UUID updated_by = createredis.getUpdated_by();
		String updated_by_str = updated_by.toString();

		String Key = "Creative_" + add.getCreative_id();
		Map<String, String> map = new HashMap<>();
		map.put("creative_id", id_str);
		map.put("name", name_str);
		map.put("ad_format", ad_format_str);
		map.put("ad_type", ad_type_str);
		map.put("filename", filename_str);
		map.put("destination", destination_str);
		map.put("campaign_id", campaign_id_str);
		if (banner_size_str != null) {
			map.put("banner_size", banner_size_str);
		}
		if (frequency_str != null) {
			map.put("frequency_capping", frequency_str);
		}
		if (impression_str != null) {
			map.put("impression_capping", impression_str);
		}
		if (thirdparty_str != null) {
			map.put("thirdparty_tag", thirdparty_str);
		}

		map.put("src_obj", src_obj_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);
		map.put("updated_by", updated_by_str);

		jedis.hmset(Key, map);

		api.setData(update);
		api.setMessage("Creative Updated Successfully");
		api.setMsgCode("CREATIVE UPDATED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse deletecreative(CreativeDeleteDTO delete) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Creative vb = repo.findById(delete.getCreative_id()).orElse(null);
		if (vb == null) {
			err.setCode("Given Creative Is Not Present In Database");
			api.setError(err);
			api.setMessage("Creative Is Not Present");
			api.setMsgCode("CREATIVE IS NOT PRESENT");
			return api;
		}
		if (vb.getIs_deleted() == 1) {
			err.setCode("Cannot Delete The Deleted Creative");
			api.setError(err);
			api.setMessage("Creative Is Already Deleted");
			api.setMsgCode("CREATIVE IS ALREADY DELETED");
			return api;
		}
		vb.setIs_deleted(1);
		vb.setDeleted_at(LocalDateTime.now());
		vb.setDeleted_by(delete.getDeleted_by());
		repo.save(vb);

		CreativeRedis createredis = new CreativeRedis();

		createredis.setIs_deleted(vb.getIs_deleted());
		int is_deleted = createredis.getIs_deleted();
		String is_deleted_str = Integer.toString(is_deleted);

		createredis.setDeleted_at(vb.getDeleted_at());
		LocalDateTime deleted_at = createredis.getDeleted_at();

		String[] arr2 = new String[2];

		arr2[0] = deleted_at.toString();

		arr2[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String deleted_at_str = Arrays.toString(arr2);

		createredis.setDeleted_by(vb.getDeleted_by());
		UUID deleted_by = createredis.getDeleted_by();
		String deleted_by_str = deleted_by.toString();

		String Key = "Creative_" + vb.getCreative_id();
		Map<String, String> map = new HashMap<>();

		map.put("is_deleted", is_deleted_str);
		map.put("deleted_at", deleted_at_str);
		map.put("deleted_by", deleted_by_str);

		jedis.hmset(Key, map);

		api.setData(vb);
		api.setMessage("Creative delete Successfully");
		api.setMsgCode("CREATIVE DELETED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getbyid(UUID creative_id) {
		APIResponse api = new APIResponse();

		Creative create = repo.findById(creative_id).orElse(null);
		CreativeResponseDTO response = MapToDto(create);
		api.setData(response);
		api.setMessage("Creative Get Successfully");
		api.setMsgCode("CREATIVE GET SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getall() {
		APIResponse api = new APIResponse();

		List<Creative> create = repo.findAll();
		List<CreativeResponseDTO> response = create.stream().map(use -> MapToDto(use)).collect(Collectors.toList());

		api.setData(response);
		api.setMessage("Creative List Get Successfully");
		api.setMsgCode("CREATIVE LIST GET SUCCESSFULLY");
		return api;
	}

	private CreativeResponseDTO MapToDto(Creative create) {
		CreativeResponseDTO response = new CreativeResponseDTO();
		response.setCreative_id(create.getCreative_id());
		response.setName(create.getName());
		response.setAdformat(create.getAdformat());
		response.setAdtype(create.getAdtype());
		response.setFilename(create.getFilename());
		response.setDestination(create.getDestination());
		response.setBanner_size(create.getBanner_size());
		response.setCampaign_id(create.getCampign_id());
		response.setSrc_obj(create.getSrc_obj());
		response.setFrequency_capping(create.getFrequency_capping());
		response.setImpression_capping(create.getImpression_capping());
		response.setThirdparty_tag(create.getThirdparty_tag());
		Campign camp = campignrepo.findById(create.getCampign_id()).orElse(null);
		response.setCampaign_name(camp.getCampign_name());

		List<Configurations> config = configrepo.findAll();
		Configurations obj = config.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(obj.getConfigValue());
		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(create.getCreated_at(), ZoneId.of("UTC-4")));
		response.setCreated_at(arr1);
		response.setCreated_by(create.getCreated_by());

		String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(create.getUpdated_at(), ZoneId.of("UTC-4")));
		response.setUpdated_at(arr2);
		response.setUpdated_by(create.getUpdated_by());

		if (create.getDeleted_at() != null) {
			String arr3 = newYorkDateFormatter.format(ZonedDateTime.of(create.getDeleted_at(), ZoneId.of("UTC-4")));
			response.setDeleted_at(arr3);
		}
		response.setIs_deleted(create.getIs_deleted());
		response.setDeleted_by(create.getDeleted_by());
		return response;
	}

	@Override
	public FilterResponse list(CreativeFilterRequest filter, UUID user_id) {
		FilterResponse api = new FilterResponse();

		String field = null, order = null;
		if (filter.getSort() != null && filter.getSort().size() == 1) {
			for (Map.Entry m : filter.getSort().entrySet()) {
				field = (String) m.getKey();
				order = (String) m.getValue();
			}
		} else {

		}

		PageDetails pageing = filter.getPages();
		Pageable pageable = null;

		if (filter.getFilter() == null && filter.getPages() == null) {

			List<Creative> creative = null;
			List<CreativeResponseDTO> dto = null;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				creative = repo.findAll();
			} else if (role.getRoletype().equals("ADVERTISER")) {
				List<Campign> camp = campignrepo.findbyadvertiser_id(user_id);
				List<UUID> cam = camp.stream().map(dt1 -> dt1.getCampign_id()).collect(Collectors.toList());
				creative = repo.finbbycampaign_id(cam);
			}
			dto = creative.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			api.setData(dto);
			return api;
		}

		if (filter.getPages() == null) {
			PageDetails pageing2 = new PageDetails();

			pageable = null;

			List<Creative> creative = null;
			List<CreativeResponseDTO> dto = null;
			int ResponseCount;

			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				creative = repo.findAll();
			} else if (role.getRoletype().equals("ADVERTISER")) {
				List<Campign> camp = campignrepo.findbyadvertiser_id(user_id);
				List<UUID> cam = camp.stream().map(dt1 -> dt1.getCampign_id()).collect(Collectors.toList());
				creative = repo.finbbycampaign_id(cam);

			}
			dto = creative.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			CreativeFilterEntity creativeFilter = filter.getFilter();
			List<UUID> CreativeIdList = creative.stream().map(create -> create.getCreative_id())
					.collect(Collectors.toList());
			List<Creative> filteredList = repo.getallDetails(creativeFilter.getName(),
					creativeFilter.getCreative_type(), creativeFilter.getAd_format(), creativeFilter.getAd_type(),
					creativeFilter.getCampaign_id(), creativeFilter.getBanner_size(), creativeFilter.getStatus(),
					creativeFilter.getIs_deleted(), CreativeIdList);
			List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getCampign_id())
					.collect(Collectors.toList());
			ResponseCount = campignrepo.getResultCount(filteredIdList);
			if (ResponseCount == 0) {
				ResponseCount = 10;
			}
			if (filter.getSort() == null || filter.getSort().size() == 0) {

				pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));
			} else {
				if (field.equals("") || order.equals("")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));

				}

				else if (order.equalsIgnoreCase("asc")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field).descending());
				}
			}

			List<Creative> creativeListWithPage = repo.getFilteredListwithoutPage(filteredIdList, pageable)
					.getContent();
			dto = creativeListWithPage.stream().map(CampignRes -> MapToDto(CampignRes)).collect(Collectors.toList());

			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageSize(10);
			pageRes.setTotalCount(ResponseCount);
			api.setPage(pageRes);
			api.setData(dto);
			return api;
		}
		List<CreativeResponseDTO> CreativeResList = null;

		// set 2 if filterRequest Page details not null

		int ResponseCount = 0;
		if (filter.getFilter() == null) {
			Page<Creative> creative = null;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				creative = repo.findAll(pageable);
			} else if (role.getRoletype().equals("ADVERTISER")) {
				List<Campign> camp = campignrepo.findbyadvertiser_id(user_id);
				List<UUID> cam = camp.stream().map(dt1 -> dt1.getCampign_id()).collect(Collectors.toList());
				creative = repo.finbbycampaign(cam, pageable);

			}
			List<UUID> CreativeIdList = creative.stream().map(camUni -> camUni.getCreative_id())
					.collect(Collectors.toList());
			ResponseCount = repo.getResultCount(CreativeIdList);
			creative = repo.getFilteredListwithoutPage(CreativeIdList, pageable);

			List<Creative> ResContent = creative.getContent();
			CreativeResList = ResContent.stream().map(campignunitRes -> MapToDto(campignunitRes))
					.collect(Collectors.toList());
			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageCount(pageing.getPageIndex());
			if (pageing.getPageSize() == 0) {
				pageRes.setPageSize(10);
			} else {
				pageRes.setPageSize(pageing.getPageSize());
			}
			api.setData(CreativeResList);
			api.setPage(pageRes);
			api.setMessage("CreativeList_With_Filter_2");
			api.setMsgCode("CREATIVELIST_WITH_FILTER_2");
			return api;
		}

		if (filter.getSort() == null || filter.getSort().size() == 0) {
			if (pageing.getPageSize() == 0) {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
			} else {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by("name"));
			}
		} else {
			if (field.equals("") || order.equals("")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by("name"));
				}
			}

			else if (order.equalsIgnoreCase("asc")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by(field));
				}
			} else {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field).descending());
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by(field).descending());
				}
			}
		}

		List<Creative> creative = null;
		ManageUser user = userrepo.findById(user_id).orElse(null);
		Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
		if (role.getRoletype().equals("MASTER_ADMIN")) {
			creative = repo.findAll();
		} else if (role.getRoletype().equals("ADVERTISER")) {
			List<Campign> camp = campignrepo.findbyadvertiser_id(user_id);
			List<UUID> cam = camp.stream().map(dto -> dto.getCampign_id()).collect(Collectors.toList());
			creative = repo.finbbycampaign_id(cam);
		}
		CreativeFilterEntity creativeFilter = filter.getFilter();
		List<UUID> creativeIdList = creative.stream().map(cam -> cam.getCreative_id()).collect(Collectors.toList());
		List<Creative> filteredList = repo.getallDetails(creativeFilter.getName(), creativeFilter.getCreative_type(),
				creativeFilter.getAd_format(), creativeFilter.getAd_type(), creativeFilter.getCampaign_id(),
				creativeFilter.getBanner_size(), creativeFilter.getStatus(), creativeFilter.getIs_deleted(),
				creativeIdList);
		List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getCreative_id()).collect(Collectors.toList());
		ResponseCount = repo.getResultCount(filteredIdList);
		List<Creative> creativeFilteredContent = repo.getFilteredList(filteredIdList, pageable).getContent();
		CreativeResList = creativeFilteredContent.stream().map(campignRes -> MapToDto(campignRes))
				.collect(Collectors.toList());

		PageResponse pageRes = new PageResponse();
		pageRes.setTotalCount(ResponseCount);
		pageRes.setPageCount(pageing.getPageIndex());
		if (pageing.getPageSize() == 0) {
			pageRes.setPageSize(10);
		} else {
			pageRes.setPageSize(pageing.getPageSize());
		}
		api.setData(CreativeResList);
		api.setPage(pageRes);
		api.setMessage("Filtered List of Creative");
		api.setMsgCode("FILTERED_LIST_OF_CREATIVE");

		return api;
	}
}
