package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.common.FilterResponse;
import com.example.demo.common.PageDetails;
import com.example.demo.common.PageResponse;
import com.example.demo.dto.CampignCreateDTO;
import com.example.demo.dto.CampignDeleteDTO;
import com.example.demo.dto.CampignFilterRequest;
import com.example.demo.dto.CampignResponseDTO;
import com.example.demo.dto.CampignUpdateDTO;
import com.example.demo.entity.Advertriser;
import com.example.demo.entity.Campign;
import com.example.demo.entity.CampignFilterEntity;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.Environment;
import com.example.demo.redisentity.CampaignRedis;
import com.example.demo.repository.AdvertriserRepo;
import com.example.demo.repository.CampignRepository;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.EnvironmentRepo;
import com.example.demo.service.CampignService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import redis.clients.jedis.Jedis;

@Service
public class CampignServiceImpl implements CampignService {

	@Autowired
	private CampignRepository campignrepo;

	@Autowired
	private AdvertriserRepo addrepo;

	@Autowired
	private ConfigurationRepo configRepo;

	@Autowired
	private EnvironmentRepo envrepo;

	@Autowired
	private Jedis jedis;

	@Override
	public APIResponse createcampign(CampignCreateDTO create) throws JsonProcessingException {
		APIResponse api = new APIResponse();

		Campign camp = new Campign();
		camp.setCampign_name(create.getCampign_name());
		camp.setBid_price(create.getBid_price());
		camp.setAdvertiser_id(create.getAdvertiser_id());
		camp.setCampaignBudget(create.getTotal_budget());
		camp.setDailyBudget(create.getDaily_budget());
		camp.setEnv_type(create.getEnv_type());
		camp.setTotal_impression(create.getTotal_impression());
		camp.setDaily_impression(create.getDaliy_impression());
		camp.setImpression_capping(create.getImpression_capping());
		camp.setPacing(create.getPacing());

		ObjectMapper mapper = new ObjectMapper();
		String srcstring = mapper.writeValueAsString(create.getDuration());
		camp.setDuration(srcstring);

		String deal = mapper.writeValueAsString(create.getDeal());
		camp.setDeal(deal);
		
		String ssp = mapper.writeValueAsString(create.getSsp());
		camp.setSsp(ssp);
		
		String auction_type = mapper.writeValueAsString(create.getAuction_type());
		camp.setAuction_type(auction_type);
		
		String dayparty = mapper.writeValueAsString(create.getDayparting());
		camp.setDayparting(dayparty);

		camp.setPricing_model(create.getPricing_model());

		String categories = mapper.writeValueAsString(create.getCategories());
		camp.setCategories(categories);
		camp.setCreated_by(create.getCreated_by());
		camp.setCreated_at(LocalDateTime.now());
		camp.setUpdated_at(LocalDateTime.now());
		camp.setStatus(1);
		campignrepo.save(camp);

		CampaignRedis campaignredis = new CampaignRedis();

		campaignredis.setCampaign_id(camp.getCampign_id());
		UUID campaign_id = campaignredis.getCampaign_id();
		String id_str = campaign_id.toString();

		campaignredis.setName(camp.getCampign_name());
		String name = campaignredis.getName();

		campaignredis.setAdvertiser_id(camp.getAdvertiser_id());
		UUID advertiser_id = campaignredis.getAdvertiser_id();
		String advertiser_id_str = advertiser_id.toString();

		campaignredis.setEnv_type(camp.getEnv_type());
		int env_type = campaignredis.getEnv_type();
		String env_type_str = Integer.toString(env_type);

		campaignredis.setBid_price(camp.getBid_price());
		double bid_price = campaignredis.getBid_price();
		String bid_price_str = Double.toString(bid_price);

		campaignredis.setDuration(camp.getDuration());
		String duration_str = campaignredis.getDuration();
		
		String auction_type_str=null;
		if(camp.getAuction_type()!=null) {
		campaignredis.setAuction_type(camp.getAuction_type());
		auction_type_str = campaignredis.getAuction_type();
		}

		String pricing_model_str = null;
		if (create.getPricing_model() != null) {
			campaignredis.setPricing_model(camp.getPricing_model());
			pricing_model_str = campaignredis.getPricing_model();
		}

		String deal_str = null;
		if (create.getDeal() != null) {
			campaignredis.setDeal(camp.getDeal());
			deal_str = campaignredis.getDeal();
		}

		String ssp_str =null;
		if(create.getSsp()!=null) {
			campaignredis.setSsp(camp.getSsp());
			ssp_str = campaignredis.getSsp();
		}
		String categories_str = null;
		if (camp.getCategories() != null) {
			campaignredis.setCategories_id(camp.getCategories());
			categories_str = campaignredis.getCategories_id();
		}

		String dayparty_str = null;
		if(camp.getDayparting()!=null) {
			campaignredis.setDayparty(camp.getDayparting());
			dayparty_str = campaignredis.getDayparty();
		}
		
		String impression_str = null;
		if (camp.getImpression_capping() != null) {
			campaignredis.setImpression_capping(camp.getImpression_capping());
			impression_str = campaignredis.getImpression_capping();
		}

		String pacing_str = null;
		if (camp.getPacing() != null) {
			campaignredis.setPacing(camp.getPacing());
			pacing_str = campaignredis.getPacing();
		}

		campaignredis.setCampaign_budget(camp.getCampaignBudget());
		double campaign_budget = campaignredis.getCampaign_budget();
		String campaign_budget_str = Double.toString(campaign_budget);

		campaignredis.setDaily_budget(camp.getDailyBudget());
		double daily_budget = campaignredis.getDaily_budget();
		String daily_budget_str = Double.toString(daily_budget);

		campaignredis.setStatus(camp.getStatus());
		int status = campaignredis.getStatus();
		String status_str = Integer.toString(status);

		campaignredis.setTotal_impression(camp.getTotal_impression());
		int total_impression = campaignredis.getTotal_impression();
		String total_impression_str = Integer.toString(total_impression);

		campaignredis.setDaliy_impression(camp.getDaily_impression());
		int daliy_impression = campaignredis.getDaliy_impression();
		String daily_impression_str = Integer.toString(daliy_impression);

		campaignredis.setCreated_at(camp.getCreated_at());
		LocalDateTime created_at = campaignredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = created_at.toString();

		arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		campaignredis.setCreated_by(camp.getCreated_by());
		UUID created_by = campaignredis.getCreated_by();
		String created_by_str = created_by.toString();

		campaignredis.setUpdated_at(camp.getUpdated_at());
		LocalDateTime updated_at = campaignredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = updated_at.toString();

		arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr);

		String key = "Campaign_" + camp.getCampign_id();
		Map<String, String> map = new HashMap<>();
		map.put("campaign_id", id_str);
		map.put("name", name);
		map.put("advertiser_id", advertiser_id_str);
		map.put("env_type", env_type_str);
		map.put("bid_price", bid_price_str);
		map.put("duration", duration_str);
		if (pricing_model_str != null) {
			map.put("pricing_model", pricing_model_str);
		}

		if(dayparty_str!=null) {
			map.put("dayparting", dayparty_str);
		}
		if (categories_str != null) {
			map.put("categories", categories_str);
		}
		if (deal_str != null) {
			map.put("deal", deal_str);
		}
		if(ssp_str!=null) {
			map.put("ssp", ssp_str);
		}
		if (impression_str != null) {
			map.put("impression_capping", impression_str);
		}
		if (pacing_str != null) {
			map.put("pacing", pacing_str);
		}
		if(auction_type_str!=null) {
			map.put("auction_type", auction_type_str);
		}
		map.put("total_budget", campaign_budget_str);
		map.put("daily_budget", daily_budget_str);
		map.put("total_impression", total_impression_str);
		map.put("daily_impression", daily_impression_str);
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);

		jedis.hmset(key, map);

		api.setData(camp);
		api.setMessage("Campign Created Successfully");
		api.setMsgCode("CAMPIGN CREATED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse Updatecampign(CampignUpdateDTO update, UUID campign_id) throws JsonProcessingException {
		APIResponse api = new APIResponse();

		Campign cam = campignrepo.findById(campign_id).orElse(null);
		if (cam == null) {
			ErrorObj err = new ErrorObj();
			err.setCode("Given Campaign Is Not Present In Database");
			api.setError(err);
			api.setMessage("Campaign Is Not Present");
			api.setMsgCode("CAMPAIGN IS NOT PRESENT");
			return api;
		}
		cam.setBid_price(update.getBid_price());
		cam.setCampaignBudget(update.getTotal_budget());
		cam.setAdvertiser_id(update.getAdvertiser_id());
		cam.setCampign_name(update.getCampign_name());
		cam.setStatus(1);
		cam.setImpression_capping(update.getImpression_capping());
		cam.setPacing(update.getPacing());
		cam.setEnv_type(update.getEnv_type());
		ObjectMapper mapper = new ObjectMapper();
		String srcstring = mapper.writeValueAsString(update.getDuration());
		cam.setDuration(srcstring);

		cam.setPricing_model(update.getPricing_model());
		String categoriedstr = mapper.writeValueAsString(update.getCategories());
		cam.setCategories(categoriedstr);

		String deal = mapper.writeValueAsString(update.getDeal());
		cam.setDeal(deal);
		
		String ssp = mapper.writeValueAsString(update.getSsp());
		cam.setSsp(ssp);
		
		String dayparty = mapper.writeValueAsString(update.getDayparting());
		cam.setDayparting(dayparty);

		
		String auction_type = mapper.writeValueAsString(update.getAuction_type());
		cam.setAuction_type(auction_type);

		cam.setUpdated_at(LocalDateTime.now());
		cam.setUpdated_by(update.getUpdated_by());
		cam.setDailyBudget(update.getDaily_budget());
		cam.setTotal_impression(update.getTotal_impression());
		cam.setDaily_impression(update.getDaily_impression());
		campignrepo.save(cam);

		CampaignRedis campaignredis = new CampaignRedis();

		campaignredis.setCampaign_id(cam.getCampign_id());
		UUID campaign_id = campaignredis.getCampaign_id();
		String id_str = campaign_id.toString();

		campaignredis.setName(cam.getCampign_name());
		String name = campaignredis.getName();

		campaignredis.setAdvertiser_id(cam.getAdvertiser_id());
		UUID advertiser_id = campaignredis.getAdvertiser_id();
		String advertiser_id_str = advertiser_id.toString();

		campaignredis.setEnv_type(cam.getEnv_type());
		int env_type = campaignredis.getEnv_type();
		String env_type_str = Integer.toString(env_type);

		campaignredis.setBid_price(cam.getBid_price());
		double bid_price = campaignredis.getBid_price();
		String bid_price_str = Double.toString(bid_price);

		campaignredis.setDuration(cam.getDuration());
		String duration_str = campaignredis.getDuration();
		
		String auction_type_str=null;
		if(cam.getAuction_type()!=null) {
		campaignredis.setAuction_type(cam.getAuction_type());
		auction_type_str = campaignredis.getAuction_type();
		}

		String pricing_model_str = null;
		if (update.getPricing_model() != null) {
			campaignredis.setPricing_model(cam.getPricing_model());
			pricing_model_str = campaignredis.getPricing_model();
		}

		String deal_str = null;
		if (cam.getDeal() != null) {
			campaignredis.setDeal(cam.getDeal());
			deal_str = campaignredis.getDeal();
		}
		
		String ssp_str =null;
		if(cam.getSsp()!=null) {
			campaignredis.setSsp(cam.getSsp());
			ssp_str = campaignredis.getSsp();
		}
		String categories_str = null;
		if (cam.getCategories() != null) {
			campaignredis.setCategories_id(cam.getCategories());
			categories_str = campaignredis.getCategories_id();
		}

		String impression_str = null;
		if (cam.getImpression_capping() != null) {
			campaignredis.setImpression_capping(cam.getImpression_capping());
			impression_str = campaignredis.getImpression_capping();
		}

		String pacing_str = null;
		if (cam.getPacing() != null) {
			campaignredis.setPacing(cam.getPacing());
			pacing_str = campaignredis.getPacing();
		}

		String dayparty_str = null;
		if(cam.getDayparting()!=null) {
			campaignredis.setDayparty(cam.getDayparting());
			dayparty_str = campaignredis.getDayparty();
		}

		campaignredis.setCampaign_budget(cam.getCampaignBudget());
		double campaign_budget = campaignredis.getCampaign_budget();
		String campaign_budget_str = Double.toString(campaign_budget);

		campaignredis.setDaily_budget(cam.getDailyBudget());
		double daily_budget = campaignredis.getDaily_budget();
		String daily_budget_str = Double.toString(daily_budget);

		campaignredis.setStatus(cam.getStatus());
		int status = campaignredis.getStatus();
		String status_str = Integer.toString(status);

		campaignredis.setTotal_impression(cam.getTotal_impression());
		int total_impression = campaignredis.getTotal_impression();
		String total_impression_str = Integer.toString(total_impression);

		campaignredis.setDaliy_impression(cam.getDaily_impression());
		int daliy_impression = campaignredis.getDaliy_impression();
		String daily_impression_str = Integer.toString(daliy_impression);

		campaignredis.setCreated_at(cam.getCreated_at());
		LocalDateTime created_at = campaignredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = created_at.toString();

		arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		campaignredis.setCreated_by(cam.getCreated_by());
		UUID created_by = campaignredis.getCreated_by();
		String created_by_str = created_by.toString();

		campaignredis.setUpdated_at(cam.getUpdated_at());
		LocalDateTime updated_at = campaignredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = updated_at.toString();

		arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr);

		campaignredis.setUpdated_by(cam.getUpdated_by());
		UUID updated_by = campaignredis.getUpdated_by();
		String updated_by_str = updated_by.toString();

		String key = "Campaign_" + cam.getCampign_id();
		Map<String, String> map = new HashMap<>();
		map.put("campaign_id", id_str);
		map.put("name", name);
		map.put("advertiser_id", advertiser_id_str);
		map.put("env_type", env_type_str);
		map.put("bid_price", bid_price_str);
		map.put("duration", duration_str);
		if (pricing_model_str != null) {
			map.put("pricing_model", pricing_model_str);
		}
		if (deal_str != null) {
			map.put("deal", deal_str);
		}
		if(ssp_str!=null) {
			map.put("ssp", ssp_str);
		}
		if (categories_str != null) {
			map.put("categories", categories_str);
		}
		if (impression_str != null) {
			map.put("impression_capping", impression_str);
		}
		if (pacing_str != null) {
			map.put("pacing", pacing_str);
		}
		if(auction_type_str!=null) {
			map.put("auction_type", auction_type_str);
		}
		if(dayparty_str!=null) {
			map.put("dayparting", dayparty_str);
		}
		map.put("total_budget", campaign_budget_str);
		map.put("daily_budget", daily_budget_str);
		map.put("total_impression", total_impression_str);
		map.put("daily_impression", daily_impression_str);
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);
		map.put("updated_by", updated_by_str);

		jedis.hmset(key, map);

		api.setData(cam);
		api.setMessage("Campign Updated successfully");
		api.setMsgCode("CAMPIGN UPDATED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse blockCampign(UUID campign_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Campign camp = campignrepo.findById(campign_id).orElse(null);
		if (camp == null) {
			err.setCode("Given Campaign Is Not Present In Database");
			api.setError(err);
			api.setMessage("Campaign Is Not Present");
			api.setMsgCode("CAMPAIGN IS NOT PRESENT");
			return api;
		}
		if (camp.getIs_deleted() == 1) {
			err.setCode("Cannot Block The Deleted Campaign");
			api.setError(err);
			api.setMessage("Deleted Campaign Cannot Be Blocked");
			api.setMsgCode("DELETED CAMPAIGN CANNOT BE BLOCKED");
			return api;
		}
		if (camp.getStatus() == 0) {
			err.setCode("Given Campaign Is Already InActive");
			api.setError(err);
			api.setMessage("Campaign Is Already Blocked");
			api.setMsgCode("CAMPAIGN IS ALREADY BLOCKED");
			return api;
		}
		camp.setStatus(0);
		campignrepo.save(camp);

		CampaignRedis campaignredis = new CampaignRedis();

		campaignredis.setStatus(camp.getStatus());
		int status = campaignredis.getStatus();
		String status_str = Integer.toString(status);

		String key = "Campaign_" + camp.getCampign_id();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);

		jedis.hmset(key, map);

		api.setMessage("Campign Blocked Successfully");
		api.setMsgCode("CAMPIGN BLOCKED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse UnblockCampign(UUID campign_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Campign camp = campignrepo.findById(campign_id).orElse(null);
		if (camp == null) {
			err.setCode("Given Campaign Is Not Present In Database");
			api.setError(err);
			api.setMessage("Campaign Is Not Present");
			api.setMsgCode("Campaign Is Not Present");
			return api;
		}
		if (camp.getIs_deleted() == 1) {
			err.setCode("Cannot Unblocked The Deleted Campaign");
			api.setError(err);
			api.setMessage("Delected Campaign Cannot Be UnBlocked");
			api.setMsgCode("DELECTED CAMPAIGN CANNOT BE UNBLOCKED");
			return api;
		}
		if (camp.getStatus() == 1) {
			err.setCode("Given Campaign Is Already Active");
			api.setError(err);
			api.setMessage("Camapign Is Already UnBlocked");
			api.setMsgCode("CAMPAIGN IS ALREADY UNBLOCKED");
			return api;
		}
		camp.setStatus(1);
		campignrepo.save(camp);

		CampaignRedis campaignredis = new CampaignRedis();

		campaignredis.setStatus(camp.getStatus());
		int status = campaignredis.getStatus();
		String status_str = Integer.toString(status);

		String key = "Campaign_" + camp.getCampign_id();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);

		jedis.hmset(key, map);

		api.setMessage("Campign UnBlocked Successfully");
		api.setMsgCode("CAMPIGN UNBLOCKED SUCCESSFULLY");
		return api;

	}

	@Override
	public APIResponse deleteCampign(CampignDeleteDTO delete) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Campign camp = campignrepo.findById(delete.getCampign_id()).orElse(null);
		if (camp == null) {
			err.setCode("Given Campaign Is Not Present In Database");
			api.setError(err);
			api.setMessage("Campaign Is Not Present");
			api.setMsgCode("CAMPAIGN IS NOT PRESENT");
			return api;
		}
		if (camp.getIs_deleted() == 1) {
			err.setCode("Cannot Delete The Deleted Campaign");
			api.setError(err);
			api.setMessage("Campaign Is Already Deleted");
			api.setMsgCode("CAMPAIGN IS ALREADY DELETED");
			return api;
		}
		camp.setIs_deleted(1);
		camp.setDeleted_at(LocalDateTime.now());
		camp.setDeleted_by(delete.getDeleted_by());
		campignrepo.save(camp);

		CampaignRedis campaignredis = new CampaignRedis();

		campaignredis.setIs_deleted(camp.getIs_deleted());
		int is_deleted = campaignredis.getIs_deleted();
		String is_deleted_str = Integer.toString(is_deleted);

		campaignredis.setDeleted_at(camp.getDeleted_at());
		LocalDateTime deleted_at = campaignredis.getDeleted_at();

		String[] arr1 = new String[2];

		arr1[0] = deleted_at.toString();

		arr1[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String deleted_at_str = Arrays.toString(arr1);

		campaignredis.setDeleted_by(camp.getDeleted_by());
		UUID deleted_by = campaignredis.getDeleted_by();
		String deleted_by_str = deleted_by.toString();

		String key = "Campaign_" + camp.getCampign_id();
		Map<String, String> map = new HashMap<>();
		map.put("is_deleted", is_deleted_str);
		map.put("deleted_at", deleted_at_str);
		map.put("deleted_by", deleted_by_str);

		jedis.hmset(key, map);

		api.setMessage("Campign Deleted Successfully");
		api.setMsgCode("CAMPIGN DELETED SUCCESSFULLY");
		return api;

	}

	@Override
	public APIResponse getbyid(UUID campign_id) {
		APIResponse api = new APIResponse();
		Campign camp = campignrepo.findById(campign_id).orElse(null);
		CampignResponseDTO cam = MapToDto(camp);
		api.setData(cam);
		api.setMessage("Campign get Successfully");
		api.setMsgCode("CAMPIGN GET SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getall() {
		APIResponse api = new APIResponse();

		List<Campign> cam = campignrepo.findAll();
		List<CampignResponseDTO> camp = cam.stream().map(use -> MapToDto(use)).collect(Collectors.toList());
		api.setData(camp);
		api.setMessage("Campign List Get Successfully");
		api.setMsgCode("CAMPIGN LIST GET SUCCESSFULLY");
		return api;
	}

	private CampignResponseDTO MapToDto(Campign camp) {
		CampignResponseDTO response = new CampignResponseDTO();
		response.setCampign_id(camp.getCampign_id());
		response.setCampign_name(camp.getCampign_name());
		response.setDayparting(camp.getDayparting());

		Advertriser ad = addrepo.findById(camp.getAdvertiser_id()).orElse(null);
		response.setAdvertiser_id(camp.getAdvertiser_id());
		response.setAdvertiser_name(ad.getAdvertiser_name());
		response.setBid_price(camp.getBid_price());
		response.setTotal_budget(camp.getCampaignBudget());
		response.setDaliy_budget(camp.getDailyBudget());
		response.setTotal_impression(camp.getTotal_impression());
		response.setDaily_impression(camp.getDaily_impression());
		response.setImpression_capping(camp.getImpression_capping());
		response.setPacing(camp.getPacing());
		response.setDuration(camp.getDuration());
		response.setPricing_model(camp.getPricing_model());
		response.setCategories(camp.getCategories());
		response.setAuction_type(camp.getAuction_type());

		Environment env = envrepo.findById(camp.getEnv_type()).orElse(null);
		response.setEnv_type(env.getName());
		response.setEnv_id(camp.getEnv_type());
		response.setDeal(camp.getDeal());
		response.setSsp(camp.getSsp());

		List<Configurations> allObj = configRepo.findAll();
		Configurations config = allObj.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(config.getConfigValue());
		String arr = newYorkDateFormatter.format(ZonedDateTime.of(camp.getCreated_at(), ZoneId.of("UTC-4")));
		response.setCreated_at(arr);
		response.setCreated_by(camp.getCreated_by());

		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(camp.getUpdated_at(), ZoneId.of("UTC-4")));
		response.setUpdated_at(arr1);
		response.setUpdated_by(camp.getUpdated_by());

		if (camp.getDeleted_at() != null) {
			String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(camp.getDeleted_at(), ZoneId.of("UTC-4")));
			response.setDeleted_at(arr2);
		}
		response.setIs_deleted(camp.getIs_deleted());
		response.setDeleted_by(camp.getDeleted_by());

		if (camp.getStatus() == 0) {
			response.setStatus("InActive");
		} else if (camp.getStatus() == 1) {
			response.setStatus("Active");
		}
		return response;

	}

	@Override
	public FilterResponse list(CampignFilterRequest filter) {
		FilterResponse api = new FilterResponse();

		String field = null, order = null;
		if (filter.getSort() != null && filter.getSort().size() == 1) {
			for (Map.Entry m : filter.getSort().entrySet()) {
				field = (String) m.getKey();
				order = (String) m.getValue();
			}
		} else {

		}

		PageDetails pageing = filter.getPages();
		Pageable pageable = null;

		if (filter.getFilter() == null && filter.getPages() == null) {

			List<Campign> campign = null;
			List<CampignResponseDTO> dto = null;
			campign = campignrepo.findAll();
			dto = campign.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			api.setData(dto);
			return api;
		}

		if (filter.getPages() == null) {
			PageDetails pageing2 = new PageDetails();

			pageable = null;

			List<Campign> campign = null;
			List<CampignResponseDTO> dto = null;
			int ResponseCount;
			campign = campignrepo.findAll();
			dto = campign.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			CampignFilterEntity campignFilter = filter.getFilter();
			List<UUID> CampignIdList = campign.stream().map(camp -> camp.getCampign_id()).collect(Collectors.toList());
			List<Campign> filteredList = campignrepo.getallDetails(campignFilter.getName(),campignFilter.getAuction_type(),
					campignFilter.getAdvertiser_id(), campignFilter.getCategories_id(), campignFilter.getEnv_type(),
					campignFilter.getStatus(), campignFilter.getStatus(), CampignIdList);
			List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getCampign_id())
					.collect(Collectors.toList());
			ResponseCount = campignrepo.getResultCount(filteredIdList);
			if (ResponseCount == 0) {
				ResponseCount = 10;
			}
			if (filter.getSort() == null || filter.getSort().size() == 0) {

				pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));
			} else {
				if (field.equals("") || order.equals("")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));

				}

				else if (order.equalsIgnoreCase("asc")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field).descending());
				}
			}

			List<Campign> campignListWithPage = campignrepo.getFilteredListwithoutPage(filteredIdList, pageable)
					.getContent();
			dto = campignListWithPage.stream().map(CampignRes -> MapToDto(CampignRes)).collect(Collectors.toList());

			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageSize(10);
			pageRes.setTotalCount(ResponseCount);
			api.setPage(pageRes);
			api.setData(dto);
			return api;
		}
		List<CampignResponseDTO> CampignResList = null;

		// set 2 if filterRequest Page details not null

		int ResponseCount = 0;
		if (filter.getFilter() == null) {
			Page<Campign> campign = null;
			campign = campignrepo.findAll(pageable);

			List<UUID> CampignIdList = campign.stream().map(camUni -> camUni.getCampign_id())
					.collect(Collectors.toList());
			ResponseCount = campignrepo.getResultCount(CampignIdList);
			campign = campignrepo.getFilteredListwithoutPage(CampignIdList, pageable);

			List<Campign> ResContent = campign.getContent();
			CampignResList = ResContent.stream().map(campignunitRes -> MapToDto(campignunitRes))
					.collect(Collectors.toList());
			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageCount(pageing.getPageIndex());
			if (pageing.getPageSize() == 0) {
				pageRes.setPageSize(10);
			} else {
				pageRes.setPageSize(pageing.getPageSize());
			}
			api.setData(CampignResList);
			api.setPage(pageRes);
			api.setMessage("CampaignList_With_Filter_2");
			api.setMsgCode("CAMPAIGNLIST_WITH_FILTER_2");
			return api;
		}

		if (filter.getSort() == null || filter.getSort().size() == 0) {
			if (pageing.getPageSize() == 0) {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
			} else {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by("name"));
			}
		} else {
			if (field.equals("") || order.equals("")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by("name"));
				}
			}

			else if (order.equalsIgnoreCase("asc")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by(field));
				}
			} else {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field).descending());
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by(field).descending());
				}
			}
		}

		List<Campign> campign = null;
		campign = campignrepo.findAll();

		CampignFilterEntity campignFilter = filter.getFilter();
		List<UUID> campignIdList = campign.stream().map(cam -> cam.getCampign_id()).collect(Collectors.toList());
		List<Campign> filteredList = campignrepo.getallDetails(campignFilter.getName(),campignFilter.getAuction_type(),
				campignFilter.getAdvertiser_id(), campignFilter.getCategories_id(), campignFilter.getEnv_type(),
				campignFilter.getStatus(), campignFilter.getIs_deleted(), campignIdList);
		List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getCampign_id()).collect(Collectors.toList());
		ResponseCount = campignrepo.getResultCount(filteredIdList);
		List<Campign> campignFilteredContent = campignrepo.getFilteredList(filteredIdList, pageable).getContent();
		CampignResList = campignFilteredContent.stream().map(campignRes -> MapToDto(campignRes))
				.collect(Collectors.toList());

		PageResponse pageRes = new PageResponse();
		pageRes.setTotalCount(ResponseCount);
		pageRes.setPageCount(pageing.getPageIndex());
		if (pageing.getPageSize() == 0) {
			pageRes.setPageSize(10);
		} else {
			pageRes.setPageSize(pageing.getPageSize());
		}
		api.setData(CampignResList);
		api.setPage(pageRes);
		api.setMessage("Filtered List of Campaign");
		api.setMsgCode("FILTERED_LIST_OF_CAMPAIGN");

		return api;

	}

}
