package com.example.demo.service.impl;

import java.util.List;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.CampaignTargetCreateDTO;
import com.example.demo.entity.CampaignTarget;
import com.example.demo.redisentity.CampaignTargetRedis;
import com.example.demo.repository.CampaignTargetRepo;
import com.example.demo.service.CampaignTargetService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import redis.clients.jedis.Jedis;

@Service
public class CampaignTargetServiceImpl implements CampaignTargetService {

	@Autowired
	private CampaignTargetRepo repo;

	@Autowired
	private Jedis jedis;

	@Override
	public APIResponse savetarget(CampaignTargetCreateDTO create) throws JsonProcessingException {
		APIResponse api = new APIResponse();
		CampaignTarget target = repo.findbycampaign_id(create.getCampaign_id());
		if (target == null) {
			CampaignTarget campaigntarget = new CampaignTarget();

			campaigntarget.setCampaign_id(create.getCampaign_id());

			ObjectMapper mapper = new ObjectMapper();
			String targ_data = mapper.writeValueAsString(create.getTargetData());
			campaigntarget.setTarget_data(targ_data);
			repo.save(campaigntarget);

			CampaignTargetRedis redis = new CampaignTargetRedis();

			redis.setTarget_data(campaigntarget.getTarget_data());
			String target_data = redis.getTarget_data();

			String key = "targetData_" + campaigntarget.getCampaign_id();
			jedis.set(key, target_data);

			api.setData(campaigntarget);
			api.setMessage("Campaign_Target_Created_Successfully");
			api.setMsgCode("CAMPAIGN_TARGET_CREATED_SUCCESSFULLY");
			return api;
		} else {
			target.setCampaign_id(create.getCampaign_id());

			ObjectMapper mapper = new ObjectMapper();
			String targerData = mapper.writeValueAsString(create.getTargetData());
			target.setTarget_data(targerData);

			repo.save(target);

			CampaignTargetRedis redis = new CampaignTargetRedis();

			redis.setTarget_data(target.getTarget_data());
			String target_data = redis.getTarget_data();

			String key = "targetData_" + target.getCampaign_id();
			jedis.set(key, target_data);

			api.setData(target);
			api.setMessage("Campaign_Target_Updated_Successfully");
			api.setMsgCode("CAMPAIGN_TARGET_UPDATED_SUCCESSFULLY");
			return api;
		}
	}

	@Override
	public APIResponse getall() {
		APIResponse api = new APIResponse();
		List<CampaignTarget> target = repo.findAll();

		api.setData(target);
		api.setMessage("List_Of_Campaign_Target");
		api.setMsgCode("LIST_OF_CAMPAIGN_TARGET");
		return api;
	}

	@Override
	public APIResponse listbyId(UUID campaign_id) {

		APIResponse api = new APIResponse();

		CampaignTarget target = repo.findbycampaign_id(campaign_id);

		api.setData(target);
		api.setMessage("Campaign_Target_Get_Successfully");
		api.setMsgCode("CAMPAIGN_TARGET_GET_SUCCESSFULLY");
		return api;
	}

}
