package com.example.demo.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.entity.BannerSize;
import com.example.demo.repository.BannerSizeRepo;
import com.example.demo.service.BannerSizeService;

@Service
public class BannerSizeIMPL implements BannerSizeService {

	@Autowired
	private BannerSizeRepo repo;

	public APIResponse getAllBannerSize() {
		APIResponse api = new APIResponse();
		List<BannerSize> list = repo.orderBySize_name();
		api.setData(list);
		api.setMessage("banner_size_list");
		api.setMsgCode("BANNER_SIZE_LIST");
		return api;
	}
}
