package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.common.FilterResponse;
import com.example.demo.common.PageDetails;
import com.example.demo.common.PageResponse;
import com.example.demo.dto.AdvertiserCreateResponseDTO;
import com.example.demo.dto.AdvertiserDeleteDTO;
import com.example.demo.dto.AdvertiserResponseDTO;
import com.example.demo.dto.AdvertriserCreateDTO;
import com.example.demo.dto.AdvertriserFilterRequest;
import com.example.demo.dto.AdvertriserUpdateDTO;
import com.example.demo.entity.Advertriser;
import com.example.demo.entity.AdvertriserFilterEntity;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.ManageUser;
import com.example.demo.entity.Roles;
import com.example.demo.redisentity.AdvertiserRedis;
import com.example.demo.repository.AdvertriserRepo;
import com.example.demo.repository.CampignRepository;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.ManageUserRepository;
import com.example.demo.repository.RolesRepository;
import com.example.demo.service.AdvertriserService;

import redis.clients.jedis.Jedis;

@Service
public class AdvertriserServiceImpl implements AdvertriserService {

	@Autowired
	private AdvertriserRepo repo;

	@Autowired
	private ManageUserRepository userrepo;

	@Autowired
	private CampignRepository campignrepo;

	@Autowired
	private ConfigurationRepo configrepo;

	@Autowired
	private RolesRepository rolerepo;

	@Autowired
	private Jedis jedis;

	@Autowired
	PasswordEncoder passencoder;

	@Override
	public APIResponse CreateAdvertriser(AdvertriserCreateDTO dto) {
		APIResponse api = new APIResponse();
		if (!dto.getPwd_hash().equals(dto.getConfirmPassword())) {
			ErrorObj error = new ErrorObj();
			error.setCode("Password are not same");
			api.setError(error);
			api.setMessage("Password and confirmpassword are not same");
			api.setMsgCode("PASSWORD AND CONFIRMPASSWORD ARE NOT SAME");
			return api;
		}
		Advertriser ad = repo.findbyemail(dto.getEmail());
		ManageUser user = userrepo.findbyemail(dto.getEmail());
		if (ad != null || user != null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Email already exists");
			api.setError(error);
			api.setMessage("Email Already Exists");
			api.setMsgCode("EMAIL ALREADY EXISTS");
			return api;
		}

		Advertriser add = new Advertriser();
		add.setAdvertiser_name(dto.getName());
		add.setEmail(dto.getEmail());
		add.setStatus(1);
		add.setCreated_at(LocalDateTime.now());
		add.setCreated_by(dto.getCreated_by());
		add.setUpdated_at(LocalDateTime.now());
		repo.save(add);

		AdvertiserRedis advertiser = new AdvertiserRedis();

		advertiser.setAdvertiser_id(add.getAdvertiser_id());
		UUID id = advertiser.getAdvertiser_id();
		String id_str = id.toString();

		advertiser.setAdvertiser_name(add.getAdvertiser_name());
		String name_str = advertiser.getAdvertiser_name();

		advertiser.setEmail(add.getEmail());
		String email_str = advertiser.getEmail();

		advertiser.setStatus(add.getStatus());
		int status = advertiser.getStatus();
		String status_str = Integer.toString(status);

		advertiser.setCreated_by(add.getCreated_by());
		UUID created_by = advertiser.getCreated_by();
		String created_by_str = created_by.toString();

		advertiser.setCreated_at(add.getCreated_at());
		LocalDateTime now = advertiser.getCreated_at();

		String[] arr = new String[2];

		arr[0] = now.toString();

		arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		advertiser.setUpdated_at(add.getUpdated_at());
		LocalDateTime update_at = advertiser.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = update_at.toString();

		arr1[1] = update_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr1);

		String key = "Advertiser_" + add.getAdvertiser_id();
		Map<String, String> map = new HashMap<>();
		map.put("advertiser_id", id_str);
		map.put("name", name_str);
		map.put("email", email_str);
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);

		jedis.hmset(key, map);

		ManageUser use = new ManageUser();
		use.setName(add.getAdvertiser_name());
		use.setId(add.getAdvertiser_id());
		use.setEmail(add.getEmail());
		use.setPassword(passencoder.encode(dto.getPwd_hash()));
		use.setRoleid(dto.getAccountType());
		use.setStatus(1);
		use.setCreated_at(LocalDateTime.now());
		use.setCreated_by(dto.getCreated_by());
		use.setUpdated_at(LocalDateTime.now());
		userrepo.save(use);

		AdvertiserCreateResponseDTO dto1 = new AdvertiserCreateResponseDTO();
		dto1.setAdvertriser_id(add.getAdvertiser_id());
		dto1.setUser_id(use.getId());

		api.setData(dto1);
		api.setMessage("Advertriser Created Successfully");
		api.setMsgCode("ADVERTRISER_CREATED_SUCCESSFuLLY");
		return api;
	}

	@Override
	public APIResponse UpdateAdvertriser(AdvertriserUpdateDTO dto, UUID advertriser_id) {
		APIResponse api = new APIResponse();
		if (!dto.getPwd_hash().equals(dto.getConfirmPassword())) {
			ErrorObj error = new ErrorObj();
			error.setCode("Password are not same");
			api.setError(error);
			api.setMessage("Password and confirmpassword are not same");
			api.setMsgCode("PASSWORD AND CONFIRMPASSWORD ARE NOT SAME");
			return api;
		}
		Advertriser add = repo.findById(advertriser_id).orElse(null);
		if (add == null) {
			ErrorObj error = new ErrorObj();
			error.setCode("Advertriser is not in db");
			api.setError(error);
			api.setMessage("Advertriser is not Present");
			api.setMsgCode("Advertrtiser is not Present");
			return api;
		}
		add.setEmail(dto.getEmail());
		add.setAdvertiser_name(dto.getName());
		add.setUpdated_at(LocalDateTime.now());
		add.setUpdated_by(dto.getUpdated_by());

		repo.save(add);
		AdvertiserRedis advertiser = new AdvertiserRedis();

		advertiser.setAdvertiser_id(add.getAdvertiser_id());
		UUID id = advertiser.getAdvertiser_id();
		String id_str = id.toString();

		advertiser.setAdvertiser_name(add.getAdvertiser_name());
		String name_str = advertiser.getAdvertiser_name();

		advertiser.setEmail(add.getEmail());
		String email_str = advertiser.getEmail();

		advertiser.setStatus(add.getStatus());
		int status = advertiser.getStatus();
		String status_str = Integer.toString(status);

		advertiser.setCreated_by(add.getCreated_by());
		UUID created_by = advertiser.getCreated_by();
		String created_by_str = created_by.toString();

		advertiser.setCreated_at(add.getCreated_at());
		LocalDateTime now = advertiser.getCreated_at();

		String[] arr = new String[2];

		arr[0] = now.toString();

		arr[1] = now.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		advertiser.setUpdated_at(add.getUpdated_at());
		LocalDateTime update_at = advertiser.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = update_at.toString();

		arr1[1] = update_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr1);

		advertiser.setUpdated_by(add.getUpdated_by());
		UUID updated_by = advertiser.getUpdated_by();
		String updated_by_str = updated_by.toString();

		String key = "Advertiser_" + add.getAdvertiser_id();
		Map<String, String> map = new HashMap<>();
		map.put("advertiser_id", id_str);
		map.put("name", name_str);
		map.put("email", email_str);
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);
		map.put("updated_by", updated_by_str);

		jedis.hmset(key, map);

		ManageUser use = userrepo.findById(advertriser_id).orElse(null);
		use.setName(add.getAdvertiser_name());
		use.setId(add.getAdvertiser_id());
		use.setEmail(add.getEmail());
		use.setPassword(passencoder.encode(dto.getPwd_hash()));
		use.setStatus(1);
		use.setUpdated_at(LocalDateTime.now());
		use.setUpdated_by(dto.getUpdated_by());

		userrepo.save(use);

		api.setData(add);
		api.setMessage("Advertiser Updated Successfully");
		api.setMsgCode("ADVERTISER UPDATED SUCCESSFULLY");
		return api;
	}

	@Override
	public FilterResponse list(AdvertriserFilterRequest filter, UUID user_id) {
		FilterResponse api = new FilterResponse();

		String field = null, order = null;
		if (filter.getSort() != null && filter.getSort().size() == 1) {
			for (Map.Entry m : filter.getSort().entrySet()) {
				field = (String) m.getKey();
				order = (String) m.getValue();
			}
		} else {

		}

		PageDetails pageing = filter.getPages();
		Pageable pageable = null;

		if (filter.getFilter() == null && filter.getPages() == null) {

			List<Advertriser> advertiser = null;
			List<AdvertiserResponseDTO> dto = null;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				advertiser = repo.findAll();
			} else if (role.getRoletype().equals("ADVERTISER")) {
				advertiser = repo.findbyadvertriser(user_id);
			}
			dto = advertiser.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			api.setData(dto);
			api.setMessage("List_Of_Advertiser");
			api.setMsgCode("LIST_OF_ADVERTISER");
			return api;
		}

		if (filter.getPages() == null) {
			PageDetails pageing2 = new PageDetails();

			pageable = null;

			List<Advertriser> advertiser = null;
			List<AdvertiserResponseDTO> dto = null;
			int ResponseCount;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				advertiser = repo.findAll();
			} else if (role.getRoletype().equals("ADVERTISER")) {
				advertiser = repo.findbyadvertriser(user_id);
			}
			dto = advertiser.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			AdvertriserFilterEntity campignFilter = filter.getFilter();
			List<UUID> advertiserIdList = advertiser.stream().map(camp -> camp.getAdvertiser_id())
					.collect(Collectors.toList());
			List<Advertriser> filteredList = repo.getallDetails(campignFilter.getName(), campignFilter.getPaymenttype(),
					campignFilter.getStatus(), campignFilter.getIs_deleted(), advertiserIdList);
			List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getAdvertiser_id())
					.collect(Collectors.toList());
			ResponseCount = repo.getResultCount(filteredIdList);
			if (ResponseCount == 0) {
				ResponseCount = 10;
			}
			if (filter.getSort() == null || filter.getSort().size() == 0) {

				pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("advertiser_name"));
			} else {
				if (field.equals("") || order.equals("")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("advertiser_name"));

				}

				else if (order.equalsIgnoreCase("asc")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field).descending());
				}
			}

			List<Advertriser> campignListWithPage = repo.getFilteredListwithoutPage(filteredIdList, pageable)
					.getContent();
			dto = campignListWithPage.stream().map(CampignRes -> MapToDto(CampignRes)).collect(Collectors.toList());

			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageSize(10);
			pageRes.setTotalCount(ResponseCount);
			api.setPage(pageRes);
			api.setData(dto);
			return api;
		}
		List<AdvertiserResponseDTO> CampignResList = null;

		// set 2 if filterRequest Page details not null

		int ResponseCount = 0;
		if (filter.getFilter() == null) {
			Page<Advertriser> advertiser = null;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				advertiser = repo.findAll(pageable);
			} else if (role.getRoletype().equals("ADVERTISER")) {
				advertiser = repo.findbyadvertriser_id(user_id, pageable);
			}

			List<UUID> CampignIdList = advertiser.stream().map(camUni -> camUni.getAdvertiser_id())
					.collect(Collectors.toList());
			ResponseCount = repo.getResultCount(CampignIdList);
			advertiser = repo.getFilteredListwithoutPage(CampignIdList, pageable);

			List<Advertriser> ResContent = advertiser.getContent();
			CampignResList = ResContent.stream().map(campignunitRes -> MapToDto(campignunitRes))
					.collect(Collectors.toList());
			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageCount(pageing.getPageIndex());
			if (pageing.getPageSize() == 0) {
				pageRes.setPageSize(10);
			} else {
				pageRes.setPageSize(pageing.getPageSize());
			}
			api.setData(CampignResList);
			api.setPage(pageRes);
			api.setMessage("AdvertiserList_With_Filter_2");
			api.setMsgCode("ADVERTISERLIST_WITH_FILTER_2");
			return api;
		}

		if (filter.getSort() == null || filter.getSort().size() == 0) {
			if (pageing.getPageSize() == 0) {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("advertiser_name"));
			} else {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
						Sort.by("advertiser_name"));
			}
		} else {
			if (field.equals("") || order.equals("")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("advertiser_name"));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by("advertiser_name"));
				}
			}

			else if (order.equalsIgnoreCase("asc")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by(field));
				}
			} else {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field).descending());
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by(field).descending());
				}
			}
		}

		List<Advertriser> advertiser = null;
		ManageUser user = userrepo.findById(user_id).orElse(null);
		Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
		if (role.getRoletype().equals("MASTER_ADMIN")) {
			advertiser = repo.findAll();
		} else if (role.getRoletype().equals("ADVERTISER")) {
			advertiser = repo.findbyadvertriser(user_id);
		}

		AdvertriserFilterEntity campignFilter = filter.getFilter();
		List<UUID> campignIdList = advertiser.stream().map(cam -> cam.getAdvertiser_id()).collect(Collectors.toList());
		List<Advertriser> filteredList = repo.getallDetails(campignFilter.getName(), campignFilter.getPaymenttype(),
				campignFilter.getStatus(), campignFilter.getIs_deleted(), campignIdList);
		List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getAdvertiser_id())
				.collect(Collectors.toList());
		ResponseCount = repo.getResultCount(filteredIdList);
		List<Advertriser> campignFilteredContent = repo.getFilteredList(filteredIdList, pageable).getContent();
		CampignResList = campignFilteredContent.stream().map(campignRes -> MapToDto(campignRes))
				.collect(Collectors.toList());

		PageResponse pageRes = new PageResponse();
		pageRes.setTotalCount(ResponseCount);
		pageRes.setPageCount(pageing.getPageIndex());
		if (pageing.getPageSize() == 0) {
			pageRes.setPageSize(10);
		} else {
			pageRes.setPageSize(pageing.getPageSize());
		}
		api.setData(CampignResList);
		api.setPage(pageRes);
		api.setMessage("Filtered List of Advertiser");
		api.setMsgCode("FILTERED_LIST_OF_ADVERTISER");

		return api;
	}

	private AdvertiserResponseDTO MapToDto(Advertriser ad) {
		AdvertiserResponseDTO response = new AdvertiserResponseDTO();
		response.setAdvertiser_id(ad.getAdvertiser_id());
		response.setName(ad.getAdvertiser_name());
		response.setEmail(ad.getEmail());
		response.setTotal_balance(ad.getTotal_balance());
		response.setDeposite_amount(ad.getDeposite_amount());
		response.setTotalCampign(campignrepo.count(ad.getAdvertiser_id()));
		List<Configurations> allconfig = configrepo.findAll();
		Configurations obj = allconfig.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(obj.getConfigValue());
		String arr = newYorkDateFormatter.format(ZonedDateTime.of(ad.getCreated_at(), ZoneId.of("UTC-4")));
		response.setCreated_at(arr);

		response.setCreated_by(ad.getCreated_by());
		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(ad.getUpdated_at(), ZoneId.of("UTC-4")));
		response.setUpdated_at(arr1);
		response.setUpdated_by(ad.getUpdated_by());

		if (ad.getDeleted_at() != null) {
			String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(ad.getDeleted_at(), ZoneId.of("UTC-4")));
			response.setDeleted_at(arr2);
		}
		response.setIs_deleted(ad.getIs_deleted());
		response.setDeleted_by(ad.getDeleted_by());
		if (ad.getStatus() == 0) {
			response.setStatus("InActive");
		} else if (ad.getStatus() == 1) {
			response.setStatus("Active");
		}
		return response;
	}

	@Override
	public APIResponse blockAdvertiser(UUID advertiser_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Advertriser adver = repo.findById(advertiser_id).orElse(null);
		if (adver == null) {
			err.setCode("Given Advertiser Is Not Present In Database");
			api.setError(err);
			api.setMessage("Advertiser IS Not Present");
			api.setMsgCode("ADVERTISER IS NOT PRESENT");
			return api;
		}
		if (adver.getIs_deleted() == 1) {
			err.setCode("Cannot Block The Deleted Advertiser");
			api.setError(err);
			api.setMessage("Deleted Advertiser Cannot be Blocked");
			api.setMsgCode("DELETED ADVERTISER CANNOT BE BLOCKED");
			return api;
		}
		if (adver.getStatus() == 0) {
			err.setCode("Given Advertiser Is Already InActive");
			api.setError(err);
			api.setMessage("Advertiser Is Already Blocked");
			api.setMsgCode("ADVERTISER Is ALREADY BLOCKED");
			return api;
		}
		adver.setStatus(0);
		repo.save(adver);

		AdvertiserRedis redis = new AdvertiserRedis();

		redis.setStatus(adver.getStatus());
		int status = redis.getStatus();
		String status_str = Integer.toString(status);

		String key = "Advertiser_" + adver.getAdvertiser_id();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);

		jedis.hmset(key, map);

		ManageUser user = userrepo.findByUserid(adver.getAdvertiser_id());
		user.setStatus(0);
		userrepo.save(user);

		api.setMessage("Advertiser Blocked Successfully");
		api.setMsgCode("ADVERTISER BLOCKED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse UnblockAdvertiser(UUID advertiser_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Advertriser adver = repo.findById(advertiser_id).orElse(null);
		if (adver == null) {
			err.setCode("Given Adveertiser Is Not Present In Database");
			api.setError(err);
			api.setMessage("Advertiser Is Not Present");
			api.setMsgCode("ADVERTISER IS NOT PRESENT");
			return api;
		}
		if (adver.getIs_deleted() == 1) {
			err.setCode("Cannot UnBlock The Deleted Advertiser");
			api.setError(err);
			api.setMessage("Deleted Advertiser Cannot be Unblocked");
			api.setMsgCode("DELETED ADVERTISER CANNOT BE UNBLOCKED");
			return api;
		}
		if (adver.getStatus() == 1) {
			err.setCode("Advertiser Is Already Active");
			api.setError(err);
			api.setMessage("Advertiser Is Already Unblocked");
			api.setMsgCode("ADVERTISER IS ALREADY UNBLOCKED");
			return api;
		}
		adver.setStatus(1);
		repo.save(adver);

		AdvertiserRedis redis = new AdvertiserRedis();

		redis.setStatus(adver.getStatus());
		int status = redis.getStatus();
		String status_str = Integer.toString(status);

		String key = "Advertiser_" + adver.getAdvertiser_id();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);

		jedis.hmset(key, map);

		ManageUser user = userrepo.findById(advertiser_id).orElse(null);
		user.setStatus(1);
		userrepo.save(user);

		api.setMessage("Advertiser UnBlocked Successfully");
		api.setMsgCode("ADVERTISER UNBLOCKED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse deleteAdvertiser(AdvertiserDeleteDTO delete) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Advertriser add = repo.findById(delete.getAdvertiser_id()).orElse(null);
		if (add == null) {
			err.setCode("Given Advertiser Is Not Present In Database");
			api.setError(err);
			api.setMessage("Advertiser Is Not Present");
			api.setMsgCode("ADVERTISER IS NOT PRESENT");
			return api;
		}
		if (add.getIs_deleted() == 1) {
			err.setCode("Cannot Delete The Deleted Advertiser");
			api.setError(err);
			api.setMessage("Advertiser Is Already Deleted");
			api.setMsgCode("ADVERTISER IS ALREADY DELETED");
			return api;
		}
		add.setIs_deleted(1);
		add.setDeleted_at(LocalDateTime.now());
		add.setDeleted_by(delete.getDeleted_by());
		repo.save(add);

		AdvertiserRedis redis = new AdvertiserRedis();

		redis.setIs_deleted(add.getIs_deleted());
		int is_deleted = redis.getIs_deleted();
		String is_deleted_str = Integer.toString(is_deleted);

		redis.setDeleted_at(add.getDeleted_at());
		LocalDateTime deleted_at = redis.getDeleted_at();
		String[] arr1 = new String[2];

		arr1[0] = deleted_at.toString();

		arr1[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String deleted_at_str = Arrays.toString(arr1);

		redis.setDeleted_by(add.getDeleted_by());
		UUID deleted_by = redis.getDeleted_by();
		String deleted_by_str = deleted_by.toString();

		String key = "Advertiser_" + add.getAdvertiser_id();

		Map<String, String> map = new HashMap<>();
		map.put("is_deleted", is_deleted_str);
		map.put("deleted_at", deleted_at_str);
		map.put("deleted_by", deleted_by_str);

		jedis.hmset(key, map);

		ManageUser user = userrepo.findById(delete.getAdvertiser_id()).orElse(null);
		user.setIs_deleted(1);
		user.setDeleted_at(LocalDateTime.now());
		user.setDeleted_by(delete.getDeleted_by());
		userrepo.save(user);

		api.setData(add);
		api.setMessage("Advertiser deleted Successfully");
		api.setMsgCode("ADVERTRISER DELETED SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getbyid(UUID advertiser_id) {
		APIResponse api = new APIResponse();

		Advertriser add = repo.findById(advertiser_id).orElse(null);

		AdvertiserResponseDTO response = MapToDto(add);

		api.setData(response);
		api.setMessage("Advertriser Get SuccessFully");
		api.setMsgCode("ADVERTRISER GET SUCCESSFULLY");
		return api;
	}

}
