package com.example.demo.service.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.common.FilterResponse;
import com.example.demo.common.PageDetails;
import com.example.demo.common.PageResponse;
import com.example.demo.dto.AdunitDeleteDTO;
import com.example.demo.dto.AdunitResponseDTO;
import com.example.demo.dto.AdunitUpdateDTO;
import com.example.demo.dto.AdunitsCreateDTO;
import com.example.demo.dto.AdunitsFilterRequest;
import com.example.demo.entity.ADFORMAT;
import com.example.demo.entity.AdunitFilterEntity;
import com.example.demo.entity.Adunits;
import com.example.demo.entity.Configurations;
import com.example.demo.entity.Environment;
import com.example.demo.entity.ManageUser;
import com.example.demo.entity.Publisher;
import com.example.demo.entity.Roles;
import com.example.demo.entity.Site;
import com.example.demo.redisentity.AdunitRedis;
import com.example.demo.repository.AdunitRepository;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.repository.EnvironmentRepo;
import com.example.demo.repository.ManageUserRepository;
import com.example.demo.repository.PublisherRepo;
import com.example.demo.repository.RolesRepository;
import com.example.demo.repository.SiteRepository;
import com.example.demo.service.AdunitService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import redis.clients.jedis.Jedis;

@Service
public class AdunitServiceImpl implements AdunitService {

	@Autowired
	private AdunitRepository adunitrepo;

	@Autowired
	private EnvironmentRepo envrepo;

	@Autowired
	private ConfigurationRepo configrepo;

	@Autowired
	private PublisherRepo pubrepo;

	@Autowired
	private ManageUserRepository userrepo;

	@Autowired
	private RolesRepository rolerepo;

	@Autowired
	private Jedis jedis;

	@Autowired
	private SiteRepository siterepo;

	@Override
	public APIResponse createadunit(AdunitsCreateDTO create) throws JsonProcessingException {
		APIResponse api = new APIResponse();

		Adunits adu = new Adunits();
		adu.setName(create.getName());
		adu.setAdunit_type(create.getAdunit_type());
		adu.setEnv_type(create.getEnv_type());
		adu.setFloor_price(create.getFloor_price());
		adu.setPublisher_id(create.getPublisher_id());
		adu.setBanner_size(create.getBanner_size());
		adu.setSite_id(create.getSite_id());
		adu.setStatus(1);
		adu.setCreated_at(LocalDateTime.now());
		adu.setCreated_by(create.getCreated_by());
		adu.setUpdated_at(LocalDateTime.now());
		
		ObjectMapper mapper = new ObjectMapper();
		String srcstring = mapper.writeValueAsString(create.getAuction_type());
        adu.setAuction_type(srcstring);
        
		adunitrepo.save(adu);

		AdunitRedis adunitredis = new AdunitRedis();

		adunitredis.setAdunit_id(adu.getAdunit_id());
		UUID id = adunitredis.getAdunit_id();
		String id_str = id.toString();

		adunitredis.setName(adu.getName());
		String name_str = adunitredis.getName();

		adunitredis.setPublisher_id(adu.getPublisher_id());
		UUID publisher_id = adunitredis.getPublisher_id();
		String publisher_id_str = publisher_id.toString();

		String site_id_str = null;
		if (adu.getSite_id() != null) {
			adunitredis.setSite_id(adu.getSite_id());
			UUID site_id = adunitredis.getSite_id();
			site_id_str = site_id.toString();
		}

		String banner_size_str = null;
		if (adu.getBanner_size() != null) {
			adunitredis.setBanner_size(adu.getBanner_size());
			UUID banner_size = adunitredis.getBanner_size();
			banner_size_str = banner_size.toString();
		}
		adunitredis.setAdunit_type(adu.getAdunit_type());
		ADFORMAT adunit_type = adunitredis.getAdunit_type();
		String adunit_type_str = adunit_type.toString();

		adunitredis.setEnv_type(adu.getEnv_type());
		int env_type = adunitredis.getEnv_type();
		String env_type_str = Integer.toString(env_type);
		
		String auction_type_str=null;
		if(adu.getAuction_type()!=null) {
		adunitredis.setAuction_type(adu.getAuction_type());
		auction_type_str = adunitredis.getAuction_type();
		}
		String floor_str = null;
		if (adu.getFloor_price() != null) {
			adunitredis.setFloor_price(adu.getFloor_price());
			floor_str = adunitredis.getFloor_price();
		}
		adunitredis.setStatus(adu.getStatus());
		int status = adunitredis.getStatus();
		String status_str = Integer.toString(status);

		adunitredis.setCreated_at(adu.getCreated_at());
		LocalDateTime created_at = adunitredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = created_at.toString();

		arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		adunitredis.setCreated_by(adu.getCreated_by());
		UUID created_by = adunitredis.getCreated_by();
		String created_by_str = created_by.toString();

		adunitredis.setUpdated_at(adu.getUpdated_at());
		LocalDateTime updated_at = adunitredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = updated_at.toString();

		arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr1);

		String Key = "Adunit_" + adu.getAdunit_id();
		Map<String, String> map = new HashMap<>();
		map.put("adunit_id", id_str);
		map.put("name", name_str);
		map.put("publisher_id", publisher_id_str);
		if (site_id_str != null) {
			map.put("site_id", site_id_str);
		}
		if (banner_size_str != null) {
			map.put("banner_size", banner_size_str);
		}
		if (floor_str != null) {
			map.put("floor_price", floor_str);
		}
		map.put("adunit_type", adunit_type_str);
		if(auction_type_str!=null) {
		map.put("auction_type", auction_type_str);
		}
		map.put("env_type", env_type_str);
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);

		jedis.hmset(Key, map);

		api.setData(adu);
		api.setMessage("Adunit_created_successfully");
		api.setMsgCode("ADUNIT_CREATED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse updateadunit(AdunitUpdateDTO update, UUID adunit_id) throws JsonProcessingException {
		APIResponse api = new APIResponse();

		Adunits adu = adunitrepo.findById(adunit_id).orElse(null);

		if (adu == null) {
			ErrorObj err = new ErrorObj();
			err.setCode("Given Adunit Is Not Present In DataBase");
			api.setError(err);
			api.setMessage("Adunit Not Present");
			api.setMsgCode("ADUNIT_NOT_PRESENT");
			return api;
		}

		adu.setName(update.getName());
		adu.setEnv_type(update.getEnv_type());
		adu.setFloor_price(update.getFloor_price());
		adu.setPublisher_id(update.getPublisher_id());
		adu.setSite_id(update.getSite_id());
		adu.setBanner_size(update.getBanner_size());
		adu.setAdunit_type(update.getAdunit_type());
		adu.setStatus(1);
		adu.setUpdated_at(LocalDateTime.now());
		adu.setUpdated_by(update.getUpdated_by());
		
		ObjectMapper mapper = new ObjectMapper();
		String srcstring = mapper.writeValueAsString(update.getAuction_type());
        adu.setAuction_type(srcstring);

		adunitrepo.save(adu);

		AdunitRedis adunitredis = new AdunitRedis();

		adunitredis.setAdunit_id(adu.getAdunit_id());
		UUID id = adunitredis.getAdunit_id();
		String id_str = id.toString();

		adunitredis.setName(adu.getName());
		String name_str = adunitredis.getName();

		adunitredis.setPublisher_id(adu.getPublisher_id());
		UUID publisher_id = adunitredis.getPublisher_id();
		String publisher_id_str = publisher_id.toString();

		String site_id_str = null;
		if (adu.getSite_id() != null) {
			adunitredis.setSite_id(adu.getSite_id());
			UUID site_id = adunitredis.getSite_id();
			site_id_str = site_id.toString();
		}
		
		String auction_type_str=null;
		if(adu.getAuction_type()!=null) {
		adunitredis.setAuction_type(adu.getAuction_type());
		auction_type_str = adunitredis.getAuction_type();
		}

		String banner_size_str = null;
		if (adu.getBanner_size() != null) {
			adunitredis.setBanner_size(adu.getBanner_size());
			UUID banner_size = adunitredis.getBanner_size();
			banner_size_str = banner_size.toString();
		}

		String floor_str = null;
		if (adu.getFloor_price() != null) {
			adunitredis.setFloor_price(adu.getFloor_price());
			floor_str = adunitredis.getFloor_price();
		}
		adunitredis.setAdunit_type(adu.getAdunit_type());
		ADFORMAT adunit_type = adunitredis.getAdunit_type();
		String adunit_type_str = adunit_type.toString();

		adunitredis.setEnv_type(adu.getEnv_type());
		int env_type = adunitredis.getEnv_type();
		String env_type_str = Integer.toString(env_type);

		adunitredis.setStatus(adu.getStatus());
		int status = adunitredis.getStatus();
		String status_str = Integer.toString(status);

		adunitredis.setCreated_at(adu.getCreated_at());
		LocalDateTime created_at = adunitredis.getCreated_at();

		String[] arr = new String[2];

		arr[0] = created_at.toString();

		arr[1] = created_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String created_at_str = Arrays.toString(arr);

		adunitredis.setCreated_by(adu.getCreated_by());
		UUID created_by = adunitredis.getCreated_by();
		String created_by_str = created_by.toString();

		adunitredis.setUpdated_at(adu.getUpdated_at());
		LocalDateTime updated_at = adunitredis.getUpdated_at();

		String[] arr1 = new String[2];

		arr1[0] = updated_at.toString();

		arr1[1] = updated_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String updated_at_str = Arrays.toString(arr1);

		adunitredis.setUpdated_by(adu.getUpdated_by());
		UUID updated_by = adunitredis.getUpdated_by();
		String updated_by_str = updated_by.toString();

		String Key = "Adunit_" + adu.getAdunit_id();
		Map<String, String> map = new HashMap<>();
		map.put("adunit_id", id_str);
		map.put("name", name_str);
		map.put("publisher_id", publisher_id_str);
		if (site_id_str != null) {
			map.put("site_id", site_id_str);
		}
		if (banner_size_str != null) {
			map.put("banner_size", banner_size_str);
		}
		if (floor_str != null) {
			map.put("floor_price", floor_str);
		}
		map.put("adunit_type", adunit_type_str);
		if(auction_type_str!=null) {
		map.put("auction_type", auction_type_str);
		}
		map.put("env_type", env_type_str);
		map.put("status", status_str);
		map.put("created_at", created_at_str);
		map.put("created_by", created_by_str);
		map.put("updated_at", updated_at_str);
		map.put("updated_by", updated_by_str);

		jedis.hmset(Key, map);

		api.setData(adu);
		api.setMessage("Adunit_updated_successfulluy");
		api.setMsgCode("ADUNIT_UPDATED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse blockadunit(UUID adunit_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();
		Adunits adu = adunitrepo.findById(adunit_id).orElse(null);
		if (adu == null) {
			err.setCode("Given Adunit Is Not Present In DateBase");
			api.setError(err);
			api.setMessage("Adunit Is Not Present");
			api.setMsgCode("ADUNIT IS NOT PRESENT");
			return api;
		}
		if (adu.getIs_deleted() == 1) {
			err.setCode("Cannot Block The Deleted Adunit");
			api.setError(err);
			api.setMessage("Deleted Adunit Cannot Be Blocked");
			api.setMsgCode("DELETED ADUNIT CANNOT BE BLOCKED");
			return api;
		}
		if (adu.getStatus() == 0) {
			err.setCode("Given Adunit Is Already InActive");
			api.setError(err);
			api.setMessage("Adunit Is Already Blocked");
			api.setMsgCode("ADUNIT IS ALREADY BLOCKED");
			return api;
		}
		adu.setStatus(0);
		adunitrepo.save(adu);

		AdunitRedis adunitredis = new AdunitRedis();

		adunitredis.setStatus(adu.getStatus());
		int status = adunitredis.getStatus();
		String status_str = Integer.toString(status);

		String Key = "Adunit_" + adu.getAdunit_id();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);

		jedis.hmset(Key, map);

		api.setMessage("Adunit_Blocked_Successfully");
		api.setMsgCode("ADUNIT_BLOCKED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse unblockadunit(UUID adunit_id) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();

		Adunits adu = adunitrepo.findById(adunit_id).orElse(null);
		if (adu == null) {
			err.setCode("Given Adunit Is Not Present In DateBase");
			api.setError(err);
			api.setMessage("Adunit Is Not Present");
			api.setMsgCode("ADUNIT IS NOT PRESENT");
			return api;
		}
		if (adu.getIs_deleted() == 1) {
			err.setCode("Cannot UnBlock The Deleted Adunit");
			api.setError(err);
			api.setMessage("Deleted Adunit Cannot Be UnBlocked");
			api.setMsgCode("DELETED ADUNIT CANNOT BE UNBLOCKED");
			return api;
		}
		if (adu.getStatus() == 1) {
			err.setCode("Given Adunit Is Already Active");
			api.setError(err);
			api.setMessage("Adunit Is Already UnBlocked");
			api.setMsgCode("ADUNIT IS ALREADY UNBLOCKED");
			return api;
		}
		adu.setStatus(1);
		adunitrepo.save(adu);

		AdunitRedis adunitredis = new AdunitRedis();

		adunitredis.setStatus(adu.getStatus());
		int status = adunitredis.getStatus();
		String status_str = Integer.toString(status);

		String Key = "Adunit_" + adu.getAdunit_id();
		Map<String, String> map = new HashMap<>();
		map.put("status", status_str);

		jedis.hmset(Key, map);

		api.setMessage("Adunit_Unblocked_Successfully");
		api.setMsgCode("ADUNIT_UNBLOCKED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse deleteadunit(AdunitDeleteDTO delete) {
		APIResponse api = new APIResponse();
		ErrorObj err = new ErrorObj();
		Adunits adu = adunitrepo.findById(delete.getAdunit_id()).orElse(null);
		if (adu == null) {
			err.setCode("Given Adunit Is Not Present In DataBase");
			api.setError(err);
			api.setMessage("Adunit Is Not Present");
			api.setMsgCode("ADUNIT IS NOT PRESENT");
			return api;
		}
		if (adu.getIs_deleted() == 1) {
			err.setCode("Cannot Delete The Deleted Adunit");
			api.setError(err);
			api.setMessage("Adunit Is Already Deleted");
			api.setMsgCode("ADUNIT IS ALREADY DELETED");
			return api;
		}
		adu.setIs_deleted(1);
		adu.setDeleted_at(LocalDateTime.now());
		adu.setDeleted_by(delete.getDeleted_by());
		adunitrepo.save(adu);

		AdunitRedis adunitredis = new AdunitRedis();

		adunitredis.setIs_deleted(adu.getIs_deleted());
		int is_deleted = adunitredis.getIs_deleted();
		String is_deleted_str = Integer.toString(is_deleted);

		adunitredis.setDeleted_at(adu.getDeleted_at());
		LocalDateTime deleted_at = adunitredis.getDeleted_at();

		String[] arr = new String[2];

		arr[0] = deleted_at.toString();

		arr[1] = deleted_at.format(DateTimeFormatter.ofPattern("hh:mm:ss a", Locale.ENGLISH));
		String deleted_at_str = Arrays.toString(arr);

		adunitredis.setDeleted_by(adu.getDeleted_by());
		UUID deleted_by = adunitredis.getDeleted_by();
		String deleted_by_str = deleted_by.toString();

		String Key = "Adunit_" + adu.getAdunit_id();
		Map<String, String> map = new HashMap<>();
		map.put("is_deleted", is_deleted_str);
		map.put("deleted_at", deleted_at_str);
		map.put("deleted_by", deleted_by_str);

		jedis.hmset(Key, map);

		api.setMessage("Adunit_deleted_successfully");
		api.setMsgCode("ADUNIT_DELETED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse getbyid(UUID adunit_id) {
		APIResponse api = new APIResponse();
		Adunits adu = adunitrepo.findById(adunit_id).orElse(null);
		AdunitResponseDTO response = MapToDto(adu);

		api.setData(response);
		api.setMessage("Adunit_Get_Successfully");
		api.setMsgCode("ADUNIT_GET_SUCCESSFULLY");
		return api;
	}

	private AdunitResponseDTO MapToDto(Adunits adu) {
		AdunitResponseDTO response = new AdunitResponseDTO();
		response.setAdunit_id(adu.getAdunit_id());
		response.setAdunit_name(adu.getName());
		response.setAdunit_type(adu.getAdunit_type());
		response.setBanner_size(adu.getBanner_size());
		response.setFloor_price(adu.getFloor_price());
        response.setAuction_type(adu.getAuction_type());
		if (adu.getSite_id() != null) {
			Site site = siterepo.findById(adu.getSite_id()).orElse(null);
			response.setSite_id(adu.getSite_id());
			response.setSite_name(site.getName());
			response.setCategory(site.getCategory());
		}

		Environment env = envrepo.findById(adu.getEnv_type()).orElse(null);
		response.setEnv_id(adu.getEnv_type());
		response.setEnv_type(env.getName());

		Publisher pub = pubrepo.findById(adu.getPublisher_id()).orElse(null);
		response.setPublisher_id(adu.getPublisher_id());
		response.setPublisher_name(pub.getWebsite());

		if (adu.getStatus() == 0) {
			response.setStatus("InActive");
		} else if (adu.getStatus() == 1) {
			response.setStatus("Active");
		}
		List<Configurations> allconfig = configrepo.findAll();
		Configurations obj = allconfig.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(obj.getConfigValue());
		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(adu.getCreated_at(), ZoneId.of("UTC-4")));

		response.setCreated_by(adu.getCreated_by());
		response.setCreated_at(arr1);

		String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(adu.getUpdated_at(), ZoneId.of("UTC-4")));

		response.setUpdated_at(arr2);
		response.setUpdated_by(adu.getUpdated_by());
        if(adu.getDeleted_at()!=null) {
			String arr3 = newYorkDateFormatter.format(ZonedDateTime.of(adu.getDeleted_at(), ZoneId.of("UTC-4")));
			response.setDeleted_at(arr3);
        }
		response.setDeleted_by(adu.getDeleted_by());
		response.setIs_deleted(adu.getIs_deleted());

		return response;

	}

	@Override
	public FilterResponse list(AdunitsFilterRequest filter, UUID user_id) {
		FilterResponse api = new FilterResponse();

		String field = null, order = null;
		if (filter.getSort() != null && filter.getSort().size() == 1) {
			for (Map.Entry m : filter.getSort().entrySet()) {
				field = (String) m.getKey();
				order = (String) m.getValue();
			}
		} else {

		}

		PageDetails pageing = filter.getPages();
		Pageable pageable = null;

		if (filter.getFilter() == null && filter.getPages() == null) {

			List<Adunits> adunit = null;
			List<AdunitResponseDTO> dto = null;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				adunit = adunitrepo.findAll();

			} else if (role.getRoletype().equals("PUBLISHER")) {
				adunit = adunitrepo.findbypublisher_id(user_id);
			}
			dto = adunit.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());
			api.setData(dto);
			return api;
		}

		if (filter.getPages() == null) {
			PageDetails pageing2 = new PageDetails();

			pageable = null;

			List<Adunits> adunit = null;
			List<AdunitResponseDTO> dto = null;
			int ResponseCount;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				adunit = adunitrepo.findAll();

			} else if (role.getRoletype().equals("PUBLISHER")) {
				adunit = adunitrepo.findbypublisher_id(user_id);
			}
			dto = adunit.stream().map(dt1 -> MapToDto(dt1)).collect(Collectors.toList());

			AdunitFilterEntity adunitFilter = filter.getFilter();
			List<UUID> adunitIdList = adunit.stream().map(adu -> adu.getAdunit_id()).collect(Collectors.toList());
			List<Adunits> filteredList = adunitrepo.getallDetails(adunitFilter.getName(),
					adunitFilter.getPublisher_id(), adunitFilter.getEnv_type(), adunitFilter.getAdunit_type(),
					adunitFilter.getStatus(), adunitFilter.getIs_deleted(), adunitIdList);
			List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getAdunit_id())
					.collect(Collectors.toList());
			ResponseCount = adunitrepo.getResultCount(filteredIdList);
			if (ResponseCount == 0) {
				ResponseCount = 10;
			}
			if (filter.getSort() == null || filter.getSort().size() == 0) {

				pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));
			} else {
				if (field.equals("") || order.equals("")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by("name"));

				}

				else if (order.equalsIgnoreCase("asc")) {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(0, ResponseCount, Sort.by(field).descending());
				}
			}

			List<Adunits> AdunitsListWithPage = adunitrepo.getFilteredListwithoutPage(filteredIdList, pageable)
					.getContent();
			dto = AdunitsListWithPage.stream().map(AdunitRes -> MapToDto(AdunitRes)).collect(Collectors.toList());

			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageSize(10);
			pageRes.setTotalCount(ResponseCount);
			api.setPage(pageRes);
			api.setData(dto);
			return api;
		}
		List<AdunitResponseDTO> adunitResList = null;

		// set 2 if filterRequest Page details not null

		int ResponseCount = 0;
		if (filter.getFilter() == null) {
			Page<Adunits> adunit = null;
			ManageUser user = userrepo.findById(user_id).orElse(null);
			Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
			if (role.getRoletype().equals("MASTER_ADMIN")) {
				adunit = adunitrepo.findAll(pageable);

			} else if (role.getRoletype().equals("PUBLISHER")) {
				adunit = adunitrepo.findbypublisher(user_id, pageable);
			}
			List<UUID> AdunitIdList = adunit.stream().map(camUni -> camUni.getAdunit_id()).collect(Collectors.toList());
			ResponseCount = adunitrepo.getResultCount(AdunitIdList);
			adunit = adunitrepo.getFilteredListwithoutPage(AdunitIdList, pageable);

			List<Adunits> ResContent = adunit.getContent();
			adunitResList = ResContent.stream().map(adunitRes -> MapToDto(adunitRes)).collect(Collectors.toList());
			PageResponse pageRes = new PageResponse();
			pageRes.setTotalCount(ResponseCount);
			pageRes.setPageCount(pageing.getPageIndex());
			if (pageing.getPageSize() == 0) {
				pageRes.setPageSize(10);
			} else {
				pageRes.setPageSize(pageing.getPageSize());
			}
			api.setData(adunitResList);
			api.setPage(pageRes);
			api.setMessage("AdunitList_With_Filter_2");
			api.setMsgCode("ADUNITLIST_WITH_FILTER_2");
			return api;
		}

		if (filter.getSort() == null || filter.getSort().size() == 0) {
			if (pageing.getPageSize() == 0) {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
			} else {
				pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by("name"));
			}
		} else {
			if (field.equals("") || order.equals("")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by("name"));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by("name"));
				}
			}

			else if (order.equalsIgnoreCase("asc")) {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field));
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(), Sort.by(field));
				}
			} else {
				if (pageing.getPageSize() == 0) {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), 10, Sort.by(field).descending());
				} else {
					pageable = (Pageable) PageRequest.of(pageing.getPageIndex(), pageing.getPageSize(),
							Sort.by(field).descending());
				}
			}
		}

		List<Adunits> adunit = null;
		ManageUser user = userrepo.findById(user_id).orElse(null);
		Roles role = rolerepo.findById(user.getRoleid()).orElse(null);
		if (role.getRoletype().equals("MASTER_ADMIN")) {
			adunit = adunitrepo.findAll();

		} else if (role.getRoletype().equals("PUBLISHER")) {
			adunit = adunitrepo.findbypublisher_id(user_id);
		}

		AdunitFilterEntity adunitFilter = filter.getFilter();
		List<UUID> adunitIdList = adunit.stream().map(cam -> cam.getAdunit_id()).collect(Collectors.toList());
		List<Adunits> filteredList = adunitrepo.getallDetails(adunitFilter.getName(), adunitFilter.getPublisher_id(),
				adunitFilter.getEnv_type(), adunitFilter.getAdunit_type(), adunitFilter.getStatus(),
				adunitFilter.getIs_deleted(), adunitIdList);
		List<UUID> filteredIdList = filteredList.stream().map(ids -> ids.getAdunit_id()).collect(Collectors.toList());
		ResponseCount = adunitrepo.getResultCount(filteredIdList);
		List<Adunits> adunitsFilteredContent = adunitrepo.getFilteredList(filteredIdList, pageable).getContent();
		adunitResList = adunitsFilteredContent.stream().map(campignRes -> MapToDto(campignRes))
				.collect(Collectors.toList());

		PageResponse pageRes = new PageResponse();
		pageRes.setTotalCount(ResponseCount);
		pageRes.setPageCount(pageing.getPageIndex());
		if (pageing.getPageSize() == 0) {
			pageRes.setPageSize(10);
		} else {
			pageRes.setPageSize(pageing.getPageSize());
		}
		api.setData(adunitResList);
		api.setPage(pageRes);
		api.setMessage("Filtered List of Adunits");
		api.setMsgCode("FILTERED_LIST_OF_ADUNITS");

		return api;

	}

}
