package com.example.demo.service.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.AdunitBidderDTO;
import com.example.demo.dto.AdunitBidderListDTO;
import com.example.demo.dto.BidderResponseDTO;
import com.example.demo.entity.AdunitBidder;
import com.example.demo.entity.Bidder;
import com.example.demo.entity.Configurations;
import com.example.demo.repository.AdunitBidderRepository;
import com.example.demo.repository.BidderRepository;
import com.example.demo.repository.ConfigurationRepo;
import com.example.demo.service.AdunitBidderService;

import redis.clients.jedis.Jedis;

@Service
public class AdunitBidderServiceImpl implements AdunitBidderService{

	@Autowired
	private AdunitBidderRepository repo;
	
	@Autowired
	private Jedis jedis;
	
	@Autowired
	private BidderRepository bidrepo;	
	
	@Autowired
	private ConfigurationRepo configrepo;

    @Override
	public APIResponse createlinking(AdunitBidderDTO link) {
		APIResponse api = new APIResponse();
		
		AdunitBidder adubid = new AdunitBidder();
		adubid.setAdunit_id(link.getAdunit_id());
		adubid.setBidder_id(link.getBidder_id());
		repo.save(adubid);
		
		String key = "Adunit_Bidder" + adubid.getAdunit_id();
		List<AdunitBidder> bidderList = repo.findbyadunitid(adubid.getAdunit_id());
		List<UUID> camapaignidlist = bidderList.stream().map(id -> id.getBidder_id()).collect(Collectors.toList());
		JSONArray ja = new JSONArray();
		for (UUID id : camapaignidlist) {
			JSONObject obj = new JSONObject();
			obj.put("bidder_id", id.toString());
			ja.add(obj);
		}
		Map<String, String> map = new HashMap<>();
		map.put("connectedbidder", ja.toString());
		jedis.hmset(key, map);

		api.setData(adubid);
		api.setMessage("Adunit_Bidder_Linked_Successfully");
		api.setMsgCode("ADUNIT_BIDDER_LINKED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse deletedlinking(AdunitBidderDTO unlink) {
		APIResponse api = new APIResponse();
		
		AdunitBidder adubid = repo.findbyadunitandbidder(unlink.getAdunit_id(),unlink.getBidder_id());
		repo.delete(adubid);
		
		String key ="Adunit_Bidder_"+unlink.getAdunit_id();
		jedis.del(key);
		
		List<AdunitBidder> dealList = repo.findbyadunitid(unlink.getAdunit_id());
		List<UUID> camapaignidlist = dealList.stream().map(id -> id.getBidder_id()).collect(Collectors.toList());
		JSONArray ja = new JSONArray();
		for (UUID id : camapaignidlist) {
			JSONObject obj = new JSONObject();
			obj.put("bidder_id", id.toString());
			ja.add(obj);
		}
		Map<String, String> map = new HashMap<>();
		map.put("connectedbidder", ja.toString());
		jedis.hmset(key, map);
		
		api.setData(unlink);
		api.setMessage("Adunit_Bidder_Unlinked_Successfully");
        api.setMsgCode("ADUNIT_BIDDER_UNLINKED_SUCCESSFULLY");
		return api;
	}

	@Override
	public APIResponse list(AdunitBidderListDTO list) {
		APIResponse api = new APIResponse();
		List<AdunitBidder> adubid = repo.findbyadunitid(list.getAdunit_id());
		List<BidderResponseDTO> response = adubid.stream().map(id->MapToDTO(id.getBidder_id())).collect(Collectors.toList());
		api.setData(response);
		api.setMessage("Bidder_List_Get_Successfully");
		api.setMsgCode("BIDDER_LIST_GET_SUCCESSFULLY");
		return api;
	}

	private BidderResponseDTO MapToDTO(UUID bidder_id) {
		BidderResponseDTO response = new BidderResponseDTO();
		Bidder bid = bidrepo.findById(bidder_id).orElse(null);
		response.setBidder_id(bid.getBidder_id());
		response.setBidder_code(bid.getBidder_code());
		response.setBidder_name(bid.getBidder_name());
		response.setBidder_parameters(bid.getBidder_parameters());
		
        List<Configurations> allObj = configrepo.findAll();
		Configurations config = allObj.get(0);
		DateTimeFormatter newYorkDateFormatter = DateTimeFormatter.ofPattern(config.getConfigValue());
		String arr = newYorkDateFormatter.format(ZonedDateTime.of(bid.getCreated_at(), ZoneId.of("UTC-4")));
        response.setCreated_at(arr);
		response.setCreated_by(bid.getCreated_by());
		
		String arr1 = newYorkDateFormatter.format(ZonedDateTime.of(bid.getUpdated_at(), ZoneId.of("UTC-4")));
        response.setUpdated_at(arr1);
        response.setUpdated_by(bid.getUpdated_by());
        
        if(bid.getDeleted_at()!=null) {
    	String arr2 = newYorkDateFormatter.format(ZonedDateTime.of(bid.getDeleted_at(), ZoneId.of("UTC-4")));
        response.setDeleted_at(arr2);
        }
        response.setIs_deleted(bid.getIs_deleted());
        response.setDeleted_by(bid.getDeleted_by());
		return response;
	}
}
