package com.example.demo.service;

import java.util.UUID;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.SiteCreateDTO;
import com.example.demo.dto.SiteDeleteDTO;
import com.example.demo.dto.SiteFilterEntity;
import com.example.demo.dto.SiteUpdateDTO;
import com.fasterxml.jackson.core.JsonProcessingException;

public interface SiteService {

	APIResponse createSite(SiteCreateDTO create) throws JsonProcessingException;

	APIResponse updateSite(SiteUpdateDTO update, UUID site_id) throws JsonProcessingException;

	APIResponse deleteSite(SiteDeleteDTO delete);

	APIResponse getbyid(UUID site_id);

	APIResponse getall();

	FilterResponse list(SiteFilterEntity filter);

}
