package com.example.demo.service;

import java.util.UUID;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.DspCreateDTO;
import com.example.demo.dto.DspDeleteDTO;
import com.example.demo.dto.DspFilterRequest;
import com.example.demo.dto.DspUpdateDTO;
import com.fasterxml.jackson.core.JsonProcessingException;

public interface DspService {

	APIResponse createdsp(DspCreateDTO create) throws JsonProcessingException;

	APIResponse updatedsp(DspUpdateDTO update, UUID adexchange_id) throws JsonProcessingException;

	APIResponse getbyId(UUID adexchange_id);

	APIResponse getall();

	APIResponse blockdsp(UUID adexchange_id);

	APIResponse unblockdsp(UUID adexchange_id);
	
	APIResponse deletedsp(DspDeleteDTO delete);
	
	FilterResponse list(DspFilterRequest filter);
	
	

}
