package com.example.demo.service;

import java.util.UUID;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.AdunitDeleteDTO;
import com.example.demo.dto.AdunitUpdateDTO;
import com.example.demo.dto.AdunitsCreateDTO;
import com.example.demo.dto.AdunitsFilterRequest;
import com.fasterxml.jackson.core.JsonProcessingException;

public interface AdunitService {

	APIResponse createadunit(AdunitsCreateDTO create) throws JsonProcessingException;

	APIResponse updateadunit(AdunitUpdateDTO update, UUID adunit_id) throws JsonProcessingException;

	APIResponse blockadunit(UUID adunit_id);

	APIResponse unblockadunit(UUID adunit_id);

	APIResponse deleteadunit(AdunitDeleteDTO delete);

	APIResponse getbyid(UUID adunit_id);

	FilterResponse list(AdunitsFilterRequest filter, UUID user_id);

}
