package com.example.demo.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;

import com.example.demo.entity.Site;

public class SiteTempCustomRepoImpl implements SiteTempCustomRepo {

	@Autowired
	public EntityManager em;

	@Override
	public List<Site> getallDetails(String name, List<String> categories, List<Integer> is_deleted, List<UUID> id) {
		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Site> cq = cb.createQuery(Site.class);
		Root<Site> sitetemp = cq.from(Site.class);

		List<Predicate> predicates = new ArrayList<>();

		Predicate namepredicate = null;

		if (name == null) {

		} else if (name != null) {
			namepredicate = cb.like(sitetemp.get("name"), "%" + name + "%");
			predicates.add(namepredicate);
		}
		if (categories == null) {

		} else if (categories.size() > 0) {
			List<Predicate> categoryPredicates = new ArrayList<>();
			for (String category : categories) {
				categoryPredicates.add(cb.like(sitetemp.get("category"), "%" + category + "%"));
			}
			Predicate categoryOrPredicate = cb.or(categoryPredicates.toArray(new Predicate[0]));
			predicates.add(categoryOrPredicate);
		}

		if (is_deleted == null) {

		} else if (is_deleted.size() > 0) {
			Expression<String> parentExpression = sitetemp.get("is_deleted");
			Predicate is_deletedPredicate = parentExpression.in(is_deleted);
			predicates.add(is_deletedPredicate);
		}
		if (id.size() >= 0) {
			Expression<String> parentExpression = sitetemp.get("site_id");
			Predicate idPredicate = parentExpression.in(id);
			predicates.add(idPredicate);
		}

		cq.where(predicates.toArray(new Predicate[0]));
		TypedQuery<Site> query = em.createQuery(cq);

		return query.getResultList();

	}

}
