package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.Publisher;
import com.example.demo.entity.Site;

public interface SiteRepository extends JpaRepository<Site, UUID>, SiteTempCustomRepo {

	@Query(nativeQuery = true, value = "SELECT * FROM app_sites where site_id IN (:siteid)")
	Page<Site> getFilteredListwithoutPage(@Param("siteid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_sites WHERE site_id  IN (:siteId)")
	int getResultCount(@Param("siteId") List<UUID> siteIdList);

	@Query(nativeQuery = true, value = "SELECT * FROM app_sites where site_id  IN (:siteid)")
	Page<Site> getFilteredList(@Param("siteid") List<UUID> siteid, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_sites where site_id  IN (:site_id)")
	List<Site> findbysite(@Param("site_id") UUID site_id);

	@Query(nativeQuery = true, value = "SELECT * FROM app_sites where site_id  IN (:site_id)")
	Page<Publisher> findbypublisher_id(@Param("site_id") UUID site_id, Pageable pageable);
	
	@Query(nativeQuery = true, value = "SELECT * FROM app_sites GROUPBY site_id LIMIT 5")
	List<Site> siteidreport();
	
	@Query(nativeQuery = true, value = "SELECT * FROM app_sites GROUPBY name LIMIT 5")
	List<Site> sitenamereport();
	
}
