package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.example.demo.entity.Roles;

public interface RolesRepository extends JpaRepository<Roles, UUID> {

	Roles findByRoletype(String roletype);

	Roles findByRoleid(UUID roleid);

	List<Roles> findByAccessLevel(int accessLevel);

	@Query(nativeQuery = true, value = "SELECT * FROM app_roles ORDER BY role_name")
	List<Roles> orderByRolename();

}
