package com.example.demo.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;

import com.example.demo.entity.Publisher;

public class PublisherTempCustomRepoImpl implements PublisherTempCustomRepo {

	@Autowired
	public EntityManager em;

	@Override
	public List<Publisher> getallDetails(String name, List<String> website, List<Integer> adblocker,
			List<Integer> status, List<Integer> is_deleted, List<UUID> id) {
		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Publisher> cq = cb.createQuery(Publisher.class);
		Root<Publisher> publishertemp = cq.from(Publisher.class);

		List<Predicate> predicates = new ArrayList<>();

		Predicate namepredicate = null;

		if (name == null) {

		} else if (name != null) {
			namepredicate = cb.like(publishertemp.get("name"), "%" + name + "%");
			predicates.add(namepredicate);
		}

		if (website == null) {

		} else if (website.size() > 0) {
			Expression<String> parentExpression = publishertemp.get("website");
			Predicate paymentPredicate = parentExpression.in(website);
			predicates.add(paymentPredicate);

		}

		Predicate statusPredicate = null;
		Predicate isdeletePredicate = null;
		Predicate statusAndDelete = null;
		Predicate statusAndDelete1 = null;
		if (status != null && is_deleted != null && status.size() > 0 && is_deleted.size() > 0) {

			if (status.size() > 0) {

				Expression<String> parentExpression = publishertemp.get("status");
				statusPredicate = parentExpression.in(status);
				statusAndDelete = statusPredicate;

			}

			if (is_deleted.size() > 0) {

				Expression<String> parentExpression = publishertemp.get("is_deleted");
				if (is_deleted.contains(1)) {
					isdeletePredicate = parentExpression.in(1);
				} else {
					isdeletePredicate = parentExpression.in(0);
				}
				statusAndDelete = isdeletePredicate;

			}
			if (status.size() > 0 && is_deleted.size() > 0) {
				statusAndDelete = cb.or(statusPredicate, isdeletePredicate);
			}

			if (!is_deleted.contains(1)) {// statusAndDelete
				statusAndDelete1 = cb.and(statusPredicate, isdeletePredicate);
				predicates.add(statusAndDelete1);
			} else {
				predicates.add(statusAndDelete);
			}

		} else {
			if (status == null) {

			} else if (status.size() > 0) {

				Expression<String> parentExpression = publishertemp.get("status");
				statusPredicate = parentExpression.in(status);
				statusAndDelete = statusPredicate;
				predicates.add(statusAndDelete);
			}

			if (is_deleted == null) {

			} else if (is_deleted.size() > 0) {

				Expression<String> parentExpression = publishertemp.get("is_deleted");
				isdeletePredicate = parentExpression.in(is_deleted);
				statusAndDelete = isdeletePredicate;
				predicates.add(statusAndDelete);
			}
		}

		if (id.size() >= 0) {
			Expression<String> parentExpression = publishertemp.get("id");
			Predicate idPredicate = parentExpression.in(id);
			predicates.add(idPredicate);
		}
		cq.where(predicates.toArray(new Predicate[0]));
		TypedQuery<Publisher> query = em.createQuery(cq);

		return query.getResultList();
	}

}
