package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.Publisher;

public interface PublisherRepo extends JpaRepository<Publisher, UUID>, PublisherTempCustomRepo {

	@Query(nativeQuery = true, value = "Select * from app_publisher where email = :email")
	Publisher findbyemail(String email);

	@Query(nativeQuery = true, value = "SELECT * FROM app_publisher where publisher_id IN (:publisherid)")
	Page<Publisher> getFilteredListwithoutPage(@Param("publisherid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_publisher WHERE publisher_id  IN (:publisherId)")
	int getResultCount(@Param("publisherId") List<UUID> publisherIdList);

	@Query(nativeQuery = true, value = "SELECT * FROM app_publisher where publisher_id  IN (:publisherid)")
	Page<Publisher> getFilteredList(@Param("publisherid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_publisher where publisher_id  IN (:publisher_id)")
	List<Publisher> findbypublisher(@Param("publisher_id") UUID publisher_id);

	@Query(nativeQuery = true, value = "SELECT * FROM app_publisher where publisher_id  IN (:publisher_id)")
	Page<Publisher> findbypublisher_id(@Param("publisher_id") UUID publisher_id, Pageable pageable);

	@Query(nativeQuery = true, value ="SELECT * FROM app_publisher WHERE publisher_id IS NOT NULL LIMIT 5")
	List<Publisher> publisheridreport();
	
	@Query(nativeQuery = true, value = "SELECT * FROM app_publisher GROUP BY name LIMIT 5")
	List<Publisher> publishernamereport();
	
	@Query(nativeQuery = true , value ="SELECT * FROM app_publisher GROUP BY status LIMIT 5")
	List<Publisher> publisherStatusreport();
	
	@Query(nativeQuery = true,value="SELECT * FROM app_publisher GROUP BY publisher_id Limit 5")
	List<Publisher> findbypublisher();

}
