package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.dto.PaymentHisDTO;
import com.example.demo.entity.Payment;

public interface PaymentRepository extends JpaRepository<Payment,UUID>,PaymentCustomTempRepo{

	@Query(nativeQuery = true, value = "SELECT * FROM app_payment where advertiser_id  IN (:advertiser_id)")
	List<Payment> findbyadvertiser(@Param("advertiser_id") UUID advertiser_id);
	
	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_payment WHERE payment_id  IN (:paymentId)")
	int getResultCount(@Param("paymentId") List<UUID> paymentIdList);
	
	@Query(nativeQuery = true, value = "SELECT * FROM app_payment where payment_id IN (:paymentid)")
	Page<Payment> getFilteredListwithoutPage(@Param("paymentid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_payment where payment_id  IN (:payment_id)")
	Page<Payment> findbypayment_id(@Param("payment_id") UUID payment_id, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_payment where payment_id  IN (:paymentid)")
	Page<Payment> getFilteredList(@Param("paymentid") List<UUID> filteredId, Pageable pageable);
	
	@Query(nativeQuery = true,value ="SELECT Sum(deposite_amount) As deposite_amount,Sum(spend_amount) As spend_amount,advertiser_id,payment_id,deposite_date,payment_type,user_id,status FROM app_payment GROUP BY advertiser_id")
	List<Payment> paymentamount();
	
	@Query(nativeQuery = true,value="SELECT * FROM app_payment GROUP BY advertiser_id")
	List<Payment> findbyDeposite();

}
