package com.example.demo.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;

import com.example.demo.entity.Payment;

public class PaymentCustomTempRepoImpl implements PaymentCustomTempRepo{

	@Autowired
	private EntityManager em;

	@Override
	public List<Payment> getallDetails(List<Integer> status, List<String> payment_type,List<UUID> id) {
		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Payment> cq = cb.createQuery(Payment.class);
		Root<Payment> paymenttemp = cq.from(Payment.class);

		List<Predicate> predicates = new ArrayList<>();

		Predicate statuspredicate =null;
		
		if(status==null) {
			
		}
		else if(status!=null) {
		 Expression<String> parentExpression = paymenttemp.get("status");
		 statuspredicate = parentExpression.in(status);
		 predicates.add(statuspredicate);
		}
		
		Predicate paymenttypepredicate = null;
		
		if(payment_type==null) {
			
		}
		else if(payment_type!=null) {
		 Expression<String> parentExpression = paymenttemp.get("payment_type");
		 paymenttypepredicate = parentExpression.in(payment_type);
		 predicates.add(paymenttypepredicate);
		}
		
		if(id.size() >=0) {
		  Expression<String> parentExpression = paymenttemp.get("payment_id");
		  Predicate idpredicate = parentExpression.in(id);
		  predicates.add(idpredicate);
		}
		cq.where(predicates.toArray(new Predicate[0]));
		TypedQuery<Payment> query = em.createQuery(cq);

		return query.getResultList();

	}

}
