package com.example.demo.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;

import com.example.demo.entity.ADFORMAT;
import com.example.demo.entity.ADTYPE;
import com.example.demo.entity.Creative;

public class CreativeTempCustomRepoImpl implements CreativeTempCustomRepo {

	@Autowired
	private EntityManager em;

	@Override
	public List<Creative> getallDetails(String name, List<Integer> creative_type, List<String> ad_format,
			List<String> ad_type, List<UUID> campaign_id, List<UUID> banner_size, List<Integer> status,
			List<Integer> is_deleted, List<UUID> idList) {

		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Creative> cq = cb.createQuery(Creative.class);
		Root<Creative> creativetemp = cq.from(Creative.class);

		List<Predicate> predicates = new ArrayList<>();

		Predicate namepredicate = null;

		if (name == null) {

		} else if (name != null) {
			namepredicate = cb.like(creativetemp.get("name"), "%" + name + "%");
			predicates.add(namepredicate);
		}
		if (creative_type == null) {

		} else if (creative_type.size() > 0) {
			Expression<String> parentExpression = creativetemp.get("creative_type");
			Predicate creativePredicate = parentExpression.in(creative_type);
			predicates.add(creativePredicate);
		}
		if (ad_format == null) {

		} else if (ad_format.size() > 0) {

			List<ADFORMAT> adformats = new ArrayList<>();
			for (String str : ad_format) {
				if (str.equalsIgnoreCase("Banner")) {
					ADFORMAT banner = ADFORMAT.Banner;
					adformats.add(banner);
				}
				if (str.equalsIgnoreCase("Video")) {
					ADFORMAT video = ADFORMAT.Video;
					adformats.add(video);
				}
			}
			Expression<String> parentExpression = creativetemp.get("adformat");
			Predicate adformatePredicate = parentExpression.in(adformats);
			predicates.add(adformatePredicate);
		}
		if (ad_type == null) {
		} else if (ad_type.size() > 0) {
			List<ADTYPE> adTypeList = new ArrayList<>();
			for (String str : ad_type) {
				if (str.equalsIgnoreCase("B_IMG")) {

					ADTYPE b_img = ADTYPE.B_IMG;
					adTypeList.add(b_img);
				}

				if (str.equalsIgnoreCase("B_HTML")) {

					ADTYPE b_html = ADTYPE.B_HTML;
					adTypeList.add(b_html);
				}
				if (str.equalsIgnoreCase("B_TAG")) {

					ADTYPE b_tag = ADTYPE.B_TAG;
					adTypeList.add(b_tag);
				}

				if (str.equalsIgnoreCase("V_LINEAR")) {

					ADTYPE v_linear = ADTYPE.V_LINEAR;
					adTypeList.add(v_linear);
				}
				if (str.equalsIgnoreCase("V_VAST")) {

					ADTYPE v_vast = ADTYPE.V_VAST;
					adTypeList.add(v_vast);
				}
			}

			Expression<String> parentExpression = creativetemp.get("adtype");
			Predicate adtypePredicate = parentExpression.in(adTypeList);
			predicates.add(adtypePredicate);
		}
		if (campaign_id == null) {

		} else if (campaign_id.size() > 0) {
			Expression<String> parentExpression = creativetemp.get("campaign_id");
			Predicate campaignPredicate = parentExpression.in(campaign_id);
			predicates.add(campaignPredicate);
		}
		if (banner_size == null) {

		} else if (banner_size.size() > 0) {
			Expression<String> parentExpression = creativetemp.get("banner_size");
			Predicate bannerprediate = parentExpression.in(banner_size);
			predicates.add(bannerprediate);
		}

		Predicate isdeletePredicate = null;

		if (is_deleted == null) {

		}

		else if (is_deleted.size() > 0) {

			Expression<String> parentExpression = creativetemp.get("is_deleted");
			isdeletePredicate = parentExpression.in(is_deleted);
			predicates.add(isdeletePredicate);
		}

		if (idList.size() >= 0) {
			Expression<String> parentExpression = creativetemp.get("creative_id");
			Predicate idPredicate = parentExpression.in(idList);
			predicates.add(idPredicate);
		}
		cq.where(predicates.toArray(new Predicate[0]));
		TypedQuery<Creative> query = em.createQuery(cq);

		return query.getResultList();
	}

}
