package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.Creative;

public interface CreativeRepository extends JpaRepository<Creative, UUID>, CreativeTempCustomRepo {

	@Query(nativeQuery = true, value = "SELECT * FROM app_creative where creative_id IN (:creativeid)")
	Page<Creative> getFilteredListwithoutPage(@Param("creativeid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_creative WHERE creative_id IN (:CreativeId)")
	int getResultCount(@Param("CreativeId") List<UUID> CreativeIdList);

	@Query(nativeQuery = true, value = "SELECT * FROM app_creative where creative_id IN (:creativeid)")
	Page<Creative> getFilteredList(@Param("creativeid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_creative WHERE campign_id IN (:campign_id)")
	List<Creative> finbbycampaign_id(@Param("campign_id") List<UUID> campign_id);

	@Query(nativeQuery = true, value = "SELECT * FROM app_creative WHERE campign_id IN (:campign_id)")
	Page<Creative> finbbycampaign(@Param("campign_id") List<UUID> campign_id, Pageable pageable);

}
